/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.org;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Proc5;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.game.org.IAuth;
import org.slingerxv.limitart.game.org.Job;
import org.slingerxv.limitart.game.org.OrgMember;
import org.slingerxv.limitart.game.org.authes.ChangeJobAuth;
import org.slingerxv.limitart.game.org.exception.AlreadyJoinException;
import org.slingerxv.limitart.game.org.exception.AuthIDErrorException;
import org.slingerxv.limitart.game.org.exception.CreatorCanNotQuitException;
import org.slingerxv.limitart.game.org.exception.JobIDDuplicatedException;
import org.slingerxv.limitart.game.org.exception.JobIDErrorException;
import org.slingerxv.limitart.game.org.exception.JobMemberMaxException;
import org.slingerxv.limitart.game.org.exception.JobNameEmptyException;
import org.slingerxv.limitart.game.org.exception.JobNotExistException;
import org.slingerxv.limitart.game.org.exception.NoAuthException;
import org.slingerxv.limitart.game.org.exception.OrgMaxMemberException;
import org.slingerxv.limitart.game.org.exception.OrgMemberNotExistException;
import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.StringUtil;

@Beta
public abstract class Org {
    private long OrgId;
    private long creatorId;
    private Map<Integer, Job> jobs = new ConcurrentHashMap<Integer, Job>();
    private Map<Long, OrgMember> members = new ConcurrentHashMap<Long, OrgMember>();
    private transient Proc3<Org, OrgMember, OrgMember> onChangeCreator;
    private transient Proc5<Org, OrgMember, OrgMember, Job, Job> onChangeJob;
    private transient Proc2<Org, OrgMember> onQuit;
    private transient Proc2<Org, OrgMember> onJoin;
    private transient Proc2<Org, Job> onAddJob;
    private transient Proc2<Org, Job> onRemoveJob;

    public Org initOrg(long orgId, OrgMember creator) throws AlreadyJoinException, OrgMaxMemberException {
        this.OrgId = orgId;
        this.creatorId = creator.getMemberId();
        this.join(creator);
        return this;
    }

    public Org registerJob(OrgMember handler, Job job) throws JobIDDuplicatedException, NoAuthException, JobNameEmptyException, JobIDErrorException {
        if (handler.getMemberId() != this.creatorId) {
            throw new NoAuthException();
        }
        if (StringUtil.isEmptyOrNull(job.getJobName())) {
            throw new JobNameEmptyException();
        }
        if (job.getJobId() == 0) {
            throw new JobIDErrorException();
        }
        if (this.jobs.containsKey(job.getJobId())) {
            throw new JobIDDuplicatedException();
        }
        this.jobs.put(job.getJobId(), job);
        Procs.invoke(this.onAddJob, this, job);
        return this;
    }

    public Org unregisterJob(OrgMember handler, int jobId) throws NoAuthException, JobMemberMaxException, AuthIDErrorException, JobNotExistException {
        if (handler.getMemberId() != this.creatorId) {
            throw new NoAuthException();
        }
        Job remove = this.jobs.remove(jobId);
        if (remove != null) {
            Procs.invoke(this.onRemoveJob, this, remove);
            for (OrgMember member : this.members.values()) {
                this.giveMemberJob(handler, member, 0);
            }
        }
        return this;
    }

    public Org join(OrgMember member) throws AlreadyJoinException, OrgMaxMemberException {
        if (this.members.containsKey(member.getMemberId())) {
            throw new AlreadyJoinException();
        }
        if (this.getMemberCount() >= this.capacity()) {
            throw new OrgMaxMemberException();
        }
        this.members.put(member.getMemberId(), member);
        Procs.invoke(this.onJoin, this, member);
        return this;
    }

    public Org scanMember(Proc1<OrgMember> listener) {
        for (OrgMember member : this.members.values()) {
            listener.run(member);
        }
        return this;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public Org quit(OrgMember member) throws CreatorCanNotQuitException {
        if (member.getMemberId() == this.creatorId) {
            throw new CreatorCanNotQuitException();
        }
        OrgMember remove = this.members.remove(member.getMemberId());
        if (remove != null) {
            Procs.invoke(this.onQuit, this, remove);
        }
        return this;
    }

    public Org replaceCreator(long handlerId, long extenderId) throws NoAuthException, OrgMemberNotExistException {
        if (handlerId != this.creatorId) {
            throw new NoAuthException();
        }
        this.forceRepalceCreator(extenderId);
        return this;
    }

    public Org forceRepalceCreator(long extenderId) throws OrgMemberNotExistException {
        OrgMember orgMember = this.getOrgMember(extenderId);
        if (orgMember == null) {
            throw new OrgMemberNotExistException();
        }
        OrgMember oldCreator = this.getOrgMember(this.creatorId);
        this.creatorId = extenderId;
        Procs.invoke(this.onChangeCreator, this, oldCreator, orgMember);
        return this;
    }

    public Org giveMemberJob(OrgMember handler, OrgMember target, int jobId) throws AuthIDErrorException, NoAuthException, JobNotExistException, JobMemberMaxException {
        if (!this.hasAuth(new ChangeJobAuth(), handler, target)) {
            throw new NoAuthException();
        }
        Job job = this.getJob(jobId);
        if (job == null && jobId != 0) {
            throw new JobNotExistException();
        }
        int jobMemberCount = this.getJobMemberCount(jobId);
        if (job != null && jobMemberCount >= job.getMaxMember()) {
            throw new JobMemberMaxException();
        }
        int oldJobId = target.getJobId();
        target.setJobId(jobId);
        Procs.invoke(this.onChangeJob, this, handler, target, this.getJob(oldJobId), job);
        return this;
    }

    private Job getJob(int jobId) {
        return this.jobs.get(jobId);
    }

    public int getJobMemberCount(int jobId) {
        int count = 0;
        for (OrgMember member : this.members.values()) {
            if (member.getJobId() != jobId) continue;
            ++count;
        }
        return count;
    }

    public OrgMember getOrgMember(long memberId) {
        return this.members.get(memberId);
    }

    protected boolean hasAuth(IAuth auth, OrgMember handler, OrgMember target) throws AuthIDErrorException {
        if (handler.getMemberId() == this.creatorId) {
            return true;
        }
        if (target.getMemberId() == this.creatorId && handler.getMemberId() != this.creatorId) {
            return false;
        }
        Job job = this.getJob(handler.getJobId());
        if (job == null) {
            return false;
        }
        Job job2 = this.getJob(target.getJobId());
        if (job2 != null && job.getJobClass() < job2.getJobClass()) {
            return false;
        }
        return job.hasAuth(auth);
    }

    public long getOrgId() {
        return this.OrgId;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public Org onChangeCreator(Proc3<Org, OrgMember, OrgMember> listener) {
        this.onChangeCreator = listener;
        return this;
    }

    public Org onChangeJob(Proc5<Org, OrgMember, OrgMember, Job, Job> listener) {
        this.onChangeJob = listener;
        return this;
    }

    public Org onQuit(Proc2<Org, OrgMember> listener) {
        this.onQuit = listener;
        return this;
    }

    public Org onJoin(Proc2<Org, OrgMember> listener) {
        this.onJoin = listener;
        return this;
    }

    public Org onAddJob(Proc2<Org, Job> listener) {
        this.onAddJob = listener;
        return this;
    }

    public Org onRemoveJob(Proc2<Org, Job> listener) {
        this.onRemoveJob = listener;
        return this;
    }

    public abstract int capacity();
}

