/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.poker;

import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.RandomUtil;

@Beta
public class Poker {
    private static final byte CARD_COUNT = 52;
    private static final byte CARD_NUM_COUNT = 13;
    private static final byte CARD_SUIT_COUNT = 4;
    private static final byte[] STANDARD_POKER = new byte[52];
    public static final byte CARD_SUIT_SPADE = 1;
    public static final byte CARD_SUIT_HEART = 2;
    public static final byte CARD_SUIT_DIAMOND = 3;
    public static final byte CARD_SUIT_CLUB = 4;
    public static final byte CARD_NUM_JACK = 11;
    public static final byte CARD_NUM_QUEEN = 12;
    public static final byte CARD_NUM_KING = 13;
    public static final byte CARD_NUM_ACE = 14;
    public static final byte CARD_NUM_JOKER = 15;

    public static byte createCard(byte number, byte color) {
        return (byte)(number | color << 4);
    }

    public static byte[] createPoker() {
        byte[] template = new byte[52];
        System.arraycopy(STANDARD_POKER, 0, template, 0, STANDARD_POKER.length);
        return template;
    }

    public static byte[] createPokerWithJoker() {
        byte[] template = new byte[54];
        System.arraycopy(STANDARD_POKER, 0, template, 0, STANDARD_POKER.length);
        template[52] = Poker.createCard((byte)15, (byte)1);
        template[53] = Poker.createCard((byte)15, (byte)2);
        return template;
    }

    public static void shuffle(byte[] cards) {
        for (int oldIndex = 0; oldIndex < cards.length; ++oldIndex) {
            int newIndex = RandomUtil.randomInt(0, cards.length - 1);
            if (newIndex == oldIndex) continue;
            byte tempCard = cards[oldIndex];
            cards[oldIndex] = cards[newIndex];
            cards[newIndex] = tempCard;
        }
    }

    public static byte getCardNumber(byte value) {
        return (byte)(value & 0xF);
    }

    public static byte getCardColor(byte value) {
        return (byte)(value >> 4);
    }

    public static boolean isAce(byte card) {
        return Poker.getCardNumber(card) == 14;
    }

    public static boolean isJoker(byte card) {
        return Poker.isBigJoker(card) || Poker.isSmallJoker(card);
    }

    public static boolean isBigJoker(byte card) {
        return Poker.getCardNumber(card) == 15 && Poker.getCardColor(card) == 2;
    }

    public static boolean isSmallJoker(byte card) {
        return Poker.getCardNumber(card) == 15 && Poker.getCardColor(card) == 1;
    }

    public static boolean isSameSuit(byte card, byte anotherCard) {
        return (card & ~anotherCard) >> 4 == 0;
    }

    public static boolean isSameNumber(byte card, byte anotherCard) {
        return (card & ~anotherCard & 0xF) == 0;
    }

    public static long cardsToLong(byte[] cards) {
        if (cards.length > 8) {
            throw new IllegalArgumentException("length <=8");
        }
        long longOfCards = 0L;
        for (int i = 0; i < cards.length; ++i) {
            longOfCards |= Byte.toUnsignedLong(cards[i]) << (i << 3);
        }
        return longOfCards;
    }

    public static byte[] longToCards(long value) {
        int pos = 0;
        byte[] temp = new byte[8];
        while ((temp[pos] = (byte)(value >> (pos << 3) & 0xFFL)) != 0) {
            ++pos;
        }
        byte[] result = new byte[pos];
        System.arraycopy(temp, 0, result, 0, result.length);
        return result;
    }

    public static String toString(byte card) {
        byte number = Poker.getCardNumber(card);
        byte color = Poker.getCardColor(card);
        String suit = null;
        if (color == 4) {
            suit = "\u6885\u82b1";
        } else if (color == 2) {
            suit = "\u7ea2\u6843";
        } else if (color == 3) {
            suit = "\u65b9\u5757";
        } else if (color == 1) {
            suit = "\u9ed1\u6843";
        }
        String num = null;
        num = number == 11 ? "J" : (number == 12 ? "Q" : (number == 13 ? "K" : (number == 14 ? "A" : number + "")));
        return num + "[" + suit + "]";
    }

    static {
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < 13; j = (int)((byte)(j + 1))) {
                Poker.STANDARD_POKER[13 * i + j] = Poker.createCard((byte)(j + 2), (byte)(i + 1));
            }
        }
    }
}

