/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.poker.texas;

import java.util.ArrayList;
import java.util.List;
import org.slingerxv.limitart.game.poker.Poker;
import org.slingerxv.limitart.game.poker.texas.TXCardRank;
import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.CollectionUtil;
import org.slingerxv.limitart.util.MathUtil;

@Beta
public class TXCardsCalculator {
    private static final long HIGH_CARD = (long)TXCardRank.HIGH_CARD.getValue() * 0x10000000000L;
    private static final long ONE_PAIR = (long)TXCardRank.ONE_PAIR.getValue() * 0x10000000000L;
    private static final long TWO_PAIR = (long)TXCardRank.TWO_PAIR.getValue() * 0x10000000000L;
    private static final long THREE_OF_A_KIND = (long)TXCardRank.THREE_OF_A_KIND.getValue() * 0x10000000000L;
    private static final long STRAIGHT = (long)TXCardRank.STRAIGHT.getValue() * 0x10000000000L;
    private static final long FLUSH = (long)TXCardRank.FLUSH.getValue() * 0x10000000000L;
    private static final long FULL_HOUSE = (long)TXCardRank.FULL_HOUSE.getValue() * 0x10000000000L;
    private static final long FOUR_OF_A_KIND = (long)TXCardRank.FOUR_OF_A_KIND.getValue() * 0x10000000000L;
    private static final long STRAIGHT_FLUSH = (long)TXCardRank.STRAIGHT_FLUSH.getValue() * 0x10000000000L;
    private static final long ROYAL_FLUSH = (long)TXCardRank.ROYAL_FLUSH.getValue() * 0x10000000000L;
    private byte[] cards = null;
    private byte[] numbers = null;
    private byte[] colors = null;
    private byte pairCount = 0;
    private byte maxthreeOfAKindNumber = 0;
    private byte maxFourOfAKindNumber = 0;
    private byte maxNumberOfStraight = 0;
    private byte flush = 0;
    private long rank;
    private long evaluator;

    public static TXCardsCalculator calBestCards(byte[] tableCards, byte[] handCards) {
        ArrayList<Byte> sum = new ArrayList<Byte>();
        for (byte handCard : handCards) {
            sum.add(handCard);
        }
        for (byte tableCard : tableCards) {
            sum.add(tableCard);
        }
        List cnm = MathUtil.CNM(sum, 5);
        long maxValue = 0L;
        TXCardsCalculator maxEval = null;
        for (List list : cnm) {
            TXCardsCalculator temp = new TXCardsCalculator(CollectionUtil.toByteArray(list));
            if (temp.getValue() <= maxValue) continue;
            maxEval = temp;
            maxValue = temp.getValue();
        }
        return maxEval;
    }

    public TXCardsCalculator(byte[] txCards) {
        int i;
        if (txCards.length != 2 && txCards.length != 5) {
            throw new IllegalArgumentException("the length must to be two or five");
        }
        this.numbers = new byte[txCards.length];
        this.colors = new byte[txCards.length];
        byte[] tempCards = new byte[txCards.length];
        System.arraycopy(txCards, 0, tempCards, 0, txCards.length);
        for (i = 0; i < tempCards.length; ++i) {
            byte card = tempCards[i];
            this.numbers[i] = Poker.getCardNumber(card);
            this.colors[i] = Poker.getCardColor(card);
        }
        this.statistics();
        if (this.isStraightFlush()) {
            if (this.maxNumberOfStraight == 14) {
                this.rank = ROYAL_FLUSH;
            }
        } else {
            this.compareRank();
        }
        for (i = 0; i < this.numbers.length; ++i) {
            for (int j = i + 1; j < this.numbers.length; ++j) {
                if (this.numbers[j] <= this.numbers[i]) continue;
                byte temp = this.numbers[i];
                this.numbers[i] = this.numbers[j];
                this.numbers[j] = temp;
                temp = this.colors[i];
                this.colors[i] = this.colors[j];
                this.colors[j] = temp;
                temp = tempCards[i];
                tempCards[i] = tempCards[j];
                tempCards[j] = temp;
            }
        }
        if (this.maxNumberOfStraight == 5) {
            byte[] newCards = new byte[tempCards.length];
            for (int k = 0; k < newCards.length; ++k) {
                newCards[k] = k == newCards.length - 1 ? tempCards[0] : tempCards[k + 1];
            }
            this.cards = newCards;
        } else {
            this.cards = tempCards;
        }
        this.evaluator = TXCardsCalculator.evaluator(this.rank, this.cards);
    }

    public static TXCardRank getCardRank(long evaluator, int cardCount) {
        return TXCardRank.getTXCardRank((int)(evaluator >> (cardCount << 3)));
    }

    public static long evaluator(long rank, byte[] txCards) {
        long evaluatorNum = rank;
        for (int i = 0; i < txCards.length; ++i) {
            evaluatorNum |= (long)Poker.getCardNumber(txCards[i]) << (txCards.length - i - 1 << 3);
        }
        return evaluatorNum;
    }

    public TXCardRank getRank() {
        return TXCardRank.getTXCardRank((int)(this.rank / 0x10000000000L));
    }

    public long getValue() {
        return this.evaluator;
    }

    public byte[] getCards() {
        return this.cards;
    }

    private void statistics() {
        int i;
        byte[] cardNumbers = new byte[13];
        byte[] cardColors = new byte[4];
        for (i = 0; i < this.numbers.length; ++i) {
            int n = this.numbers[i] - 2;
            cardNumbers[n] = (byte)(cardNumbers[n] + 1);
            int n2 = this.colors[i] - 1;
            cardColors[n2] = (byte)(cardColors[n2] + 1);
            if (cardColors[this.colors[i] - 1] < 5) continue;
            this.flush = this.colors[i];
        }
        block1: for (i = cardNumbers.length - 1; i >= 0; --i) {
            int j;
            if (cardNumbers[i] > 1) {
                for (j = 0; j < this.numbers.length; ++j) {
                    if (this.numbers[j] != i + 2) continue;
                    int n = j;
                    this.numbers[n] = (byte)(this.numbers[n] + 13);
                }
            }
            if (cardNumbers[i] == 2) {
                this.pairCount = (byte)(this.pairCount + 1);
            } else if (cardNumbers[i] == 3 && cardNumbers[i] > this.maxthreeOfAKindNumber) {
                this.maxthreeOfAKindNumber = (byte)(i + 2);
            } else if (cardNumbers[i] == 4 && cardNumbers[i] > this.maxFourOfAKindNumber) {
                this.maxFourOfAKindNumber = (byte)(i + 2);
            }
            j = i;
            while (i >= 3) {
                if (j == -1 && cardNumbers[cardNumbers.length - 1] > 0) {
                    this.maxNumberOfStraight = (byte)(i + 2);
                    continue block1;
                }
                if (j == -1 && cardNumbers[cardNumbers.length - 1] <= 0 || cardNumbers[j] <= 0) continue block1;
                if (j == i - 4) {
                    this.maxNumberOfStraight = (byte)(i + 2);
                    continue block1;
                }
                --j;
            }
        }
    }

    private void compareRank() {
        boolean hasRank;
        boolean bl = hasRank = this.isFourOfAKind() || this.isFullHouse() || this.isFlush() || this.isStraight() || this.isThreeOfAKind() || this.isTwoPair() || this.isOnePair();
        if (!hasRank) {
            this.rank = HIGH_CARD;
        }
    }

    private boolean isOnePair() {
        if (this.pairCount > 0) {
            this.rank = ONE_PAIR;
            return true;
        }
        return false;
    }

    private boolean isTwoPair() {
        if (this.pairCount > 1) {
            this.rank = TWO_PAIR;
            return true;
        }
        return false;
    }

    private boolean isThreeOfAKind() {
        if (this.maxthreeOfAKindNumber > 0) {
            this.rank = THREE_OF_A_KIND;
            return true;
        }
        return false;
    }

    private boolean isStraight() {
        if (this.maxNumberOfStraight > 0) {
            this.rank = STRAIGHT;
            return true;
        }
        return false;
    }

    private boolean isFlush() {
        if (this.flush > 0) {
            this.rank = FLUSH;
            return true;
        }
        return false;
    }

    private boolean isFullHouse() {
        if (this.maxthreeOfAKindNumber > 0 && this.pairCount > 0) {
            this.rank = FULL_HOUSE;
            return true;
        }
        return false;
    }

    private boolean isFourOfAKind() {
        if (this.maxFourOfAKindNumber > 0) {
            this.rank = FOUR_OF_A_KIND;
            return true;
        }
        return false;
    }

    private boolean isStraightFlush() {
        if (this.isStraight() && this.isFlush()) {
            this.rank = STRAIGHT_FLUSH;
            return true;
        }
        return false;
    }
}

