/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.statemachine;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.collections.ConstraintMap;
import org.slingerxv.limitart.game.statemachine.event.IEvent;
import org.slingerxv.limitart.game.statemachine.exception.StateException;
import org.slingerxv.limitart.game.statemachine.state.State;
import org.slingerxv.limitart.util.Beta;

@Beta
public class StateMachine {
    private static Logger log = LoggerFactory.getLogger(StateMachine.class);
    private Map<Integer, State> stateMap = new ConcurrentHashMap<Integer, State>();
    private Queue<Integer> stateQueue = new LinkedList<Integer>();
    private State preState;
    private State curState;
    private ConstraintMap<Object> params = ConstraintMap.empty();
    private long lastLoopTime = 0L;
    private int firstStateId;
    private Thread lastThread;

    public synchronized void start() throws StateException {
        if (this.curState != null) {
            throw new StateException("called once");
        }
        this.stateQueue.clear();
        this.params.clear();
        this.lastLoopTime = 0L;
        this.changeState(this.firstStateId);
    }

    public synchronized void firstState(int stateId) {
        this.firstStateId = stateId;
    }

    public StateMachine addState(State ... states) throws StateException {
        for (State temp : Objects.requireNonNull(states, "states")) {
            this.addState(temp);
        }
        return this;
    }

    public synchronized StateMachine addState(State state) throws StateException {
        Objects.requireNonNull(state, "state");
        Objects.requireNonNull(state.getStateId(), "stateId");
        if (this.stateMap.containsKey(state.getStateId())) {
            throw new StateException("stateId:" + state.getStateId() + " duplicated in this FSM !");
        }
        if (this.stateMap.isEmpty()) {
            this.firstState(state.getStateId());
        }
        this.stateMap.put(state.getStateId(), state);
        log.info("ADD:{}", (Object)state.getStateId());
        return this;
    }

    private StateMachine changeState(Integer stateId) throws StateException {
        Objects.requireNonNull(stateId, "stateId");
        if (this.curState != null && stateId.intValue() == this.curState.getStateId().intValue()) {
            return this;
        }
        if (!this.stateMap.containsKey(stateId)) {
            throw new StateException(MessageFormat.format("stateId:{0} does not exist !", stateId));
        }
        this.stateQueue.offer(stateId);
        log.debug("CHANGE:{}", (Object)stateId);
        return this;
    }

    public synchronized StateMachine reverse2PreState() throws StateException {
        if (this.preState != null) {
            this.changeState(this.preState.getStateId());
        }
        return this;
    }

    public synchronized void loop() throws StateException {
        Thread nowThread = Thread.currentThread();
        if (this.lastThread != null && !this.lastThread.equals(nowThread)) {
            throw new StateException("not allowed to run on a deferent thread,last:" + this.lastThread.getName() + ",now:" + nowThread.getName());
        }
        this.lastThread = nowThread;
        long now = System.currentTimeMillis();
        long deltaTimeInMills = this.lastLoopTime == 0L ? 0L : now - this.lastLoopTime;
        this.lastLoopTime = now;
        Integer nextNode = this.getNextNode();
        State next = null;
        if (nextNode != null) {
            next = this.stateMap.get(nextNode);
        }
        if (next != null) {
            if (this.curState != null) {
                this.curState.onExit(next, this);
                log.debug("EXIST:{}", (Object)this.curState.getStateId());
            }
            next.reset();
            log.debug("RESET:{}", (Object)next.getStateId());
            next.onEnter(this.curState, this);
            log.debug("ENTER:{}", (Object)next.getStateId());
            this.preState = this.curState;
            this.curState = next;
        }
        if (this.curState != null) {
            IEvent<StateMachine> con;
            if (!this.curState.finished()) {
                this.curState.execute0(deltaTimeInMills, this);
            }
            if ((con = this.curState.EventTrigger(this, deltaTimeInMills)) != null) {
                int nextNodeId = con.getNextStateId();
                if (!this.stateMap.containsKey(nextNodeId)) {
                    throw new StateException(MessageFormat.format("condition:{0} in state:{1}, it's next stateId:{2} does't exist in this FSM !", con.getClass().getSimpleName(), this.curState.getClass().getSimpleName(), con.getNextStateId()));
                }
                this.changeState(nextNodeId);
            }
        }
    }

    public State getCurrentState() {
        return this.curState;
    }

    public State getPreState() {
        return this.preState;
    }

    public ConstraintMap<Object> getParams() {
        return this.params;
    }

    private Integer getNextNode() {
        if (this.stateQueue.size() < 1) {
            return null;
        }
        return this.stateQueue.poll();
    }
}

