/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.game.statemachine.state;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slingerxv.limitart.funcs.Proc;
import org.slingerxv.limitart.game.statemachine.StateMachine;
import org.slingerxv.limitart.game.statemachine.event.IEvent;
import org.slingerxv.limitart.game.statemachine.event.impl.FinishedEvent;

public abstract class State<T extends StateMachine> {
    private List<IEvent<T>> conditions = new LinkedList<IEvent<T>>();
    private List<Ticker> tickers = new LinkedList<Ticker>();
    private boolean finished = false;
    private long executedTime;

    public abstract Integer getStateId();

    protected void tick(long delay, int times, Proc listener) {
        this.tickers.add(new Ticker(delay, times, listener));
    }

    public abstract void onEnter(State<T> var1, T var2);

    public abstract void onExit(State<T> var1, T var2);

    public void execute0(long deltaTimeInMills, T fsm) {
        Iterator<Ticker> iterator = this.tickers.iterator();
        while (iterator.hasNext()) {
            Ticker ticker;
            Ticker ticker2 = ticker = iterator.next();
            ticker2.delayCounter = ticker2.delayCounter + deltaTimeInMills;
            if (ticker.delayCounter < ticker.delay) continue;
            ticker.delayCounter = 0L;
            ticker2 = ticker;
            ticker2.times = ticker2.times - 1;
            ticker.listener.run();
            if (ticker.times > 0) continue;
            iterator.remove();
        }
        this.executedTime += deltaTimeInMills;
        this.execute(deltaTimeInMills, fsm);
    }

    protected abstract void execute(long var1, T var3);

    public State<T> reset() {
        this.executedTime = 0L;
        this.tickers.clear();
        this.finished = false;
        return this;
    }

    public State<T> addEvent(IEvent<T> condition) {
        this.conditions.add(condition);
        return this;
    }

    public State<T> addFinishEvent(FinishedEvent<T> condition) {
        return this.addEvent(condition);
    }

    public IEvent<T> EventTrigger(T fsm, long delta) {
        for (IEvent<T> con : this.conditions) {
            if (!con.onCondition(fsm, this, delta)) continue;
            return con;
        }
        return null;
    }

    public boolean finished() {
        return this.finished;
    }

    public void finish() {
        this.finished = true;
    }

    public long getExecutedTime() {
        return this.executedTime;
    }

    private static class Ticker {
        private long delay;
        private int times;
        private long delayCounter;
        private Proc listener;

        public Ticker(long delay, int times, Proc listener) {
            this.delay = delay;
            this.times = times;
            this.listener = listener;
        }
    }
}

