/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.i18n;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Func2;
import org.slingerxv.limitart.util.StringUtil;

public class I18NStrings {
    private static Logger log = LoggerFactory.getLogger(I18NStrings.class);
    private Map<String, Map<String, String>> langs = new HashMap<String, Map<String, String>>();
    private Map<String, Properties> dumps = new HashMap<String, Properties>();
    private static String DUMP_PATH = "lang_dumps";

    public void loadProperty(String lang, byte[] content) throws IOException {
        this.loadProperty(lang, new ByteArrayInputStream(content));
    }

    public void loadProperty(String lang, File file) throws IOException {
        this.loadProperty(lang, new FileInputStream(file));
    }

    public void loadProperty(String lang, InputStream inputStream) throws IOException {
        Properties prop = new Properties();
        prop.load(inputStream);
        this.loadProperty(lang, prop);
        inputStream.close();
    }

    public void loadProperty(String lang, Properties prop) throws IOException {
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            this.add(lang, entry.getKey().toString(), entry.getValue().toString());
        }
        log.info("load lang {} done,count:{}", (Object)lang, (Object)prop.size());
    }

    public void add(String lang, String key, String content) {
        Map<String, String> map;
        if (StringUtil.isEmptyOrNull(content)) {
            return;
        }
        if (!this.langs.containsKey(lang)) {
            this.langs.put(lang, new HashMap());
        }
        if ((map = this.langs.get(lang)).containsKey(key)) {
            log.error("lang {} key duplicated {}", (Object)lang, (Object)key);
            return;
        }
        map.put(key, content);
    }

    public String get(String lang, String key) throws FileNotFoundException, IOException {
        Objects.requireNonNull(lang, "lang");
        Objects.requireNonNull(key, "lang");
        if (!this.langs.containsKey(lang)) {
            log.error("language :{} has no solution!", (Object)lang);
            this.dumpUntraslatedKey(lang, key);
            return key;
        }
        Map<String, String> map = this.langs.get(lang);
        if (!map.containsKey(key)) {
            log.error("language :{} has no key:{}", (Object)lang, (Object)key);
            this.dumpUntraslatedKey(lang, key);
            return key;
        }
        return map.get(key);
    }

    public void foreach(Func2<String, Map<String, String>, Boolean> func) {
        for (Map.Entry<String, Map<String, String>> entry : this.langs.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(entry.getValue());
            if (func.run(entry.getKey(), map).booleanValue()) continue;
            break;
        }
    }

    private void dumpUntraslatedKey(String lang, String key) throws FileNotFoundException, IOException {
        Properties properties;
        this.checkDumpDir();
        if (!this.dumps.containsKey(lang)) {
            properties = new Properties();
            this.dumps.put(lang, properties);
        }
        if (!(properties = this.dumps.get(lang)).containsKey(key)) {
            properties.setProperty(key, "?????");
            File file = new File("./" + DUMP_PATH + "/" + I18NStrings.getFileName(lang));
            FileWriter fileWriter = new FileWriter(file);
            properties.store(fileWriter, null);
            fileWriter.close();
        }
    }

    private void checkDumpDir() {
        File file = new File("./" + DUMP_PATH);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static String getFileName(String lang) {
        return "lang_" + lang + ".properties";
    }

    public static String getTypeByFileName(String fileName) {
        String substring = fileName.replace("lang_", "").replace(".properties", "");
        return substring;
    }
}

