/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.net.AbstractNettyServer;

public abstract class AbstractNettyClient {
    private static Logger log = LoggerFactory.getLogger(AbstractNettyServer.class);
    protected static EventLoopGroup workerGroup = Epoll.isAvailable() ? new EpollEventLoopGroup() : new NioEventLoopGroup();
    private Bootstrap bootstrap;
    private String clientName;
    private Channel channel;
    private int autoReconnect;

    protected AbstractNettyClient(String clientName, int autoReconnect) {
        this.clientName = Objects.requireNonNull(clientName, "client name");
        this.autoReconnect = autoReconnect;
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(workerGroup);
        if (Epoll.isAvailable()) {
            this.bootstrap.channel(EpollSocketChannel.class);
            log.info(clientName + " epoll init");
        } else {
            this.bootstrap.channel(NioSocketChannel.class);
            log.info(clientName + " nio init");
        }
        ((Bootstrap)this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                AbstractNettyClient.this.initPipeline(ch.pipeline());
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public boolean isSharable() {
                        return true;
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        AbstractNettyClient.this.channelRead0(ctx, msg);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        log.info(AbstractNettyClient.this.getClientName() + " disconnected!");
                        AbstractNettyClient.this.channelInactive0(ctx);
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        AbstractNettyClient.this.channel = ctx.channel();
                        log.info(AbstractNettyClient.this.getClientName() + " connected!");
                        AbstractNettyClient.this.channelActive0(ctx);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        log.error(ctx.channel() + " cause:", cause);
                        AbstractNettyClient.this.exceptionCaught0(ctx, cause);
                    }
                }});
            }
        });
    }

    protected abstract void initPipeline(ChannelPipeline var1);

    protected abstract void channelRead0(ChannelHandlerContext var1, Object var2) throws Exception;

    protected abstract void channelInactive0(ChannelHandlerContext var1) throws Exception;

    protected abstract void channelActive0(ChannelHandlerContext var1) throws Exception;

    protected abstract void exceptionCaught0(ChannelHandlerContext var1, Throwable var2) throws Exception;

    protected AbstractNettyClient tryDisConnect() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        return this;
    }

    public abstract void connect();

    public abstract void disConnect();

    private void connect0(String ip, int port) {
        block3: {
            if (this.channel != null && this.channel.isWritable()) {
                return;
            }
            log.info(this.clientName + " start connect server\uff1a" + ip + ":" + port + "...");
            try {
                this.bootstrap.connect(ip, port).sync().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> log.info(this.clientName + " connect server\uff1a" + ip + ":" + port + " success\uff01")));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.autoReconnect <= 0) break block3;
                this.tryReconnect(ip, port, this.autoReconnect);
            }
        }
    }

    protected void tryReconnect(String ip, int port, int waitSeconds) {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        log.info(this.clientName + " try connect server\uff1a" + ip + ":" + port + " after " + waitSeconds + " seconds");
        if (waitSeconds > 0) {
            workerGroup.schedule(() -> this.connect0(ip, port), (long)waitSeconds, TimeUnit.SECONDS);
        } else {
            this.connect0(ip, port);
        }
    }

    public String getClientName() {
        return this.clientName;
    }

    public int getAutoReconnect() {
        return this.autoReconnect;
    }

    public Channel channel() {
        return this.channel;
    }
}

