/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Procs;

public abstract class AbstractNettyServer {
    private static Logger log = LoggerFactory.getLogger(AbstractNettyServer.class);
    protected static EventLoopGroup bossGroup;
    protected static EventLoopGroup workerGroup;
    private ServerBootstrap bootstrap;
    private Channel channel;
    private String serverName;

    protected AbstractNettyServer(String serverName) {
        this.serverName = Objects.requireNonNull(serverName, "server name");
        this.bootstrap = new ServerBootstrap();
        if (Epoll.isAvailable()) {
            ((ServerBootstrap)((ServerBootstrap)this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(EpollServerSocketChannel.class)).childOption(ChannelOption.SO_LINGER, (Object)0).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            log.info(serverName + " epoll init");
        } else {
            this.bootstrap.channel(NioServerSocketChannel.class);
            log.info(serverName + " nio init");
        }
        ((ServerBootstrap)this.bootstrap.group(bossGroup, workerGroup).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                AbstractNettyServer.this.initPipeline(ch.pipeline());
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public boolean isSharable() {
                        return true;
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        log.error(ctx.channel() + " cause:", cause);
                        AbstractNettyServer.this.exceptionCaught0(ctx, cause);
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        log.info(ctx.channel().remoteAddress() + " connected\uff01");
                        AbstractNettyServer.this.channelActive0(ctx);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        log.info(ctx.channel().remoteAddress() + " disconnected\uff01");
                        AbstractNettyServer.this.channelInactive0(ctx);
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        AbstractNettyServer.this.channelRead0(ctx, msg);
                    }
                }});
            }
        });
    }

    protected abstract void initPipeline(ChannelPipeline var1);

    protected abstract void exceptionCaught0(ChannelHandlerContext var1, Throwable var2) throws Exception;

    protected abstract void channelActive0(ChannelHandlerContext var1) throws Exception;

    protected abstract void channelInactive0(ChannelHandlerContext var1) throws Exception;

    protected abstract void channelRead0(ChannelHandlerContext var1, Object var2) throws Exception;

    protected void bind(int port, Proc1<Channel> listener) {
        this.bootstrap.bind(port).addListener(arg0 -> {
            if (arg0.isSuccess()) {
                log.info(this.serverName + " bind at port:" + port);
                this.channel = arg0.channel();
                Procs.invoke(listener, arg0.channel());
            } else {
                log.error(this.serverName + " bind at port error:" + arg0.cause());
            }
        });
    }

    protected void unbind() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public Channel channel() {
        return this.channel;
    }

    static {
        if (Epoll.isAvailable()) {
            bossGroup = new EpollEventLoopGroup(1);
            workerGroup = new EpollEventLoopGroup();
        } else {
            bossGroup = new NioEventLoopGroup(1);
            workerGroup = new NioEventLoopGroup();
        }
    }
}

