/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AbstractNettyClient;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.binary.codec.AbstractBinaryDecoder;
import org.slingerxv.limitart.net.binary.codec.AbstractBinaryEncoder;
import org.slingerxv.limitart.net.binary.handler.IHandler;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.MessageFactory;
import org.slingerxv.limitart.net.binary.message.constant.InnerMessageEnum;
import org.slingerxv.limitart.net.binary.message.exception.MessageCodecException;
import org.slingerxv.limitart.net.binary.message.impl.validate.ConnectionValidateClientMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.ConnectionValidateServerMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.ConnectionValidateSuccessServerMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.HeartClientMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.HeartServerMessage;
import org.slingerxv.limitart.net.binary.util.SendMessageUtil;
import org.slingerxv.limitart.util.SymmetricEncryptionUtil;
import org.slingerxv.limitart.util.TimerUtil;

public class BinaryClient
extends AbstractNettyClient {
    private static Logger log = LoggerFactory.getLogger(BinaryClient.class);
    private SymmetricEncryptionUtil decodeUtil;
    private long serverUTCTime;
    private TimerTask hearTask;
    private AddressPair remoteAddress;
    private AbstractBinaryDecoder decoder;
    private AbstractBinaryEncoder encoder;
    private MessageFactory factory;
    private int heartIntervalSec;
    private Proc2<BinaryClient, Boolean> onChannelStateChanged;
    private Proc2<BinaryClient, Throwable> onExceptionCaught;
    private Proc1<BinaryClient> onConnectionEffective;
    private Proc2<Message, IHandler<Message>> dispatchMessage;

    private BinaryClient(BinaryClientBuilder builder) throws Exception {
        super(builder.clientName, builder.autoReconnect);
        this.remoteAddress = Objects.requireNonNull(builder.remoteAddress, "remoteAddress");
        this.decoder = Objects.requireNonNull(builder.decoder, "decoder");
        this.encoder = Objects.requireNonNull(builder.encoder, "encoder");
        this.factory = Objects.requireNonNull(builder.factory, "factory");
        this.onChannelStateChanged = builder.onChannelStateChanged;
        this.onExceptionCaught = builder.onExceptionCaught;
        this.onConnectionEffective = builder.onConnectionEffective;
        this.dispatchMessage = builder.dispatchMessage;
        this.heartIntervalSec = builder.heartIntervalSec;
        this.factory.registerMsg(new ConnectionValidateServerHandler()).registerMsg(new ConnectionValidateSuccessServerHandler()).registerMsg(new HeartServerHandler());
        this.decodeUtil = SymmetricEncryptionUtil.getDecodeInstance(this.remoteAddress.getPass());
    }

    public void sendMessage(Message msg) throws Exception {
        this.sendMessage(msg, null);
    }

    public void sendMessage(Message msg, Proc3<Boolean, Throwable, Channel> listener) throws Exception {
        try {
            SendMessageUtil.sendMessage(this.encoder, this.channel(), msg, listener);
        }
        catch (MessageCodecException e) {
            Procs.invoke(this.onExceptionCaught, this, e);
        }
    }

    @Override
    public void connect() {
        this.tryReconnect(this.remoteAddress.getIp(), this.remoteAddress.getPort(), 0);
    }

    @Override
    public void disConnect() {
        this.tryDisConnect();
    }

    @Override
    protected void initPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(this.decoder.getMaxFrameLength(), this.decoder.getLengthFieldOffset(), this.decoder.getLengthFieldLength(), this.decoder.getLengthAdjustment(), this.decoder.getInitialBytesToStrip())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object arg) throws ReflectiveOperationException, MessageCodecException {
        ByteBuf buffer = (ByteBuf)arg;
        try {
            short messageId = this.decoder.readMessageId(ctx.channel(), buffer);
            Message msg = this.factory.getMessage(messageId);
            if (msg == null) {
                throw new MessageCodecException(this.getClientName() + " message empty,id:" + Integer.toHexString(messageId));
            }
            msg.buffer(buffer);
            try {
                msg.decode();
            }
            catch (Exception e) {
                throw new MessageCodecException(e);
            }
            msg.buffer(null);
            IHandler<? extends Message> handler = this.factory.getHandler(messageId);
            if (handler == null) {
                throw new MessageCodecException(this.getClientName() + " can not find handler for message,id:" + Integer.toHexString(messageId));
            }
            msg.setChannel(ctx.channel());
            msg.setClient(this);
            if (InnerMessageEnum.getTypeByValue(messageId) != null) {
                handler.handle(msg);
            } else if (this.dispatchMessage != null) {
                try {
                    this.dispatchMessage.run(msg, handler);
                }
                catch (Exception e) {
                    log.error(ctx.channel() + " cause:", (Throwable)e);
                    Procs.invoke(this.onExceptionCaught, this, e);
                }
            } else {
                log.warn(this.getClientName() + " no dispatch message listener!");
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    protected void channelInactive0(ChannelHandlerContext ctx) throws Exception {
        if (this.heartIntervalSec > 0 && this.hearTask != null) {
            TimerUtil.unScheduleGlobal(this.hearTask);
        }
        Procs.invoke(this.onChannelStateChanged, this, false);
        if (this.getAutoReconnect() > 0) {
            this.tryReconnect(this.remoteAddress.getIp(), this.remoteAddress.getPort(), this.getAutoReconnect());
        }
    }

    @Override
    protected void channelActive0(ChannelHandlerContext ctx) throws Exception {
        Procs.invoke(this.onChannelStateChanged, this, true);
    }

    @Override
    protected void exceptionCaught0(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Procs.invoke(this.onExceptionCaught, this, cause);
    }

    private void decodeConnectionValidateData(String validateStr) {
        try {
            String decode = this.decodeUtil.decode(validateStr);
            int validateRandom = Integer.parseInt(decode);
            ConnectionValidateClientMessage msg = new ConnectionValidateClientMessage();
            msg.validateRandom = validateRandom;
            this.sendMessage(msg, null);
            log.info(this.getClientName() + " parse validate code success\uff0creturn result\uff1a" + validateRandom);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void onConnectionValidateSeccuss(String remote) {
        log.info("server validate success,remote:" + remote);
        if (this.heartIntervalSec > 0) {
            this.hearTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BinaryClient.this.sendMessage(new HeartClientMessage());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
            TimerUtil.scheduleGlobal(0L, this.heartIntervalSec * 1000, this.hearTask);
        }
        Procs.invoke(this.onConnectionEffective, this);
    }

    private void onHeartServer(long serverUTCTime) {
        this.serverUTCTime = serverUTCTime;
    }

    public SocketAddress remoteAddress() {
        return this.channel().remoteAddress();
    }

    public AddressPair getRemoteAddress() {
        return this.remoteAddress;
    }

    public AbstractBinaryDecoder getDecoder() {
        return this.decoder;
    }

    public AbstractBinaryEncoder getEncoder() {
        return this.encoder;
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    public long getServerUTCTime() {
        return this.serverUTCTime;
    }

    public int getHeartIntervalSec() {
        return this.heartIntervalSec;
    }

    public static class BinaryClientBuilder {
        private String clientName = "Binary-Client";
        private AddressPair remoteAddress = new AddressPair("127.0.0.1", 8888);
        private int autoReconnect = 0;
        private AbstractBinaryDecoder decoder = AbstractBinaryDecoder.DEFAULT_DECODER;
        private AbstractBinaryEncoder encoder = AbstractBinaryEncoder.DEFAULT_ENCODER;
        private MessageFactory factory = new MessageFactory();
        private int heartIntervalSec = 0;
        private Proc2<BinaryClient, Boolean> onChannelStateChanged;
        private Proc2<BinaryClient, Throwable> onExceptionCaught;
        private Proc1<BinaryClient> onConnectionEffective;
        private Proc2<Message, IHandler<Message>> dispatchMessage = (t1, t2) -> t2.handle(t1);

        public BinaryClient build() throws Exception {
            return new BinaryClient(this);
        }

        public BinaryClientBuilder decoder(AbstractBinaryDecoder decoder) {
            this.decoder = decoder;
            return this;
        }

        public BinaryClientBuilder encoder(AbstractBinaryEncoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public BinaryClientBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public BinaryClientBuilder remoteAddress(AddressPair remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public BinaryClientBuilder autoReconnect(int autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public BinaryClientBuilder factory(MessageFactory factory) {
            this.factory = factory;
            return this;
        }

        public BinaryClientBuilder onChannelStateChanged(Proc2<BinaryClient, Boolean> onChannelStateChanged) {
            this.onChannelStateChanged = onChannelStateChanged;
            return this;
        }

        public BinaryClientBuilder onExceptionCaught(Proc2<BinaryClient, Throwable> onExceptionCaught) {
            this.onExceptionCaught = onExceptionCaught;
            return this;
        }

        public BinaryClientBuilder onConnectionEffective(Proc1<BinaryClient> onConnectionEffective) {
            this.onConnectionEffective = onConnectionEffective;
            return this;
        }

        public BinaryClientBuilder dispatchMessage(Proc2<Message, IHandler<Message>> dispatchMessage) {
            this.dispatchMessage = dispatchMessage;
            return this;
        }

        public BinaryClientBuilder heartIntervalSec(int heartIntervalSec) {
            this.heartIntervalSec = heartIntervalSec;
            return this;
        }
    }

    private class HeartServerHandler
    implements IHandler<HeartServerMessage> {
        private HeartServerHandler() {
        }

        @Override
        public void handle(HeartServerMessage msg) {
            msg.getClient().onHeartServer(msg.serverUtcTime);
        }
    }

    private class ConnectionValidateSuccessServerHandler
    implements IHandler<ConnectionValidateSuccessServerMessage> {
        private ConnectionValidateSuccessServerHandler() {
        }

        @Override
        public void handle(ConnectionValidateSuccessServerMessage msg) {
            msg.getClient().onConnectionValidateSeccuss(msg.getChannel().remoteAddress().toString());
        }
    }

    private class ConnectionValidateServerHandler
    implements IHandler<ConnectionValidateServerMessage> {
        private ConnectionValidateServerHandler() {
        }

        @Override
        public void handle(ConnectionValidateServerMessage msg) {
            msg.getClient().decodeConnectionValidateData(msg.validateStr);
        }
    }
}

