/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.collections.ConcurrentHashSet;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AbstractNettyServer;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.binary.codec.AbstractBinaryDecoder;
import org.slingerxv.limitart.net.binary.codec.AbstractBinaryEncoder;
import org.slingerxv.limitart.net.binary.handler.IHandler;
import org.slingerxv.limitart.net.binary.handler.annotation.Controller;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.MessageFactory;
import org.slingerxv.limitart.net.binary.message.constant.InnerMessageEnum;
import org.slingerxv.limitart.net.binary.message.exception.HeartNotAnswerException;
import org.slingerxv.limitart.net.binary.message.exception.HeartTooQuickException;
import org.slingerxv.limitart.net.binary.message.exception.MessageCodecException;
import org.slingerxv.limitart.net.binary.message.exception.SendMessageTooFastException;
import org.slingerxv.limitart.net.binary.message.impl.validate.ConnectionValidateClientMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.ConnectionValidateServerMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.ConnectionValidateSuccessServerMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.HeartClientMessage;
import org.slingerxv.limitart.net.binary.message.impl.validate.HeartServerMessage;
import org.slingerxv.limitart.net.binary.util.SendMessageUtil;
import org.slingerxv.limitart.util.RandomUtil;
import org.slingerxv.limitart.util.StringUtil;
import org.slingerxv.limitart.util.SymmetricEncryptionUtil;
import org.slingerxv.limitart.util.TimeUtil;
import org.slingerxv.limitart.util.TimerUtil;

@Controller
public class BinaryServer
extends AbstractNettyServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(BinaryServer.class);
    private static AttributeKey<Long> LAST_HEART_TIME = AttributeKey.newInstance((String)"LAST_HEART_TIME");
    private static AttributeKey<Long> FIRST_HEART_TIME = AttributeKey.newInstance((String)"FIRST_HEART_TIME");
    private static AttributeKey<Long> LAST_RECEIVE_MSG_TIME = AttributeKey.newInstance((String)"LAST_RECEIVE_MSG_TIME");
    private static AttributeKey<Integer> HEART_COUNT = AttributeKey.newInstance((String)"HEART_COUNT");
    private Map<String, SessionValidateData> unvalidatedChannels = new ConcurrentHashMap<String, SessionValidateData>();
    private Set<Channel> validatedChannels = new ConcurrentHashSet<Channel>();
    private SymmetricEncryptionUtil encrypUtil;
    private TimerTask clearTask;
    private TimerTask heartTask;
    private AtomicInteger connectionCount = new AtomicInteger(0);
    private long startTime;
    private AddressPair addressPair;
    private int connectionValidateTimeInSec;
    private AbstractBinaryDecoder decoder;
    private AbstractBinaryEncoder encoder;
    private Set<String> whiteList;
    private MessageFactory factory;
    private int maxConnection;
    private int heartIntervalSec;
    private int checkHeartWhenConnectionCount;
    private int receiveIntervalMills;
    private Proc2<Channel, Boolean> onChannelStateChanged;
    private Proc2<Channel, Throwable> onExceptionCaught;
    private Proc1<Channel> onServerBind;
    private Proc1<Channel> onConnectionEffective;
    private Proc2<Message, IHandler<Message>> dispatchMessage;

    private BinaryServer(BinaryServerBuilder builder) throws Exception {
        super(builder.serverName);
        this.addressPair = Objects.requireNonNull(builder.addressPair, "addressPair");
        this.connectionValidateTimeInSec = builder.connectionValidateTimeInSec;
        this.decoder = Objects.requireNonNull(builder.decoder, "decoder");
        this.encoder = Objects.requireNonNull(builder.encoder, "encoder");
        this.whiteList = Objects.requireNonNull(builder.whiteList, "whiteList");
        this.factory = Objects.requireNonNull(builder.factory, "factory");
        this.onChannelStateChanged = builder.onChannelStateChanged;
        this.onExceptionCaught = builder.onExceptionCaught;
        this.onServerBind = builder.onServerBind;
        this.onConnectionEffective = builder.onConnectionEffective;
        this.dispatchMessage = builder.dispatchMessage;
        this.maxConnection = builder.maxConnection;
        this.heartIntervalSec = builder.heartIntervalSec;
        this.checkHeartWhenConnectionCount = builder.checkHeartWhenConnectionCount;
        this.receiveIntervalMills = builder.receiveIntervalMills;
        this.factory.registerMsg(new ConnectionValidateClientHandler()).registerMsg(new HeartClientHandler());
        if (this.needPass()) {
            this.encrypUtil = SymmetricEncryptionUtil.getEncodeInstance(this.addressPair.getPass(), "20170106");
            this.clearTask = new TimerTask(){

                @Override
                public void run() {
                    BinaryServer.this.clearUnvalidatedConnection();
                }
            };
            TimerUtil.scheduleGlobal(1000L, 1000L, this.clearTask);
        }
        if (this.heartIntervalSec > 0) {
            this.heartTask = new TimerTask(){

                @Override
                public void run() {
                    BinaryServer.this.clearUnheart();
                }
            };
            TimerUtil.scheduleGlobal(5000L, 5000L, this.heartTask);
        }
    }

    @Override
    protected void initPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(this.decoder.getMaxFrameLength(), this.decoder.getLengthFieldOffset(), this.decoder.getLengthFieldLength(), this.decoder.getLengthAdjustment(), this.decoder.getInitialBytesToStrip())});
    }

    @Override
    protected void exceptionCaught0(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Procs.invoke(this.onExceptionCaught, ctx.channel(), cause);
    }

    @Override
    protected void channelActive0(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress insocket;
        String remoteAddress;
        if (this.maxConnection > 0 && this.connectionCount.get() >= this.maxConnection) {
            log.error("connection count is greater than " + this.maxConnection + " close channel:" + ctx.channel());
            ctx.channel().close();
            return;
        }
        if (this.whiteList != null && !this.whiteList.isEmpty() && !this.whiteList.contains(remoteAddress = (insocket = (InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress())) {
            ctx.channel().close();
            log.info("ip: " + remoteAddress + " rejected link!");
            return;
        }
        this.connectionCount.incrementAndGet();
        Procs.invoke(this.onChannelStateChanged, ctx.channel(), true);
        if (this.needPass()) {
            this.startConnectionValidate(ctx.channel());
        } else {
            try {
                this.sendMessage(this.channel(), (Message)new ConnectionValidateSuccessServerMessage(), null);
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
            }
            this.validatedChannels.add(ctx.channel());
            Procs.invoke(this.onConnectionEffective, this.channel());
        }
    }

    @Override
    protected void channelInactive0(ChannelHandlerContext ctx) throws Exception {
        this.connectionCount.decrementAndGet();
        this.validatedChannels.remove(ctx.channel());
        Procs.invoke(this.onChannelStateChanged, ctx.channel(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object arg) throws Exception {
        ByteBuf buffer = (ByteBuf)arg;
        try {
            short messageId = this.decoder.readMessageId(ctx.channel(), buffer);
            Message msg = this.factory.getMessage(messageId);
            if (msg == null) {
                throw new MessageCodecException(this.getServerName() + " message empty,id:" + Integer.toHexString(messageId));
            }
            msg.buffer(buffer);
            try {
                msg.decode();
            }
            catch (Exception e) {
                log.error("message id:" + Integer.toHexString(messageId) + " decode error!");
                throw new MessageCodecException(e);
            }
            msg.buffer(null);
            IHandler<? extends Message> handler = this.factory.getHandler(messageId);
            if (handler == null) {
                throw new MessageCodecException(this.getServerName() + " can not find handler for message,id:" + Integer.toHexString(messageId));
            }
            msg.setChannel(ctx.channel());
            msg.setServer(this);
            if (InnerMessageEnum.getTypeByValue(messageId) != null) {
                handler.handle(msg);
            } else {
                if (this.unvalidatedChannels.containsKey(ctx.channel().id().asLongText())) {
                    log.error("channel " + ctx.channel() + " has not validate yet!");
                    return;
                }
                long now = System.currentTimeMillis();
                if (this.receiveIntervalMills > 0) {
                    Long lastReceiveTime;
                    if (ctx.channel().hasAttr(LAST_RECEIVE_MSG_TIME) && (lastReceiveTime = (Long)ctx.channel().attr(LAST_RECEIVE_MSG_TIME).get()) != null && now - lastReceiveTime < (long)this.receiveIntervalMills) {
                        ctx.channel().pipeline().fireExceptionCaught((Throwable)new SendMessageTooFastException(ctx.channel(), this.receiveIntervalMills, (int)(now - lastReceiveTime)));
                        ctx.channel().close();
                    }
                    ctx.channel().attr(LAST_RECEIVE_MSG_TIME).set((Object)now);
                }
                if (this.dispatchMessage != null) {
                    try {
                        this.dispatchMessage.run(msg, handler);
                    }
                    catch (Exception e) {
                        log.error(ctx.channel() + " cause:", (Throwable)e);
                        Procs.invoke(this.onExceptionCaught, ctx.channel(), e);
                    }
                } else {
                    log.warn(this.getServerName() + " no dispatch message listener!");
                }
            }
        }
        catch (Exception e) {
            ctx.channel().close();
            log.error("close session:" + ctx.channel(), (Throwable)e);
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public void startServer() {
        this.startTime = System.currentTimeMillis();
        this.bind(this.addressPair.getPort(), this.onServerBind);
    }

    @Override
    public void stopServer() {
        this.unbind();
        TimerUtil.unScheduleGlobal(this.clearTask);
        TimerUtil.unScheduleGlobal(this.heartTask);
    }

    public void sendMessage(Channel channel, Message msg) throws MessageCodecException {
        this.sendMessage(channel, msg, null);
    }

    public void sendMessage(Channel channel, Message msg, Proc3<Boolean, Throwable, Channel> listener) throws MessageCodecException {
        SendMessageUtil.sendMessage(this.encoder, channel, msg, listener);
    }

    public void sendMessage(List<Channel> channels, Message msg) throws MessageCodecException {
        this.sendMessage(channels, msg, null);
    }

    public void sendMessage(List<Channel> channels, Message msg, Proc3<Boolean, Throwable, Channel> listener) throws MessageCodecException {
        SendMessageUtil.sendMessage(this.encoder, channels, msg, listener);
    }

    private void startConnectionValidate(Channel channel) {
        String encode;
        SessionValidateData data = new SessionValidateData(channel, System.currentTimeMillis(), RandomUtil.randomInt(0, 10000));
        this.unvalidatedChannels.put(data.channel.id().asLongText(), data);
        ConnectionValidateServerMessage msg = new ConnectionValidateServerMessage();
        try {
            encode = this.encrypUtil.encode(data.validateRandom + "");
        }
        catch (Exception e) {
            log.error("encode link validate code error", (Throwable)e);
            channel.close();
            log.info(this.getServerName() + " remote connection " + data.channel.remoteAddress() + " discarded\uff0cserver encryp util error\uff01");
            return;
        }
        msg.validateStr = encode;
        try {
            this.sendMessage(channel, (Message)msg, (Boolean isSuccess, Throwable cause, Channel channel1) -> {
                if (isSuccess.booleanValue()) {
                    log.info(this.getServerName() + " send client " + channel1.remoteAddress() + " validate token:" + encode + "success\uff01");
                } else {
                    log.error(this.getServerName() + " send client " + channel1.remoteAddress() + " validate token:" + encode + "fail\uff01", cause);
                }
            });
        }
        catch (Exception e) {
            log.error("send vlidate error", (Throwable)e);
        }
    }

    private void clearUnvalidatedConnection() {
        if (this.unvalidatedChannels.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<SessionValidateData> iterator = this.unvalidatedChannels.values().iterator();
        while (iterator.hasNext()) {
            SessionValidateData data = iterator.next();
            long startValidateTime = data.startValidateTime;
            if (now - startValidateTime <= (long)(this.connectionValidateTimeInSec * 1000)) continue;
            iterator.remove();
            data.channel.close();
            log.error(this.getServerName() + " connection " + data.channel.remoteAddress() + " discarded\uff0cvalidate time out,wait validate size:" + this.unvalidatedChannels.size());
        }
    }

    private void clearUnheart() {
        if (this.checkHeartWhenConnectionCount > this.connectionCount.get()) {
            return;
        }
        long now = System.currentTimeMillis();
        for (Channel channel : this.validatedChannels) {
            int allow;
            long last = 0L;
            long first = 0L;
            int count = 0;
            if (channel.hasAttr(LAST_HEART_TIME)) {
                last = (Long)channel.attr(LAST_HEART_TIME).get();
            }
            if (channel.hasAttr(FIRST_HEART_TIME)) {
                first = (Long)channel.attr(FIRST_HEART_TIME).get();
            }
            if (channel.hasAttr(HEART_COUNT)) {
                count = (Integer)channel.attr(HEART_COUNT).get();
            }
            if (count - 2 > (allow = (int)((now - first) / (long)(this.heartIntervalSec * 1000)))) {
                log.error(channel + " heart too quick,might be Game Accelerator,please check!");
                channel.pipeline().fireExceptionCaught((Throwable)new HeartTooQuickException(channel, first, now, count, allow));
                channel.attr(FIRST_HEART_TIME).set((Object)now);
                channel.attr(HEART_COUNT).set((Object)0);
            }
            if (count >= allow - 2) continue;
            channel.pipeline().fireExceptionCaught((Throwable)new HeartNotAnswerException(channel, first, last, count));
            channel.close();
        }
    }

    private void connectionValidateClient(ConnectionValidateClientMessage msg) {
        String asLongText = msg.getChannel().id().asLongText();
        SessionValidateData sessionValidateData = this.unvalidatedChannels.get(asLongText);
        if (sessionValidateData == null) {
            msg.getChannel().close();
            log.info(this.getServerName() + " remote connection " + msg.getChannel().remoteAddress() + " discarded\uff0cvalidate time out\uff01");
            return;
        }
        if (sessionValidateData.validateRandom != msg.validateRandom) {
            log.info(this.getServerName() + " remote connection " + msg.getChannel().remoteAddress() + " discarded\uff0cvalidate wrong\uff01");
            return;
        }
        this.unvalidatedChannels.remove(asLongText);
        log.info(this.getServerName() + " remote connection " + msg.getChannel().remoteAddress() + " validate success!");
        try {
            this.sendMessage(msg.getChannel(), (Message)new ConnectionValidateSuccessServerMessage(), null);
        }
        catch (Exception e) {
            msg.getChannel().pipeline().fireExceptionCaught((Throwable)e);
        }
        this.validatedChannels.add(msg.getChannel());
        Procs.invoke(this.onConnectionEffective, msg.getChannel());
    }

    private void heartClient(HeartClientMessage msg) {
        long now = System.currentTimeMillis();
        msg.getChannel().attr(LAST_HEART_TIME).set((Object)now);
        if (!msg.getChannel().hasAttr(FIRST_HEART_TIME)) {
            msg.getChannel().attr(FIRST_HEART_TIME).set((Object)now);
            msg.getChannel().attr(HEART_COUNT).set((Object)0);
        }
        int times = (Integer)msg.getChannel().attr(HEART_COUNT).get();
        msg.getChannel().attr(HEART_COUNT).set((Object)(++times));
        HeartServerMessage message = new HeartServerMessage();
        message.serverUtcTime = TimeUtil.getUTCTime();
        try {
            this.sendMessage(msg.getChannel(), (Message)message);
        }
        catch (Exception e) {
            log.error("send heart error", (Throwable)e);
        }
    }

    public AddressPair getAddressPair() {
        return this.addressPair;
    }

    public int getConnectionValidateTimeInSec() {
        return this.connectionValidateTimeInSec;
    }

    public AbstractBinaryDecoder getDecoder() {
        return this.decoder;
    }

    public AbstractBinaryEncoder getEncoder() {
        return this.encoder;
    }

    public Set<String> getWhiteList() {
        return this.whiteList;
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getHeartIntervalSec() {
        return this.heartIntervalSec;
    }

    public int getCheckHeartWhenConnectionCount() {
        return this.checkHeartWhenConnectionCount;
    }

    public int getReceiveIntervalMills() {
        return this.receiveIntervalMills;
    }

    private boolean needPass() {
        return this.addressPair.getPass() != null;
    }

    public static class BinaryServerBuilder {
        private String serverName = "Binary-Server";
        private AddressPair addressPair;
        private int connectionValidateTimeInSec = 20;
        private AbstractBinaryDecoder decoder;
        private AbstractBinaryEncoder encoder;
        private Set<String> whiteList = new HashSet<String>();
        private MessageFactory factory;
        private int maxConnection = 20000;
        private int heartIntervalSec = 0;
        private int checkHeartWhenConnectionCount = 0;
        private int receiveIntervalMills = 0;
        private Proc2<Channel, Boolean> onChannelStateChanged;
        private Proc2<Channel, Throwable> onExceptionCaught;
        private Proc1<Channel> onServerBind;
        private Proc1<Channel> onConnectionEffective;
        private Proc2<Message, IHandler<Message>> dispatchMessage;

        public BinaryServerBuilder() {
            this.addressPair = new AddressPair(8888, "limitart-core");
            this.decoder = AbstractBinaryDecoder.DEFAULT_DECODER;
            this.encoder = AbstractBinaryEncoder.DEFAULT_ENCODER;
            this.dispatchMessage = (t1, t2) -> t2.handle(t1);
        }

        public BinaryServer build() throws Exception {
            return new BinaryServer(this);
        }

        public BinaryServerBuilder decoder(AbstractBinaryDecoder decoder) {
            this.decoder = decoder;
            return this;
        }

        public BinaryServerBuilder encoder(AbstractBinaryEncoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public BinaryServerBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public BinaryServerBuilder addressPair(AddressPair addressPair) {
            this.addressPair = addressPair;
            return this;
        }

        public BinaryServerBuilder factory(MessageFactory factory) {
            this.factory = factory;
            return this;
        }

        public BinaryServerBuilder connectionValidateTimeInSec(int connectionValidateTimeInSec) {
            this.connectionValidateTimeInSec = connectionValidateTimeInSec;
            return this;
        }

        public BinaryServerBuilder whiteList(String ... remoteAddress) {
            for (String ip : remoteAddress) {
                if (!StringUtil.isIp4(ip)) continue;
                this.whiteList.add(ip);
            }
            return this;
        }

        public BinaryServerBuilder onChannelStateChanged(Proc2<Channel, Boolean> onChannelStateChanged) {
            this.onChannelStateChanged = onChannelStateChanged;
            return this;
        }

        public BinaryServerBuilder onExceptionCaught(Proc2<Channel, Throwable> onExceptionCaught) {
            this.onExceptionCaught = onExceptionCaught;
            return this;
        }

        public BinaryServerBuilder onServerBind(Proc1<Channel> onServerBind) {
            this.onServerBind = onServerBind;
            return this;
        }

        public BinaryServerBuilder onConnectionEffective(Proc1<Channel> onConnectionEffective) {
            this.onConnectionEffective = onConnectionEffective;
            return this;
        }

        public BinaryServerBuilder dispatchMessage(Proc2<Message, IHandler<Message>> dispatchMessage) {
            this.dispatchMessage = dispatchMessage;
            return this;
        }

        public BinaryServerBuilder maxConnection(int maxConnection) {
            this.maxConnection = maxConnection;
            return this;
        }

        public BinaryServerBuilder heartIntervalSec(int heartIntervalSec) {
            this.heartIntervalSec = heartIntervalSec;
            return this;
        }

        public BinaryServerBuilder checkHeartWhenConnectionCount(int checkHeartWhenConnectionCount) {
            this.checkHeartWhenConnectionCount = checkHeartWhenConnectionCount;
            return this;
        }

        public BinaryServerBuilder receiveIntervalMills(int receiveIntervalMills) {
            this.receiveIntervalMills = receiveIntervalMills;
            return this;
        }
    }

    private class HeartClientHandler
    implements IHandler<HeartClientMessage> {
        private HeartClientHandler() {
        }

        @Override
        public void handle(HeartClientMessage msg) {
            msg.getServer().heartClient(msg);
        }
    }

    private class ConnectionValidateClientHandler
    implements IHandler<ConnectionValidateClientMessage> {
        private ConnectionValidateClientHandler() {
        }

        @Override
        public void handle(ConnectionValidateClientMessage msg) {
            msg.getServer().connectionValidateClient(msg);
        }
    }

    private class SessionValidateData {
        private Channel channel;
        private long startValidateTime;
        private int validateRandom;

        private SessionValidateData(Channel channel, long startValidateTime, int validateRandom) {
            this.channel = channel;
            this.startValidateTime = startValidateTime;
            this.validateRandom = validateRandom;
        }
    }
}

