/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary.distributed;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.binary.BinaryServer;
import org.slingerxv.limitart.net.binary.distributed.handler.ReqConnectionReportSlave2MasterHandler;
import org.slingerxv.limitart.net.binary.distributed.handler.ReqServerLoadSlave2MasterHandler;
import org.slingerxv.limitart.net.binary.distributed.message.InnerServerInfo;
import org.slingerxv.limitart.net.binary.distributed.message.ReqConnectionReportSlave2MasterMessage;
import org.slingerxv.limitart.net.binary.distributed.message.ReqServerLoadSlave2MasterMessage;
import org.slingerxv.limitart.net.binary.distributed.message.ResServerJoinMaster2SlaveMessage;
import org.slingerxv.limitart.net.binary.distributed.message.ResServerQuitMaster2SlaveMessage;
import org.slingerxv.limitart.net.binary.distributed.struct.InnerServerData;
import org.slingerxv.limitart.net.binary.distributed.util.InnerServerUtil;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.MessageFactory;

public class InnerMasterServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(InnerMasterServer.class);
    private Map<Integer, Map<Integer, InnerServerData>> slaves = new ConcurrentHashMap<Integer, Map<Integer, InnerServerData>>();
    private BinaryServer server;
    private String serverName;
    private int masterPort;
    private MessageFactory factory;
    private Proc2<InnerServerData, Boolean> onConnectionChanged;

    public InnerMasterServer(InnerMasterServerBuilder builder) throws Exception {
        this.serverName = builder.serverName;
        this.masterPort = builder.masterPort;
        this.onConnectionChanged = builder.onConnectionChanged;
        this.factory = Objects.requireNonNull(builder.factory, "factory");
        this.getFactory().registerMsg(new ReqConnectionReportSlave2MasterHandler());
        this.getFactory().registerMsg(new ReqServerLoadSlave2MasterHandler());
        this.server = new BinaryServer.BinaryServerBuilder().addressPair(new AddressPair(this.getMasterPort(), InnerServerUtil.getInnerPass())).serverName(this.getServerName()).factory(this.getFactory()).dispatchMessage((message, handler) -> {
            message.setExtra(this);
            try {
                handler.handle(message);
            }
            catch (Exception e) {
                log.error("handle error", (Throwable)e);
            }
        }).onChannelStateChanged((channel, active) -> {
            if (!active.booleanValue()) {
                Integer serverType = InnerServerUtil.getServerType(channel);
                Integer serverId = InnerServerUtil.getServerId(channel);
                if (serverType == null || serverId == null) {
                    return;
                }
                Map<Integer, InnerServerData> map = this.slaves.get(serverType);
                if (map == null) {
                    return;
                }
                InnerServerData remove = map.remove(serverId);
                if (remove == null) {
                    return;
                }
                log.info("slave server disconnected,type:" + serverType + ",serverId:" + serverId);
                ResServerQuitMaster2SlaveMessage msg = new ResServerQuitMaster2SlaveMessage();
                msg.serverId = remove.getServerId();
                msg.serverType = remove.getServerType();
                ArrayList<Channel> channelList = new ArrayList<Channel>();
                for (Map<Integer, InnerServerData> dats : this.slaves.values()) {
                    for (InnerServerData data : dats.values()) {
                        channelList.add(data.getChannel());
                    }
                }
                try {
                    this.server.sendMessage(channelList, (Message)msg, null);
                }
                catch (Exception e) {
                    log.error("send message error", (Throwable)e);
                }
                Procs.invoke(this.onConnectionChanged, remove, false);
            }
        }).build();
    }

    public InnerServerData findLowestServer(int serverType) {
        InnerServerData currentServer = null;
        int currentMinLoad = Integer.MAX_VALUE;
        Map<Integer, InnerServerData> servers = this.slaves.get(serverType);
        if (servers == null) {
            return null;
        }
        for (InnerServerData data : servers.values()) {
            if (currentMinLoad <= data.getServerLoad()) continue;
            currentMinLoad = data.getServerLoad();
            currentServer = data;
        }
        return currentServer;
    }

    @Override
    public void startServer() {
        this.server.startServer();
    }

    @Override
    public void stopServer() {
        this.server.stopServer();
    }

    public synchronized void reqConnectionReportSlave2Master(ReqConnectionReportSlave2MasterMessage msg) {
        InnerServerInfo serverInfo = msg.serverInfo;
        InnerServerData data = new InnerServerData();
        data.setChannel(msg.getChannel());
        data.setServerType(serverInfo.serverType);
        data.setInnerPort(serverInfo.innerPort);
        data.setOutIp(serverInfo.outIp);
        data.setOutPass(serverInfo.outPass);
        data.setOutPort(serverInfo.outPort);
        data.setServerId(serverInfo.serverId);
        data.setServerLoad(0);
        Map<Integer, InnerServerData> concurrentHashMap = this.slaves.get(serverInfo.serverType);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<Integer, InnerServerData>();
            Map<Integer, InnerServerData> putIfAbsent = this.slaves.putIfAbsent(serverInfo.serverType, concurrentHashMap);
            if (putIfAbsent != null) {
                concurrentHashMap = putIfAbsent;
            }
        }
        if (concurrentHashMap.containsKey(serverInfo.serverId)) {
            log.error("slave server " + msg.getChannel() + " id duplicated:" + serverInfo.serverId);
            return;
        }
        InnerServerUtil.setServerType(msg.getChannel(), serverInfo.serverType);
        InnerServerUtil.setServerId(msg.getChannel(), serverInfo.serverId);
        log.info("slave server " + msg.getChannel() + " connected,current type size:" + concurrentHashMap.size() + ",server:" + data);
        ResServerJoinMaster2SlaveMessage sjm0 = new ResServerJoinMaster2SlaveMessage();
        sjm0.infos.add(this.serverData2ServerInfo(data));
        ArrayList<Channel> channelList = new ArrayList<Channel>();
        for (Map<Integer, InnerServerData> map : this.slaves.values()) {
            for (InnerServerData temp : map.values()) {
                channelList.add(temp.getChannel());
            }
        }
        if (!channelList.isEmpty()) {
            try {
                this.server.sendMessage(channelList, (Message)sjm0, (isSuccess, cause, channel) -> {
                    if (isSuccess.booleanValue()) {
                        log.info(this.server.getServerName() + " tell new slave server info " + msg.getChannel() + " to other slave servers success,slave server Id:" + data.getServerId());
                    } else {
                        log.error(this.server.getServerName() + " tell new slave server info " + msg.getChannel() + " to other slave servers fail,new slave server Id:" + data.getServerId(), cause);
                    }
                });
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        ResServerJoinMaster2SlaveMessage sjm = new ResServerJoinMaster2SlaveMessage();
        for (Map<Integer, InnerServerData> map : this.slaves.values()) {
            for (InnerServerData temp : map.values()) {
                InnerServerInfo info = this.serverData2ServerInfo(temp);
                sjm.infos.add(info);
            }
        }
        if (!sjm.infos.isEmpty()) {
            try {
                this.server.sendMessage(msg.getChannel(), (Message)sjm, (isSuccess, cause, channel) -> {
                    if (isSuccess.booleanValue()) {
                        log.info(this.server.getServerName() + " tell other slave servers info to new slave server " + msg.getChannel() + " success,slave server Id:" + data.getServerId());
                    } else {
                        log.error(this.server.getServerName() + " tell other slave servers info to new slave server " + msg.getChannel() + " fail,new slave server Id:" + data.getServerId(), cause);
                    }
                });
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        concurrentHashMap.put(serverInfo.serverId, data);
        Procs.invoke(this.onConnectionChanged, data, true);
    }

    public void reqServerLoadSlave2Master(ReqServerLoadSlave2MasterMessage msg) {
        Integer serverType = InnerServerUtil.getServerType(msg.getChannel());
        Integer serverId = InnerServerUtil.getServerId(msg.getChannel());
        if (serverType == null || serverId == null) {
            log.error("can not find server info:" + msg.getChannel());
            return;
        }
        Map<Integer, InnerServerData> map = this.slaves.get(serverType);
        if (map == null) {
            log.error("server type :" + serverType + ",has not servers!");
            return;
        }
        InnerServerData serverData = map.get(serverId);
        if (serverData == null) {
            log.error("can not find server info,server id:" + serverId + ",server type:" + serverType);
            return;
        }
        serverData.setServerLoad(msg.load);
        log.debug("receive slave server,server id:{} report load:{}", (Object)serverId, (Object)msg.load);
    }

    public List<InnerServerData> getSlaves(int serverType) {
        ArrayList<InnerServerData> result = new ArrayList<InnerServerData>();
        Map<Integer, InnerServerData> concurrentHashMap = this.slaves.get(serverType);
        if (concurrentHashMap == null) {
            return result;
        }
        result.addAll(concurrentHashMap.values());
        return result;
    }

    public InnerServerData getSlave(int serverType, int serverId) {
        Map<Integer, InnerServerData> concurrentHashMap = this.slaves.get(serverType);
        if (concurrentHashMap == null) {
            return null;
        }
        return concurrentHashMap.get(serverId);
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getMasterPort() {
        return this.masterPort;
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    private InnerServerInfo serverData2ServerInfo(InnerServerData data) {
        InnerServerInfo info = new InnerServerInfo();
        info.innerPort = data.getInnerPort();
        info.outIp = data.getOutIp();
        info.outPass = data.getOutPass();
        info.outPort = data.getOutPort();
        info.serverId = data.getServerId();
        info.serverType = data.getServerType();
        return info;
    }

    public static class InnerMasterServerBuilder {
        private String serverName = "Inner-Master-Server";
        private int masterPort = 8888;
        private MessageFactory factory;
        private Proc2<InnerServerData, Boolean> onConnectionChanged;

        public InnerMasterServer build() throws Exception {
            return new InnerMasterServer(this);
        }

        public InnerMasterServerBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public InnerMasterServerBuilder masterPort(int masterPort) {
            if (masterPort >= 1024) {
                this.masterPort = masterPort;
            }
            return this;
        }

        public InnerMasterServerBuilder factory(MessageFactory factory) {
            this.factory = factory;
            return this;
        }

        public InnerMasterServerBuilder onConnectionChanged(Proc2<InnerServerData, Boolean> onConnectionChanged) {
            this.onConnectionChanged = onConnectionChanged;
            return this;
        }
    }
}

