/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary.distributed;

import java.util.Objects;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Func;
import org.slingerxv.limitart.funcs.Funcs;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.binary.BinaryClient;
import org.slingerxv.limitart.net.binary.distributed.handler.ResServerJoinMaster2SlaveHandler;
import org.slingerxv.limitart.net.binary.distributed.handler.ResServerQuitMaster2SlaveHandler;
import org.slingerxv.limitart.net.binary.distributed.message.InnerServerInfo;
import org.slingerxv.limitart.net.binary.distributed.message.ReqConnectionReportSlave2MasterMessage;
import org.slingerxv.limitart.net.binary.distributed.message.ReqServerLoadSlave2MasterMessage;
import org.slingerxv.limitart.net.binary.distributed.message.ResServerJoinMaster2SlaveMessage;
import org.slingerxv.limitart.net.binary.distributed.message.ResServerQuitMaster2SlaveMessage;
import org.slingerxv.limitart.net.binary.message.MessageFactory;
import org.slingerxv.limitart.util.TimerUtil;

public class InnerSlaveServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(InnerSlaveServer.class);
    private BinaryClient toMaster;
    private TimerTask reportTask;
    private String slaveName;
    private int slaveType;
    private int myServerId;
    private String myIp;
    private int myServerPort;
    private String myServerPass;
    private int myInnerServerPort;
    private String myInnerServerPass;
    private String masterIp;
    private int masterServerPort;
    private String masterServerPass;
    private int masterInnerPort;
    private String masterInnerPass;
    private MessageFactory factory;
    private Func<Integer> serverLoad;
    private Proc1<InnerServerInfo> onNewSlaveJoin;
    private Proc2<Integer, Integer> onNewSlaveQuit;
    private Proc1<InnerSlaveServer> onConnectMasterSuccess;

    public InnerSlaveServer(InnerSlaveServerBuilder builder) throws Exception {
        this.slaveName = builder.slaveName;
        this.slaveType = builder.slaveType;
        this.myServerId = builder.myServerId;
        this.myIp = builder.myServerIp;
        this.myServerPort = builder.myServerPort;
        this.myServerPass = builder.myServerPass;
        this.myInnerServerPort = builder.myInnerServerPort;
        this.myInnerServerPass = builder.myInnerServerPass;
        this.masterIp = builder.masterIp;
        this.masterServerPort = builder.masterServerPort;
        this.masterServerPass = builder.masterServerPass;
        this.masterInnerPort = builder.masterInnerPort;
        this.masterInnerPass = builder.masterInnerPass;
        this.factory = Objects.requireNonNull(builder.factory, "factory");
        this.serverLoad = builder.serverLoad;
        this.onNewSlaveJoin = builder.onNewSlaveJoin;
        this.onNewSlaveQuit = builder.onNewSlaveQuit;
        this.onConnectMasterSuccess = builder.onConnectMasterSuccess;
        this.getFactory().registerMsg(new ResServerJoinMaster2SlaveHandler()).registerMsg(new ResServerQuitMaster2SlaveHandler());
        this.toMaster = new BinaryClient.BinaryClientBuilder().autoReconnect(5).clientName(this.getSlaveName()).remoteAddress(new AddressPair(this.getMasterIp(), this.getMasterInnerPort(), this.getMasterInnerPass())).factory(this.getFactory()).onChannelStateChanged((binaryClient, active) -> {
            if (!active.booleanValue()) {
                log.error(this.toMaster.getClientName() + " server disconnected," + binaryClient.channel());
            }
        }).onConnectionEffective(client -> {
            ReqConnectionReportSlave2MasterMessage msg = new ReqConnectionReportSlave2MasterMessage();
            InnerServerInfo info = new InnerServerInfo();
            info.innerPort = this.getMyInnerServerPort();
            info.outIp = this.getMyIp();
            info.outPass = this.getMyServerPass();
            info.outPort = this.getMyServerPort();
            info.serverId = this.getMyServerId();
            info.serverType = this.getSlaveType();
            msg.serverInfo = info;
            try {
                client.sendMessage(msg, (isSuccess, cause, channel) -> {
                    if (isSuccess.booleanValue()) {
                        log.info("report my server info to " + client.getClientName() + " success:" + info);
                    } else {
                        log.error("report my server info to master " + client.getClientName() + " fail:" + info, cause);
                    }
                });
            }
            catch (Exception e) {
                log.error("report message error", (Throwable)e);
            }
            if (this.reportTask == null) {
                this.reportTask = new TimerTask(){

                    @Override
                    public void run() {
                        InnerSlaveServer.this.reportLoad();
                    }
                };
                TimerUtil.scheduleGlobal(5000L, 5000L, this.reportTask);
            }
            Procs.invoke(this.onConnectMasterSuccess, this);
        }).dispatchMessage((message, handler) -> {
            message.setExtra(this);
            try {
                handler.handle(message);
            }
            catch (Exception e) {
                log.error("handle error", (Throwable)e);
            }
        }).build();
    }

    @Override
    public void startServer() {
        this.toMaster.connect();
    }

    @Override
    public void stopServer() {
        this.toMaster.disConnect();
    }

    private void reportLoad() {
        Integer invoke = Funcs.invoke(this.serverLoad);
        if (invoke == null) {
            return;
        }
        ReqServerLoadSlave2MasterMessage slm = new ReqServerLoadSlave2MasterMessage();
        slm.load = invoke;
        try {
            this.toMaster.sendMessage(slm, (isSuccess, cause, channel) -> {
                if (isSuccess.booleanValue()) {
                    log.debug("send server load to master {} success,current load:{}", channel, (Object)reqServerLoadSlave2MasterMessage.load);
                } else {
                    log.error("send server load to master {} fail,current load:{}", channel, (Object)reqServerLoadSlave2MasterMessage.load);
                }
            });
        }
        catch (Exception e) {
            log.error("report load error", (Throwable)e);
        }
    }

    public void ResServerJoinMaster2Slave(ResServerJoinMaster2SlaveMessage msg) {
        for (InnerServerInfo info : msg.infos) {
            Procs.invoke(this.onNewSlaveJoin, info);
        }
    }

    public void ResServerQuitMaster2Slave(ResServerQuitMaster2SlaveMessage msg) {
        Procs.invoke(this.onNewSlaveQuit, msg.serverType, msg.serverId);
    }

    public BinaryClient getMasterClient() {
        return this.toMaster;
    }

    public String getSlaveName() {
        return this.slaveName;
    }

    public int getSlaveType() {
        return this.slaveType;
    }

    public int getMyServerId() {
        return this.myServerId;
    }

    public String getMyIp() {
        return this.myIp;
    }

    public int getMyServerPort() {
        return this.myServerPort;
    }

    public String getMyServerPass() {
        return this.myServerPass;
    }

    public int getMyInnerServerPort() {
        return this.myInnerServerPort;
    }

    public String getMyInnerServerPass() {
        return this.myInnerServerPass;
    }

    public String getMasterIp() {
        return this.masterIp;
    }

    public int getMasterServerPort() {
        return this.masterServerPort;
    }

    public String getMasterServerPass() {
        return this.masterServerPass;
    }

    public int getMasterInnerPort() {
        return this.masterInnerPort;
    }

    public String getMasterInnerPass() {
        return this.masterInnerPass;
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    public static class InnerSlaveServerBuilder {
        private String slaveName = "Inner-Slave-Server";
        private int slaveType;
        private int myServerId;
        private String myServerIp;
        private int myServerPort;
        private String myServerPass;
        private int myInnerServerPort;
        private String myInnerServerPass;
        private String masterIp;
        private int masterServerPort;
        private String masterServerPass;
        private int masterInnerPort;
        private String masterInnerPass;
        private MessageFactory factory;
        private Func<Integer> serverLoad;
        private Proc1<InnerServerInfo> onNewSlaveJoin;
        private Proc2<Integer, Integer> onNewSlaveQuit;
        private Proc1<InnerSlaveServer> onConnectMasterSuccess;

        public InnerSlaveServer build() throws Exception {
            return new InnerSlaveServer(this);
        }

        public InnerSlaveServerBuilder slaveName(String slaveName) {
            this.slaveName = slaveName;
            return this;
        }

        public InnerSlaveServerBuilder slaveType(int slaveType) {
            this.slaveType = slaveType;
            return this;
        }

        public InnerSlaveServerBuilder myServerId(int myServerId) {
            this.myServerId = myServerId;
            return this;
        }

        public InnerSlaveServerBuilder myServerIp(String myServerIp) {
            this.myServerIp = myServerIp;
            return this;
        }

        public InnerSlaveServerBuilder myServerPort(int myServerPort) {
            if (myServerPort >= 1024) {
                this.myServerPort = myServerPort;
            }
            return this;
        }

        public InnerSlaveServerBuilder myServerPass(String myServerPass) {
            this.myServerPass = myServerPass;
            return this;
        }

        public InnerSlaveServerBuilder myInnerServerPort(int myInnerServerPort) {
            if (myInnerServerPort >= 1024) {
                this.myInnerServerPort = myInnerServerPort;
            }
            return this;
        }

        public InnerSlaveServerBuilder myInnerServerPass(String myInnerServerPass) {
            this.myInnerServerPass = myInnerServerPass;
            return this;
        }

        public InnerSlaveServerBuilder masterIp(String masterIp) {
            this.masterIp = masterIp;
            return this;
        }

        public InnerSlaveServerBuilder masterServerPort(int masterServerPort) {
            if (masterServerPort >= 1024) {
                this.masterServerPort = masterServerPort;
            }
            return this;
        }

        public InnerSlaveServerBuilder masterServerPass(String masterServerPass) {
            this.masterServerPass = masterServerPass;
            return this;
        }

        public InnerSlaveServerBuilder masterInnerPort(int masterInnerPort) {
            if (masterInnerPort >= 1024) {
                this.masterInnerPort = masterInnerPort;
            }
            return this;
        }

        public InnerSlaveServerBuilder masterInnerPass(String masterInnerPass) {
            this.masterInnerPass = masterInnerPass;
            return this;
        }

        public InnerSlaveServerBuilder facotry(MessageFactory factory) {
            this.factory = factory;
            return this;
        }

        public InnerSlaveServerBuilder serverLoad(Func<Integer> serverLoad) {
            this.serverLoad = serverLoad;
            return this;
        }

        public InnerSlaveServerBuilder onNewSlaveJoin(Proc1<InnerServerInfo> onNewSlaveJoin) {
            this.onNewSlaveJoin = onNewSlaveJoin;
            return this;
        }

        public InnerSlaveServerBuilder onNewSlaveQuit(Proc2<Integer, Integer> onNewSlaveQuit) {
            this.onNewSlaveQuit = onNewSlaveQuit;
            return this;
        }

        public InnerSlaveServerBuilder onConnectMasterSuccess(Proc1<InnerSlaveServer> onConnectMasterSuccess) {
            this.onConnectMasterSuccess = onConnectMasterSuccess;
            return this;
        }
    }
}

