/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary.message;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;

public final class ByteBufs {
    private ByteBufs() {
    }

    public static final void writeRawVarint64(ByteBuf buffer, long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.writeByte((int)((byte)value));
                return;
            }
            buffer.writeByte((int)((byte)((int)value & 0x7F | 0x80)));
            value >>>= 7;
        }
    }

    public static final long readRawVarint64(ByteBuf buffer) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buffer.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new CorruptedFrameException("malformed varint.");
    }

    public static final void writeRawVarint32(ByteBuf buffer, int val) {
        while (true) {
            if ((val & 0xFFFFFF80) == 0) {
                buffer.writeByte((int)((byte)val));
                return;
            }
            buffer.writeByte((int)((byte)(val & 0x7F | 0x80)));
            val >>>= 7;
        }
    }

    public static int readRawVarint32(ByteBuf buffer) {
        int x = buffer.readByte();
        if (x >= 0) {
            return x;
        }
        if ((long)(x ^= buffer.readByte() << 7) < 0L) {
            x = (int)((long)x ^ 0xFFFFFFFFFFFFFF80L);
        } else if ((long)(x ^= buffer.readByte() << 14) >= 0L) {
            x = (int)((long)x ^ 0x3F80L);
        } else if ((long)(x ^= buffer.readByte() << 21) < 0L) {
            x = (int)((long)x ^ 0xFFFFFFFFFFE03F80L);
        } else {
            byte y = buffer.readByte();
            x ^= y << 28;
            x = (int)((long)x ^ 0xFE03F80L);
            if (y < 0) {
                throw new CorruptedFrameException("malformed varint.");
            }
        }
        return x;
    }
}

