/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Func1;
import org.slingerxv.limitart.net.binary.handler.IHandler;
import org.slingerxv.limitart.net.binary.handler.annotation.Controller;
import org.slingerxv.limitart.net.binary.handler.annotation.Handler;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.MessageMeta;
import org.slingerxv.limitart.net.binary.message.exception.MessageCodecException;
import org.slingerxv.limitart.net.binary.message.exception.MessageIDDuplicatedException;
import org.slingerxv.limitart.reflectasm.ConstructorAccess;
import org.slingerxv.limitart.reflectasm.MethodAccess;
import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.ReflectionUtil;

public class MessageFactory {
    private static Logger log = LoggerFactory.getLogger(MessageFactory.class);
    private final Map<Short, ConstructorAccess<? extends Message>> msgs = new HashMap<Short, ConstructorAccess<? extends Message>>();
    private final Map<Short, IHandler<? extends Message>> handlers = new HashMap<Short, IHandler<? extends Message>>();

    @Beta
    public static MessageFactory createByPackage(String packageName, Func1<Class<?>, Object> confirmInstance) throws ReflectiveOperationException, IOException, MessageCodecException, MessageIDDuplicatedException {
        MessageFactory messageFactory = new MessageFactory();
        List<Class<?>> classesOfAnnotation = ReflectionUtil.getClassesByPackage(packageName, clazz -> clazz.getAnnotation(Controller.class) != null);
        for (Class<?> clzz : classesOfAnnotation) {
            messageFactory.registerController(clzz, confirmInstance);
        }
        return messageFactory;
    }

    public static MessageFactory createByPackage(String packageName) throws ReflectiveOperationException, IOException, MessageCodecException, MessageIDDuplicatedException {
        List<Class<?>> classesByPackage = ReflectionUtil.getClassesByPackage(packageName, IHandler.class);
        MessageFactory messageFactory = new MessageFactory();
        for (Class<?> clzz : classesByPackage) {
            if (Modifier.isAbstract(clzz.getModifiers()) || clzz.isAnonymousClass() || clzz.isMemberClass() || clzz.isLocalClass()) {
                log.warn("inner class or anonymous class or abstract class will not be registerd:" + clzz.getName());
                continue;
            }
            messageFactory.registerMsg(null, (IHandler)clzz.newInstance());
        }
        return messageFactory;
    }

    private static void checkMessageMeta(MessageMeta meta) throws ReflectiveOperationException, IOException, MessageCodecException {
        log.info("check message:" + meta.getClass().getName());
        ByteBuf buffer = Unpooled.buffer();
        meta.buffer(buffer);
        try {
            meta.encode();
            meta.decode();
        }
        catch (Exception e) {
            throw new MessageCodecException(e);
        }
        meta.buffer(null);
        buffer.release();
    }

    @Beta
    public MessageFactory registerController(Class<?> controllerClazz) throws MessageIDDuplicatedException, ReflectiveOperationException, IOException, MessageCodecException {
        return this.registerController(controllerClazz, clzz -> {
            try {
                return clzz.newInstance();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return null;
            }
        });
    }

    @Beta
    public MessageFactory registerController(final Class<?> controllerClazz, final Func1<Class<?>, Object> confirmInstance) throws MessageIDDuplicatedException, ReflectiveOperationException, IOException, MessageCodecException {
        final MethodAccess methodAccess = MethodAccess.get(controllerClazz);
        ArrayList<Method> methods = methodAccess.getMethods();
        for (final Method method : methods) {
            Handler annotation = method.getAnnotation(Handler.class);
            if (annotation == null) continue;
            this.registerMsg(annotation.value(), (IHandler<? extends Message>)new IHandler<Message>(){

                @Override
                public void handle(Message msg) {
                    methodAccess.invoke(confirmInstance.run(controllerClazz), method.getName(), msg);
                }
            });
        }
        return this;
    }

    public synchronized <T extends Message> MessageFactory registerMsg(Class<T> msgClazz, IHandler<? extends Message> handler) throws MessageIDDuplicatedException, ReflectiveOperationException, IOException, MessageCodecException {
        Class msgClass = msgClazz;
        if (msgClass == null) {
            Type[] genericInterfaces = handler.getClass().getGenericInterfaces();
            ParameterizedType handlerInterface = null;
            for (Type temp : genericInterfaces) {
                ParameterizedType ttemp;
                if (!(temp instanceof ParameterizedType) || (ttemp = (ParameterizedType)temp).getRawType() != IHandler.class) continue;
                handlerInterface = ttemp;
                break;
            }
            if (handlerInterface == null) {
                return this;
            }
            msgClass = (Class)handlerInterface.getActualTypeArguments()[0];
        }
        Message newInstance = (Message)msgClass.newInstance();
        MessageFactory.checkMessageMeta(newInstance);
        short id = newInstance.getMessageId();
        if (this.msgs.containsKey(id)) {
            Class<?> class1 = this.msgs.get(id).newInstance().getClass();
            if (!class1.getName().equals(msgClass.getName())) {
                throw new MessageIDDuplicatedException("message id duplicated:" + id + ",class old:" + class1.getName() + ",class new:" + msgClass.getName());
            }
            return this;
        }
        if (this.handlers.containsKey(id)) {
            throw new MessageIDDuplicatedException("handler id duplicated:" + id);
        }
        ConstructorAccess<T> constructorAccess = ConstructorAccess.get(msgClass);
        this.msgs.put(id, constructorAccess);
        this.handlers.put(id, handler);
        log.info("regist msg: {}\uff0chandler:{}", (Object)msgClass.getSimpleName(), (Object)handler.getClass().getSimpleName());
        return this;
    }

    public <T extends IHandler<? extends Message>> MessageFactory registerMsg(Class<T> handlerClass) throws InstantiationException, IllegalAccessException, MessageIDDuplicatedException, ReflectiveOperationException, IOException, MessageCodecException {
        return this.registerMsg(null, (IHandler)handlerClass.newInstance());
    }

    public MessageFactory registerMsg(IHandler<? extends Message> handler) throws MessageIDDuplicatedException, ReflectiveOperationException, IOException, MessageCodecException {
        return this.registerMsg(null, handler);
    }

    public Message getMessage(short msgId) throws ReflectiveOperationException {
        if (!this.msgs.containsKey(msgId)) {
            return null;
        }
        ConstructorAccess<? extends Message> constructorAccess = this.msgs.get(msgId);
        return constructorAccess.newInstance();
    }

    public IHandler<? extends Message> getHandler(short msgId) throws ReflectiveOperationException {
        return this.handlers.get(msgId);
    }
}

