/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary.message;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slingerxv.limitart.net.binary.message.ByteBufs;
import org.slingerxv.limitart.net.binary.message.exception.MessageIOException;
import org.slingerxv.limitart.reflectasm.ConstructorAccess;
import org.slingerxv.limitart.reflectasm.FieldAccess;
import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.FieldFilter;

public abstract class MessageMeta {
    @Beta
    private static boolean COMPRESS_INT32_64 = true;
    private static Map<Class<? extends MessageMeta>, ConstructorAccess> messageMetaCache = new ConcurrentHashMap<Class<? extends MessageMeta>, ConstructorAccess>();
    private static Map<Class<? extends MessageMeta>, FieldAccess> messageMetaFieldCache = new ConcurrentHashMap<Class<? extends MessageMeta>, FieldAccess>();
    private ByteBuf buffer;

    public static void setCompressOpen(boolean open) {
        COMPRESS_INT32_64 = open;
    }

    public void encode() throws Exception {
        Field[] fields;
        FieldAccess fieldAccess = this.getFieldAccess();
        for (Field temp : fields = fieldAccess.getFields()) {
            this.writeField(temp);
        }
    }

    private void writeField(Field field) throws Exception {
        Class<?> type = field.getType();
        Object object = field.get(this);
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                this.putByte(field.getByte(this));
            } else if (type == Short.TYPE) {
                this.putShort(field.getShort(this));
            } else if (type == Integer.TYPE) {
                this.putInt(field.getInt(this));
            } else if (type == Long.TYPE) {
                this.putLong(field.getLong(this));
            } else if (type == Float.TYPE) {
                this.putFloat(field.getFloat(this));
            } else if (type == Double.TYPE) {
                this.putDouble(field.getDouble(this));
            } else if (type == Character.TYPE) {
                this.putChar(field.getChar(this));
            } else if (type == Boolean.TYPE) {
                this.putBoolean(field.getBoolean(this));
            }
        } else if (type.isArray()) {
            Class<?> component = type.getComponentType();
            if (component == Byte.TYPE) {
                this.putByteArray((byte[])object);
            } else if (component == Short.TYPE) {
                this.putShortArray((short[])object);
            } else if (component == Integer.TYPE) {
                this.putIntArray((int[])object);
            } else if (component == Long.TYPE) {
                this.putLongArray((long[])object);
            } else if (component == Float.TYPE) {
                this.putFloatArray((float[])object);
            } else if (component == Double.TYPE) {
                this.putDoubleArray((double[])object);
            } else if (component == Character.TYPE) {
                this.putCharArray((char[])object);
            } else if (component == Boolean.TYPE) {
                this.putBooleanArray((boolean[])object);
            } else if (component == Byte.class) {
                if (object == null) {
                    this.putByteArray(null);
                } else {
                    Byte[] temp = (Byte[])object;
                    byte[] temp1 = new byte[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? (byte)0 : temp[i];
                    }
                    this.putByteArray(temp1);
                }
            } else if (component == Short.class) {
                if (object == null) {
                    this.putShortArray(null);
                } else {
                    Short[] temp = (Short[])object;
                    short[] temp1 = new short[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? (short)0 : temp[i];
                    }
                    this.putShortArray(temp1);
                }
            } else if (component == Integer.class) {
                if (object == null) {
                    this.putIntArray(null);
                } else {
                    Integer[] temp = (Integer[])object;
                    int[] temp1 = new int[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? 0 : temp[i];
                    }
                    this.putIntArray(temp1);
                }
            } else if (component == Long.class) {
                if (object == null) {
                    this.putLongArray(null);
                } else {
                    Long[] temp = (Long[])object;
                    long[] temp1 = new long[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? 0L : temp[i];
                    }
                    this.putLongArray(temp1);
                }
            } else if (component == Float.class) {
                if (object == null) {
                    this.putFloatArray(null);
                } else {
                    Float[] temp = (Float[])object;
                    float[] temp1 = new float[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? 0.0f : temp[i].floatValue();
                    }
                    this.putFloatArray(temp1);
                }
            } else if (component == Double.class) {
                if (object == null) {
                    this.putDoubleArray(null);
                } else {
                    Double[] temp = (Double[])object;
                    double[] temp1 = new double[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? 0.0 : temp[i];
                    }
                    this.putDoubleArray(temp1);
                }
            } else if (component == Character.class) {
                if (object == null) {
                    this.putCharArray(null);
                } else {
                    Character[] temp = (Character[])object;
                    char[] temp1 = new char[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? (char)'\u0000' : temp[i].charValue();
                    }
                    this.putCharArray(temp1);
                }
            } else if (component == Boolean.class) {
                if (object == null) {
                    this.putBooleanArray(null);
                } else {
                    Boolean[] temp = (Boolean[])object;
                    boolean[] temp1 = new boolean[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i] == null ? false : temp[i];
                    }
                    this.putBooleanArray(temp1);
                }
            } else if (component.getSuperclass() == MessageMeta.class) {
                this.putMessageMetaArray((MessageMeta[])object);
            } else if (component == String.class) {
                this.putStringArray((String[])object);
            }
        } else if (List.class.isAssignableFrom(type)) {
            ParameterizedType t = (ParameterizedType)field.getGenericType();
            Class component = (Class)t.getActualTypeArguments()[0];
            if (component == Byte.class) {
                this.putByteList((ArrayList)object);
            } else if (component == Short.class) {
                this.putShortList((ArrayList)object);
            } else if (component == Integer.class) {
                this.putIntList((ArrayList)object);
            } else if (component == Long.class) {
                this.putLongList((ArrayList)object);
            } else if (component == Float.class) {
                this.putFloatList((ArrayList)object);
            } else if (component == Double.class) {
                this.putDoubleList((ArrayList)object);
            } else if (component == Character.class) {
                this.putCharList((ArrayList)object);
            } else if (component == Boolean.class) {
                this.putBooleanList((ArrayList)object);
            } else if (component.getSuperclass() == MessageMeta.class) {
                this.putMessageMetaList((ArrayList)object);
            } else if (component == String.class) {
                this.putStringList((ArrayList)object);
            }
        } else if (type == Byte.class) {
            if (object == null) {
                this.putByte(0);
            } else {
                this.putByte(((Byte)object).byteValue());
            }
        } else if (type == Short.class) {
            if (object == null) {
                this.putShort(0);
            } else {
                this.putShort(((Short)object).shortValue());
            }
        } else if (type == Integer.class) {
            if (object == null) {
                this.putInt(0);
            } else {
                this.putInt((Integer)object);
            }
        } else if (type == Long.class) {
            if (object == null) {
                this.putLong(0L);
            } else {
                this.putLong((Long)object);
            }
        } else if (type == Float.class) {
            if (object == null) {
                this.putFloat(0.0f);
            } else {
                this.putFloat(((Float)object).floatValue());
            }
        } else if (type == Double.class) {
            if (object == null) {
                this.putDouble(0.0);
            } else {
                this.putDouble((Double)object);
            }
        } else if (type == Character.class) {
            if (object == null) {
                this.putChar(0);
            } else {
                this.putChar(((Character)object).charValue());
            }
        } else if (type == Boolean.class) {
            if (object == null) {
                this.putBoolean(false);
            } else {
                this.putBoolean((Boolean)object);
            }
        } else if (type.getSuperclass() == MessageMeta.class) {
            MessageMeta next = (MessageMeta)object;
            this.putMessageMeta(next);
        } else if (type == String.class) {
            this.putString((String)object);
        } else {
            System.err.println();
            throw new MessageIOException(this.getClass() + " type error(non MessageMeta field must be primitive(or it's box object),array or List. array's component  and List's generic param as the same as non MessageMeta rule ):" + type.getName());
        }
    }

    public void decode() throws Exception {
        Field[] fields;
        FieldAccess fieldAccess = this.getFieldAccess();
        for (Field temp : fields = fieldAccess.getFields()) {
            this.readField(temp);
        }
    }

    private void readField(Field field) throws IllegalArgumentException, IllegalAccessException, Exception {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            if (type == Byte.TYPE) {
                field.setByte(this, this.getByte());
            } else if (type == Short.TYPE) {
                field.setShort(this, this.getShort());
            } else if (type == Integer.TYPE) {
                field.setInt(this, this.getInt());
            } else if (type == Long.TYPE) {
                field.setLong(this, this.getLong());
            } else if (type == Float.TYPE) {
                field.setFloat(this, this.getFloat());
            } else if (type == Double.TYPE) {
                field.setDouble(this, this.getDouble());
            } else if (type == Character.TYPE) {
                field.setChar(this, this.getChar());
            } else if (type == Boolean.TYPE) {
                field.setBoolean(this, this.getBoolean());
            }
        } else if (type.isArray()) {
            Class<?> component = type.getComponentType();
            if (component == Byte.TYPE) {
                field.set(this, this.getByteArray());
            } else if (component == Short.TYPE) {
                field.set(this, this.getShortArray());
            } else if (component == Integer.TYPE) {
                field.set(this, this.getIntArray());
            } else if (component == Long.TYPE) {
                field.set(this, this.getLongArray());
            } else if (component == Float.TYPE) {
                field.set(this, this.getFloatArray());
            } else if (component == Double.TYPE) {
                field.set(this, this.getDoubleArray());
            } else if (component == Character.TYPE) {
                field.set(this, this.getCharArray());
            } else if (component == Boolean.TYPE) {
                field.set(this, this.getBooleanArray());
            } else if (component == Byte.class) {
                byte[] temp = this.getByteArray();
                if (temp != null) {
                    Byte[] temp1 = new Byte[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i];
                    }
                    field.set(this, temp1);
                }
            } else if (component == Short.class) {
                short[] temp = this.getShortArray();
                if (temp != null) {
                    Short[] temp1 = new Short[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i];
                    }
                    field.set(this, temp1);
                }
            } else if (component == Integer.class) {
                int[] temp = this.getIntArray();
                if (temp != null) {
                    Integer[] temp1 = new Integer[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i];
                    }
                    field.set(this, temp1);
                }
            } else if (component == Long.class) {
                long[] temp = this.getLongArray();
                if (temp != null) {
                    Long[] temp1 = new Long[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i];
                    }
                    field.set(this, temp1);
                }
            } else if (component == Float.class) {
                float[] temp = this.getFloatArray();
                if (temp != null) {
                    Float[] temp1 = new Float[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = Float.valueOf(temp[i]);
                    }
                    field.set(this, temp1);
                }
            } else if (component == Double.class) {
                double[] temp = this.getDoubleArray();
                if (temp != null) {
                    Double[] temp1 = new Double[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i];
                    }
                    field.set(this, temp1);
                }
            } else if (component == Character.class) {
                char[] temp = this.getCharArray();
                if (temp != null) {
                    Character[] temp1 = new Character[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = Character.valueOf(temp[i]);
                    }
                    field.set(this, temp1);
                }
            } else if (component == Boolean.class) {
                boolean[] temp = this.getBooleanArray();
                if (temp != null) {
                    Boolean[] temp1 = new Boolean[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        temp1[i] = temp[i];
                    }
                    field.set(this, temp1);
                }
            } else if (component.getSuperclass() == MessageMeta.class) {
                field.set(this, this.getMessageMetaArray(component));
            } else if (component == String.class) {
                field.set(this, this.getStringArray());
            }
        } else if (List.class.isAssignableFrom(type)) {
            ParameterizedType t = (ParameterizedType)field.getGenericType();
            Class component = (Class)t.getActualTypeArguments()[0];
            if (component == Byte.class) {
                field.set(this, this.getByteList());
            } else if (component == Short.class) {
                field.set(this, this.getShortList());
            } else if (component == Integer.class) {
                field.set(this, this.getIntList());
            } else if (component == Long.class) {
                field.set(this, this.getLongList());
            } else if (component == Float.class) {
                field.set(this, this.getFloatList());
            } else if (component == Double.class) {
                field.set(this, this.getDoubleList());
            } else if (component == Character.class) {
                field.set(this, this.getCharList());
            } else if (component == Boolean.class) {
                field.set(this, this.getBooleanList());
            } else if (component.getSuperclass() == MessageMeta.class) {
                field.set(this, this.getMessageMetaList(component));
            } else if (component == String.class) {
                field.set(this, this.getStringList());
            }
        } else if (type == Byte.class) {
            field.set(this, this.getByte());
        } else if (type == Short.class) {
            field.set(this, this.getShort());
        } else if (type == Integer.class) {
            field.set(this, this.getInt());
        } else if (type == Long.class) {
            field.set(this, this.getLong());
        } else if (type == Float.class) {
            field.set(this, Float.valueOf(this.getFloat()));
        } else if (type == Double.class) {
            field.set(this, this.getDouble());
        } else if (type == Character.class) {
            field.set(this, Character.valueOf(this.getChar()));
        } else if (type == Boolean.class) {
            field.set(this, this.getBoolean());
        } else if (type.getSuperclass() == MessageMeta.class) {
            field.set(this, this.getMessageMeta(type));
        } else if (type == String.class) {
            field.set(this, this.getString());
        } else {
            throw new MessageIOException(this.getClass() + " type error(non MessageMeta field must be primitive(or it's box object),array or List. array's component  and List's generic param as the same as non MessageMeta rule ):" + type.getName());
        }
    }

    private FieldAccess getFieldAccess() {
        FieldAccess fieldAccess = messageMetaFieldCache.get(this.getClass());
        if (fieldAccess == null) {
            fieldAccess = FieldAccess.get(this.getClass(), false, field -> !FieldFilter.isStatic(field) && !FieldFilter.isTransient(field) && !FieldFilter.isFinal(field));
            FieldAccess put = messageMetaFieldCache.putIfAbsent(this.getClass(), fieldAccess);
            if (put != null) {
                fieldAccess = put;
            }
        }
        return fieldAccess;
    }

    public void buffer(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    public final void putMessageMeta(MessageMeta meta) throws Exception {
        if (meta == null) {
            this.putByte(0);
        } else {
            this.putByte(1);
            meta.buffer(this.buffer);
            meta.encode();
        }
    }

    public final <T extends MessageMeta> T getMessageMeta(Class<T> clazz) throws Exception {
        byte len = this.getByte();
        if (len == 0) {
            return null;
        }
        T newInstance = this.createInstance(clazz);
        ((MessageMeta)newInstance).buffer(this.buffer);
        ((MessageMeta)newInstance).decode();
        ((MessageMeta)newInstance).buffer(null);
        return newInstance;
    }

    public final <T extends MessageMeta> void putMessageMetaList(ArrayList<T> value) throws Exception {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (MessageMeta temp : value) {
                this.putMessageMeta(temp);
            }
        }
    }

    public final <T extends MessageMeta> ArrayList<T> getMessageMetaList(Class<T> clazz) throws Exception {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < len; ++i) {
            T messageMeta = this.getMessageMeta(clazz);
            list.add(messageMeta);
        }
        return list;
    }

    public final <T extends MessageMeta> void putMessageMetaArray(T[] value) throws Exception {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (T t : value) {
                this.putMessageMeta((MessageMeta)t);
            }
        }
    }

    public final <T extends MessageMeta> T[] getMessageMetaArray(Class<T> clazz) throws Exception {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return (MessageMeta[])Array.newInstance(clazz, 0);
        }
        MessageMeta[] result = (MessageMeta[])Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            result[i] = this.getMessageMeta(clazz);
        }
        return result;
    }

    public final void putString(String value) {
        if (value == null) {
            this.putByteArray(null);
        } else if ("".equals(value)) {
            this.putByteArray(new byte[0]);
        } else {
            byte[] bytes = value.getBytes(CharsetUtil.UTF_8);
            this.putByteArray(bytes);
        }
    }

    public final String getString() {
        byte[] bytes = this.getByteArray();
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        return new String(bytes, CharsetUtil.UTF_8);
    }

    public final void putStringList(ArrayList<String> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (String temp : value) {
                this.putString(temp);
            }
        }
    }

    public final ArrayList<String> getStringList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getString());
        }
        return list;
    }

    public final void putStringArray(String[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (String temp : value) {
                this.putString(temp);
            }
        }
    }

    public final String[] getStringArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new String[0];
        }
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getString();
        }
        return result;
    }

    public final void putLong(long value) {
        if (COMPRESS_INT32_64) {
            ByteBufs.writeRawVarint64(this.buffer, value);
        } else {
            this.buffer.writeLong(value);
        }
    }

    public final long getLong() {
        if (COMPRESS_INT32_64) {
            return ByteBufs.readRawVarint64(this.buffer);
        }
        return this.buffer.readLong();
    }

    public final void putLongList(ArrayList<Long> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Long temp : value) {
                this.putLong(temp);
            }
        }
    }

    public final ArrayList<Long> getLongList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getLong());
        }
        return list;
    }

    public final void putLongArray(long[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (long temp : value) {
                this.putLong(temp);
            }
        }
    }

    public final long[] getLongArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new long[0];
        }
        long[] result = new long[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getLong();
        }
        return result;
    }

    public final void putInt(int value) {
        if (COMPRESS_INT32_64) {
            ByteBufs.writeRawVarint32(this.buffer, value);
        } else {
            this.buffer.writeInt(value);
        }
    }

    public final int getInt() {
        if (COMPRESS_INT32_64) {
            return ByteBufs.readRawVarint32(this.buffer);
        }
        return this.buffer.readInt();
    }

    public final void putIntList(ArrayList<Integer> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Integer temp : value) {
                this.putInt(temp);
            }
        }
    }

    public final ArrayList<Integer> getIntList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getInt());
        }
        return list;
    }

    public final ArrayList<Byte> getByteList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Byte>();
        }
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getByte());
        }
        return list;
    }

    public final void putIntArray(int[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (int temp : value) {
                this.putInt(temp);
            }
        }
    }

    public final int[] getIntArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new int[0];
        }
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getInt();
        }
        return result;
    }

    public final void putByte(int value) {
        this.buffer.writeByte(value);
    }

    public final void putByteList(ArrayList<Byte> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Byte temp : value) {
                this.putByte(temp.byteValue());
            }
        }
    }

    public final byte getByte() {
        return this.buffer.readByte();
    }

    public final void putByteArrayList(ArrayList<byte[]> list) {
        if (list == null) {
            this.putShort(-1);
        } else {
            this.putShort(list.size());
            for (byte[] bt : list) {
                this.putByteArray(bt);
            }
        }
    }

    public final ArrayList<byte[]> getByteArrayList() {
        short len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<byte[]>();
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        list.add(this.getByteArray());
        return list;
    }

    public final void putByteArray(byte[] bytes) {
        if (bytes == null) {
            this.putShort(-1);
        } else {
            this.putShort(bytes.length);
            this.buffer.writeBytes(bytes);
        }
    }

    public final byte[] getByteArray() {
        short len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[len];
        this.buffer.readBytes(bytes, 0, (int)len);
        return bytes;
    }

    public final void putBoolean(boolean value) {
        this.buffer.writeBoolean(value);
    }

    public final boolean getBoolean() {
        return this.buffer.readBoolean();
    }

    public final void putBooleanList(ArrayList<Boolean> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (boolean temp : value) {
                this.putBoolean(temp);
            }
        }
    }

    public final ArrayList<Boolean> getBooleanList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Boolean>();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getBoolean());
        }
        return list;
    }

    public final void putBooleanArray(boolean[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (boolean temp : value) {
                this.putBoolean(temp);
            }
        }
    }

    public final boolean[] getBooleanArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new boolean[0];
        }
        boolean[] result = new boolean[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getBoolean();
        }
        return result;
    }

    public final void putFloat(float value) {
        this.buffer.writeFloat(value);
    }

    public final float getFloat() {
        return this.buffer.readFloat();
    }

    public final void putFloatList(ArrayList<Float> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Float temp : value) {
                this.putFloat(temp.floatValue());
            }
        }
    }

    public final ArrayList<Float> getFloatList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Float>();
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (int i = 0; i < len; ++i) {
            list.add(Float.valueOf(this.getFloat()));
        }
        return list;
    }

    public final void putFloatArray(float[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (float temp : value) {
                this.putFloat(temp);
            }
        }
    }

    public final float[] getFloatArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new float[0];
        }
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getFloat();
        }
        return result;
    }

    public final void putDouble(double value) {
        this.buffer.writeDouble(value);
    }

    public final double getDouble() {
        return this.buffer.readDouble();
    }

    public final void putDoubleList(ArrayList<Double> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Double temp : value) {
                this.putDouble(temp);
            }
        }
    }

    public final ArrayList<Double> getDoubleList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getDouble());
        }
        return list;
    }

    public final void putDoubleArray(double[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (double temp : value) {
                this.putDouble(temp);
            }
        }
    }

    public final double[] getDoubleArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new double[0];
        }
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getDouble();
        }
        return result;
    }

    public final void putShort(int value) {
        if (COMPRESS_INT32_64) {
            ByteBufs.writeRawVarint32(this.buffer, value);
        } else {
            this.buffer.writeShort(value);
        }
    }

    public final short getShort() {
        if (COMPRESS_INT32_64) {
            return (short)ByteBufs.readRawVarint32(this.buffer);
        }
        return this.buffer.readShort();
    }

    public final void putShortList(ArrayList<Short> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Short temp : value) {
                this.putShort(temp.shortValue());
            }
        }
    }

    public final ArrayList<Short> getShortList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Short>();
        }
        ArrayList<Short> list = new ArrayList<Short>();
        for (int i = 0; i < len; ++i) {
            list.add(this.getShort());
        }
        return list;
    }

    public final void putShortArray(short[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (short temp : value) {
                this.putShort(temp);
            }
        }
    }

    public final short[] getShortArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new short[0];
        }
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getShort();
        }
        return result;
    }

    public final void putChar(int value) {
        this.buffer.writeChar(value);
    }

    public final char getChar() {
        return this.buffer.readChar();
    }

    public final void putCharList(ArrayList<Character> value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.size());
            for (Character temp : value) {
                this.putChar(temp.charValue());
            }
        }
    }

    public final ArrayList<Character> getCharList() {
        int len = this.getShort();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ArrayList<Character>();
        }
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < len; ++i) {
            list.add(Character.valueOf(this.getChar()));
        }
        return list;
    }

    public final void putCharArray(char[] value) {
        if (value == null) {
            this.putShort(-1);
        } else {
            this.putShort(value.length);
            for (char temp : value) {
                this.putChar(temp);
            }
        }
    }

    public final char[] getCharArray() {
        int length = this.getShort();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return new char[0];
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getChar();
        }
        return result;
    }

    private <T extends MessageMeta> T createInstance(Class<T> clazz) {
        ConstructorAccess<T> putIfAbsent;
        ConstructorAccess<T> constructorAccess = messageMetaCache.get(clazz);
        if (constructorAccess == null && (putIfAbsent = messageMetaCache.putIfAbsent(clazz, constructorAccess = ConstructorAccess.get(clazz))) != null) {
            constructorAccess = putIfAbsent;
        }
        return (T)((MessageMeta)constructorAccess.newInstance());
    }
}

