/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.binary.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slingerxv.limitart.collections.FrequencyReadRankMap;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.binary.codec.AbstractBinaryEncoder;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.exception.MessageCodecException;
import org.slingerxv.limitart.net.binary.util.FlowComparator;
import org.slingerxv.limitart.net.binary.util.FlowMeta;

public final class SendMessageUtil {
    public static boolean IS_FLOW = true;
    private static FlowComparator COMPARATOR = new FlowComparator();
    private static Map<Class<? extends Message>, Integer> FLOW_MIN = new ConcurrentHashMap<Class<? extends Message>, Integer>();
    private static Map<Class<? extends Message>, Integer> FLOW_MAX = new ConcurrentHashMap<Class<? extends Message>, Integer>();
    private static Map<Class<? extends Message>, Long> FLOW_COUNT = new ConcurrentHashMap<Class<? extends Message>, Long>();
    private static Map<Class<? extends Message>, Long> FLOW_SIZE = new ConcurrentHashMap<Class<? extends Message>, Long>();

    private SendMessageUtil() {
    }

    public static void sendMessage(AbstractBinaryEncoder encoder, Channel channel, Message msg, Proc3<Boolean, Throwable, Channel> listener) throws MessageCodecException {
        if (channel == null) {
            Procs.invoke(listener, false, new NullPointerException("channel"), null);
            return;
        }
        if (!channel.isWritable()) {
            Procs.invoke(listener, false, new IOException(" channel " + channel.remoteAddress() + " is unwritable"), channel);
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        encoder.beforeWriteBody(buffer, msg.getMessageId());
        msg.buffer(buffer);
        try {
            msg.encode();
        }
        catch (Exception e) {
            throw new MessageCodecException(e);
        }
        msg.buffer(null);
        encoder.afterWriteBody(buffer);
        SendMessageUtil.flow(msg.getClass(), buffer);
        channel.writeAndFlush((Object)buffer).addListener((GenericFutureListener)((ChannelFutureListener)arg0 -> Procs.invoke(listener, arg0.isSuccess(), arg0.cause(), arg0.channel())));
    }

    public static void sendMessage(AbstractBinaryEncoder encoder, List<Channel> channels, Message msg, Proc3<Boolean, Throwable, Channel> listener) throws MessageCodecException {
        if (channels == null || channels.isEmpty()) {
            Procs.invoke(listener, false, new IOException(" channel list  is null"), null);
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        encoder.beforeWriteBody(buffer, msg.getMessageId());
        msg.buffer(buffer);
        try {
            msg.encode();
        }
        catch (Exception e) {
            throw new MessageCodecException(e);
        }
        msg.buffer(null);
        encoder.afterWriteBody(buffer);
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = channels.get(i);
            if (!channel.isWritable()) {
                Procs.invoke(listener, false, new IOException(" channel " + channel.remoteAddress() + " is unwritable"), channel);
                continue;
            }
            ByteBuf retainedSlice = buffer.retainedSlice();
            SendMessageUtil.flow(msg.getClass(), retainedSlice);
            channel.writeAndFlush((Object)retainedSlice).addListener((GenericFutureListener)((ChannelFutureListener)arg0 -> Procs.invoke(listener, arg0.isSuccess(), arg0.cause(), arg0.channel())));
            if (i != channels.size() - 1) continue;
            buffer.release();
        }
    }

    private static void flow(Class<? extends Message> clazz, ByteBuf buf) {
        if (!IS_FLOW) {
            return;
        }
        FLOW_MIN.putIfAbsent(clazz, Integer.MAX_VALUE);
        FLOW_MAX.putIfAbsent(clazz, 0);
        FLOW_COUNT.putIfAbsent(clazz, 0L);
        FLOW_SIZE.putIfAbsent(clazz, 0L);
        int readableBytes = buf.readableBytes();
        FLOW_MIN.put(clazz, Math.min(FLOW_MIN.get(clazz), readableBytes));
        FLOW_MAX.put(clazz, Math.max(FLOW_MAX.get(clazz), readableBytes));
        FLOW_COUNT.put(clazz, FLOW_COUNT.get(clazz) + 1L);
        FLOW_SIZE.put(clazz, FLOW_SIZE.get(clazz) + (long)readableBytes);
    }

    public static String reportFlow(int top) {
        FlowMeta meta;
        if (!IS_FLOW) {
            return "no flow to report";
        }
        if (top < 1) {
            return "top error!";
        }
        FrequencyReadRankMap<Class<? extends Message>, FlowMeta> min = new FrequencyReadRankMap<Class<? extends Message>, FlowMeta>(COMPARATOR, top);
        FrequencyReadRankMap<Class<? extends Message>, FlowMeta> max = new FrequencyReadRankMap<Class<? extends Message>, FlowMeta>(COMPARATOR, top);
        FrequencyReadRankMap<Class<? extends Message>, FlowMeta> count = new FrequencyReadRankMap<Class<? extends Message>, FlowMeta>(COMPARATOR, top);
        FrequencyReadRankMap<Class<? extends Message>, FlowMeta> size = new FrequencyReadRankMap<Class<? extends Message>, FlowMeta>(COMPARATOR, top);
        for (Map.Entry<Class<? extends Message>, Integer> entry : FLOW_MIN.entrySet()) {
            meta = new FlowMeta();
            meta.setClazz(entry.getKey());
            meta.setValue(entry.getValue().intValue());
            min.put(entry.getKey(), meta);
        }
        for (Map.Entry<Class<? extends Message>, Integer> entry : FLOW_MAX.entrySet()) {
            meta = new FlowMeta();
            meta.setClazz(entry.getKey());
            meta.setValue(entry.getValue().intValue());
            max.put(entry.getKey(), meta);
        }
        for (Map.Entry<Class<? extends Message>, Number> entry : FLOW_COUNT.entrySet()) {
            meta = new FlowMeta();
            meta.setClazz(entry.getKey());
            meta.setValue((Long)entry.getValue());
            count.put(entry.getKey(), meta);
        }
        for (Map.Entry<Class<? extends Message>, Number> entry : FLOW_SIZE.entrySet()) {
            meta = new FlowMeta();
            meta.setClazz(entry.getKey());
            meta.setValue((Long)entry.getValue());
            size.put(entry.getKey(), meta);
        }
        List minRange = min.getRange(0, top);
        List list = max.getRange(0, top);
        List countRange = count.getRange(0, top);
        List sizeRange = size.getRange(0, top);
        StringBuilder sb = new StringBuilder();
        sb.append("=======min:").append("\r\n");
        for (FlowMeta meta2 : minRange) {
            sb.append(meta2.toString()).append("\r\n");
        }
        sb.append("=======max:").append("\r\n");
        for (FlowMeta meta2 : list) {
            sb.append(meta2.toString()).append("\r\n");
        }
        sb.append("=======count:").append("\r\n");
        for (FlowMeta meta2 : countRange) {
            sb.append(meta2.toString()).append("\r\n");
        }
        sb.append("=======size:").append("\r\n");
        for (FlowMeta meta2 : sizeRange) {
            sb.append(meta2.toString()).append("\r\n");
        }
        return sb.toString();
    }
}

