/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.collections.ConstraintMap;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AbstractNettyServer;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.http.codec.QueryStringDecoderV2;
import org.slingerxv.limitart.net.http.constant.QueryMethod;
import org.slingerxv.limitart.net.http.constant.RequestErrorCode;
import org.slingerxv.limitart.net.http.handler.HttpHandler;
import org.slingerxv.limitart.net.http.message.UrlMessage;
import org.slingerxv.limitart.net.http.message.UrlMessageFactory;
import org.slingerxv.limitart.net.http.util.HttpUtil;
import org.slingerxv.limitart.util.StringUtil;

@ChannelHandler.Sharable
public class HttpServer
extends AbstractNettyServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(HttpServer.class);
    private String serverName;
    private int port;
    private int httpObjectAggregatorMax;
    private UrlMessageFactory facotry;
    private Set<String> whiteList;
    private Proc1<Channel> onServerBind;
    private Proc2<Channel, Boolean> onChannelStateChanged;
    private Proc2<UrlMessage, HttpHandler<UrlMessage>> dispatchMessage;
    private Proc2<Channel, HttpMessage> onMessageOverSize;
    private Proc2<Channel, Throwable> onExceptionCaught;

    private HttpServer(HttpServerBuilder builder) {
        super(builder.serverName);
        this.port = builder.port;
        this.httpObjectAggregatorMax = builder.httpObjectAggregatorMax;
        this.serverName = builder.serverName;
        this.whiteList = builder.whiteList;
        Objects.requireNonNull(builder.facotry, "factory");
        this.facotry = builder.facotry;
        this.onServerBind = builder.onServerBind;
        this.onChannelStateChanged = builder.onChannelStateChanged;
        this.dispatchMessage = builder.dispatchMessage;
        this.onMessageOverSize = builder.onMessageOverSize;
        this.onExceptionCaught = builder.onExceptionCaught;
    }

    @Override
    protected void initPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(this.httpObjectAggregatorMax){

            protected void handleOversizedMessage(ChannelHandlerContext ctx, HttpMessage oversized) throws Exception {
                Exception e = new Exception(ctx.channel() + " : " + oversized + " is over size");
                log.error(e.getMessage(), (Throwable)e);
                Procs.invoke(HttpServer.this.onMessageOverSize, ctx.channel(), oversized);
            }
        }}).addLast(new ChannelHandler[]{new HttpContentCompressor()});
    }

    @Override
    protected void exceptionCaught0(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Procs.invoke(this.onExceptionCaught, ctx.channel(), cause);
    }

    @Override
    protected void channelActive0(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress insocket;
        String remoteAddress;
        if (this.whiteList != null && !this.whiteList.isEmpty() && !this.whiteList.contains(remoteAddress = (insocket = (InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress())) {
            ctx.channel().close();
            log.error("ip: " + remoteAddress + " rejected link!");
            return;
        }
        Procs.invoke(this.onChannelStateChanged, ctx.channel(), true);
    }

    @Override
    protected void channelInactive0(ChannelHandlerContext ctx) throws Exception {
        Procs.invoke(this.onChannelStateChanged, ctx.channel(), false);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object arg) throws Exception {
        String url;
        FullHttpRequest msg = (FullHttpRequest)arg;
        if (!msg.decoderResult().isSuccess()) {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_DECODE_FAIL);
            return;
        }
        if (StringUtil.isEmptyOrNull(msg.uri())) {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_URL_EMPTY);
            return;
        }
        ConstraintMap<Object> params = ConstraintMap.empty();
        if (msg.method() == HttpMethod.GET) {
            QueryStringDecoderV2 queryStringDecoder = new QueryStringDecoderV2(msg.uri());
            url = queryStringDecoder.path();
            params = queryStringDecoder.parameters();
        } else if (msg.method() == HttpMethod.POST) {
            url = msg.uri();
        } else {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_METHOD_FORBBIDEN);
            return;
        }
        if ("/2016info".equals(url)) {
            HttpUtil.sendResponse(ctx.channel(), HttpResponseStatus.OK, "hello~stupid!", true);
            return;
        }
        UrlMessage message = this.facotry.getMessage(url);
        if (message == null) {
            log.error("\u6d88\u606f\u4e0d\u5b58\u5728:" + url);
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_URL_FORBBIDEN);
            return;
        }
        if (message.getMethod() == null) {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_METHOD_FORBBIDEN);
            return;
        }
        if (message.getMethod() == QueryMethod.POST && msg.method() != HttpMethod.POST) {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_METHOD_ERROR);
            return;
        }
        HttpHandler<? extends UrlMessage> handler = this.facotry.getHandler(url);
        if (handler == null) {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_URL_FORBBIDEN);
            return;
        }
        message.setChannel(ctx.channel());
        if (msg.method() == HttpMethod.POST) {
            try {
                HttpPostRequestDecoder postDecoder = new HttpPostRequestDecoder((HttpRequest)msg);
                List postData = postDecoder.getBodyHttpDatas();
                for (InterfaceHttpData data : postData) {
                    FileUpload fileUpload;
                    int readableBytes;
                    if (data instanceof Attribute) {
                        Attribute at = (Attribute)data;
                        String name = at.getName();
                        String value = at.getValue();
                        params.putObj(name, value);
                        continue;
                    }
                    if (!(data instanceof FileUpload) || (readableBytes = (fileUpload = (FileUpload)data).content().readableBytes()) <= 0) continue;
                    String name = fileUpload.getFilename();
                    byte[] file = new byte[readableBytes];
                    fileUpload.content().readBytes(file);
                    message.getFiles().put(name, file);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_POST_ERROR);
                return;
            }
        }
        message.putAll(params);
        try {
            message.decode();
        }
        catch (Exception e) {
            HttpUtil.sendResponseError(ctx.channel(), RequestErrorCode.ERROR_MESSAGE_PARSE, e.getMessage());
            return;
        }
        message.setKeepAlive(io.netty.handler.codec.http.HttpUtil.isKeepAlive((HttpMessage)msg));
        if (this.dispatchMessage != null) {
            try {
                this.dispatchMessage.run(message, handler);
            }
            catch (Exception e) {
                log.error(ctx.channel() + " cause:", (Throwable)e);
                Procs.invoke(this.onExceptionCaught, this.channel(), e);
            }
        } else {
            log.warn(this.serverName + " no dispatch message listener!");
        }
    }

    @Override
    public void startServer() {
        this.bind(this.port, this.onServerBind);
    }

    @Override
    public void stopServer() {
        this.unbind();
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public int getPort() {
        return this.port;
    }

    public int getHttpObjectAggregatorMax() {
        return this.httpObjectAggregatorMax;
    }

    public Set<String> getWhiteList() {
        return this.whiteList;
    }

    public UrlMessageFactory getFacotry() {
        return this.facotry;
    }

    public Proc1<Channel> getOnServerBind() {
        return this.onServerBind;
    }

    public static class HttpServerBuilder {
        private String serverName = "Http-Server";
        private int port = 8080;
        private int httpObjectAggregatorMax = 0x100000;
        private UrlMessageFactory facotry;
        private Set<String> whiteList = new HashSet<String>();
        private Proc1<Channel> onServerBind;
        private Proc2<Channel, Boolean> onChannelStateChanged;
        private Proc2<UrlMessage, HttpHandler<UrlMessage>> dispatchMessage = (message, handler) -> handler.doServer(message);
        private Proc2<Channel, HttpMessage> onMessageOverSize;
        private Proc2<Channel, Throwable> onExceptionCaught;

        public HttpServer build() {
            return new HttpServer(this);
        }

        public HttpServerBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public HttpServerBuilder port(int port) {
            if (port >= 1024) {
                this.port = port;
            }
            return this;
        }

        public HttpServerBuilder httpObjectAggregatorMax(int httpObjectAggregatorMax) {
            this.httpObjectAggregatorMax = Math.max(512, httpObjectAggregatorMax);
            return this;
        }

        public HttpServerBuilder whiteList(String ... remoteAddress) {
            for (String ip : remoteAddress) {
                if (!StringUtil.isIp4(ip)) continue;
                this.whiteList.add(ip);
            }
            return this;
        }

        public HttpServerBuilder factory(UrlMessageFactory factory) {
            this.facotry = factory;
            return this;
        }

        public HttpServerBuilder onServerBind(Proc1<Channel> onServerBind) {
            this.onServerBind = onServerBind;
            return this;
        }

        public HttpServerBuilder onChannelStateChanged(Proc2<Channel, Boolean> onChannelStateChanged) {
            this.onChannelStateChanged = onChannelStateChanged;
            return this;
        }

        public HttpServerBuilder dispatchMessage(Proc2<UrlMessage, HttpHandler<UrlMessage>> dispatchMessage) {
            this.dispatchMessage = dispatchMessage;
            return this;
        }

        public HttpServerBuilder onMessageOverSize(Proc2<Channel, HttpMessage> onMessageOverSize) {
            this.onMessageOverSize = onMessageOverSize;
            return this;
        }

        public HttpServerBuilder onExceptionCaught(Proc2<Channel, Throwable> onExceptionCaught) {
            this.onExceptionCaught = onExceptionCaught;
            return this;
        }
    }
}

