/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.http.codec;

import io.netty.handler.codec.http.HttpConstants;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import org.slingerxv.limitart.collections.ConstraintMap;

public class QueryStringDecoderV2 {
    private static final int DEFAULT_MAX_PARAMS = 1024;
    private final Charset charset;
    private final String uri;
    private final boolean hasPath;
    private final int maxParams;
    private String path;
    private ConstraintMap<String> params;
    private int nParams;

    public QueryStringDecoderV2(String uri) {
        this(uri, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoderV2(String uri, boolean hasPath) {
        this(uri, HttpConstants.DEFAULT_CHARSET, hasPath);
    }

    public QueryStringDecoderV2(String uri, Charset charset) {
        this(uri, charset, true);
    }

    public QueryStringDecoderV2(String uri, Charset charset, boolean hasPath) {
        this(uri, charset, hasPath, 1024);
    }

    public QueryStringDecoderV2(String uri, Charset charset, boolean hasPath, int maxParams) {
        if (maxParams <= 0) {
            throw new IllegalArgumentException("maxParams: " + maxParams + " (expected: a positive integer)");
        }
        this.uri = Objects.requireNonNull(uri, "getUri");
        this.charset = Objects.requireNonNull(charset, "charset");
        this.maxParams = maxParams;
        this.hasPath = hasPath;
    }

    public QueryStringDecoderV2(URI uri) {
        this(uri, HttpConstants.DEFAULT_CHARSET);
    }

    public QueryStringDecoderV2(URI uri, Charset charset) {
        this(uri, charset, 1024);
    }

    public QueryStringDecoderV2(URI uri, Charset charset, int maxParams) {
        if (uri == null) {
            throw new NullPointerException("getUri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (maxParams <= 0) {
            throw new IllegalArgumentException("maxParams: " + maxParams + " (expected: a positive integer)");
        }
        String rawPath = uri.getRawPath();
        if (rawPath != null) {
            this.hasPath = true;
        } else {
            rawPath = "";
            this.hasPath = false;
        }
        this.uri = rawPath + (uri.getRawQuery() == null ? "" : '?' + uri.getRawQuery());
        this.charset = charset;
        this.maxParams = maxParams;
    }

    public String uri() {
        return this.uri;
    }

    public String path() {
        if (this.path == null) {
            int pathEndPos;
            this.path = !this.hasPath ? "" : QueryStringDecoderV2.decodeComponent((pathEndPos = this.uri.indexOf(63)) < 0 ? this.uri : this.uri.substring(0, pathEndPos), this.charset);
        }
        return this.path;
    }

    public ConstraintMap<String> parameters() {
        if (this.params == null) {
            if (this.hasPath) {
                int pathEndPos = this.uri.indexOf(63);
                if (pathEndPos >= 0 && pathEndPos < this.uri.length() - 1) {
                    this.decodeParams(this.uri.substring(pathEndPos + 1));
                } else {
                    this.params = ConstraintMap.empty();
                }
            } else if (this.uri.isEmpty()) {
                this.params = ConstraintMap.empty();
            } else {
                this.decodeParams(this.uri);
            }
        }
        return this.params;
    }

    private void decodeParams(String s) {
        int i;
        this.params = ConstraintMap.empty();
        ConstraintMap<String> params = this.params;
        this.nParams = 0;
        String name = null;
        int pos = 0;
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = QueryStringDecoderV2.decodeComponent(s.substring(pos, i), this.charset);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                if (!this.addParam(params, QueryStringDecoderV2.decodeComponent(s.substring(pos, i), this.charset), "")) {
                    return;
                }
            } else if (name != null) {
                if (!this.addParam(params, name, QueryStringDecoderV2.decodeComponent(s.substring(pos, i), this.charset))) {
                    return;
                }
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                this.addParam(params, QueryStringDecoderV2.decodeComponent(s.substring(pos, i), this.charset), "");
            } else {
                this.addParam(params, name, QueryStringDecoderV2.decodeComponent(s.substring(pos, i), this.charset));
            }
        } else if (name != null) {
            this.addParam(params, name, "");
        }
    }

    private boolean addParam(ConstraintMap<String> params, String name, String value) {
        if (this.nParams >= this.maxParams) {
            return false;
        }
        if (!params.containsKey(name)) {
            ++this.nParams;
        }
        params.putString(name, value);
        return true;
    }

    public static String decodeComponent(String s) {
        return QueryStringDecoderV2.decodeComponent(s, HttpConstants.DEFAULT_CHARSET);
    }

    public static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        int size = s.length();
        boolean modified = false;
        for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            if (c != '%' && c != '+') continue;
            modified = true;
            break;
        }
        if (!modified) {
            return s;
        }
        byte[] buf = new byte[size];
        int pos = 0;
        block5: for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    buf[pos++] = 32;
                    continue block5;
                }
                case '%': {
                    if (i == size - 1) {
                        throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                    }
                    if ((c = s.charAt(++i)) == '%') {
                        buf[pos++] = 37;
                        continue block5;
                    }
                    if (i == size - 1) {
                        throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                    }
                    c = QueryStringDecoderV2.decodeHexNibble(c);
                    char c2 = QueryStringDecoderV2.decodeHexNibble(s.charAt(++i));
                    if (c == '\uffff' || c2 == '\uffff') {
                        throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i - 1) + s.charAt(i) + "' at index " + (i - 2) + " of: " + s);
                    }
                    c = (char)(c * 16 + c2);
                }
                default: {
                    buf[pos++] = (byte)c;
                }
            }
        }
        return new String(buf, 0, pos, charset);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

