/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.http.message;

import io.netty.channel.Channel;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slingerxv.limitart.collections.ConstraintMap;
import org.slingerxv.limitart.net.http.constant.QueryMethod;
import org.slingerxv.limitart.reflectasm.FieldAccess;
import org.slingerxv.limitart.util.FieldFilter;

public abstract class UrlMessage
extends ConstraintMap<String> {
    private static Map<Class<? extends UrlMessage>, FieldAccess> messageMetaFieldCache = new ConcurrentHashMap<Class<? extends UrlMessage>, FieldAccess>();
    private transient Channel channel;
    private transient Map<String, byte[]> files = new HashMap<String, byte[]>();
    private boolean keepAlive;

    public abstract String getUrl();

    public abstract QueryMethod getMethod();

    public void decode() throws Exception {
        Field[] declaredFields;
        FieldAccess fieldAccess = this.getFieldAccess();
        for (Field field : declaredFields = fieldAccess.getFields()) {
            Object object = this.getObj(field.getName());
            if (object == null) continue;
            field.set(this, object);
        }
    }

    public void encode() throws Exception {
        Field[] declaredFields;
        FieldAccess fieldAccess = this.getFieldAccess();
        for (Field field : declaredFields = fieldAccess.getFields()) {
            Object object = field.get(this);
            if (object == null) continue;
            this.putObj(field.getName(), object);
        }
    }

    private FieldAccess getFieldAccess() {
        FieldAccess fieldAccess = messageMetaFieldCache.get(this.getClass());
        if (fieldAccess == null) {
            fieldAccess = FieldAccess.get(this.getClass(), false, field -> !FieldFilter.isStatic(field) && !FieldFilter.isTransient(field) && !FieldFilter.isFinal(field));
            FieldAccess put = messageMetaFieldCache.putIfAbsent(this.getClass(), fieldAccess);
            if (put != null) {
                fieldAccess = put;
            }
        }
        return fieldAccess;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Map<String, byte[]> getFiles() {
        return this.files;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }
}

