/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.http.message;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.net.binary.message.exception.MessageIDDuplicatedException;
import org.slingerxv.limitart.net.http.handler.HttpHandler;
import org.slingerxv.limitart.net.http.message.UrlMessage;
import org.slingerxv.limitart.reflectasm.ConstructorAccess;
import org.slingerxv.limitart.util.ReflectionUtil;

public class UrlMessageFactory {
    private static Logger log = LoggerFactory.getLogger(UrlMessageFactory.class);
    private Map<String, ConstructorAccess<? extends UrlMessage>> messages = new HashMap<String, ConstructorAccess<? extends UrlMessage>>();
    private Map<String, HttpHandler<? extends UrlMessage>> handlers = new HashMap<String, HttpHandler<? extends UrlMessage>>();

    public static UrlMessageFactory createByPackage(String packageName) throws IOException, MessageIDDuplicatedException, ReflectiveOperationException {
        UrlMessageFactory messageFactory = new UrlMessageFactory();
        List<Class<?>> classesByPackage = ReflectionUtil.getClassesByPackage(packageName, HttpHandler.class);
        for (Class<?> clzz : classesByPackage) {
            if (clzz.getName().contains("$")) {
                log.warn("inner class or anonymous class will not be register:" + clzz.getName());
                continue;
            }
            messageFactory.registerMsg((HttpHandler)clzz.newInstance());
        }
        return messageFactory;
    }

    public synchronized UrlMessageFactory registerMsg(HttpHandler<? extends UrlMessage> handler) throws ReflectiveOperationException, MessageIDDuplicatedException {
        Type[] genericInterfaces = handler.getClass().getGenericInterfaces();
        ParameterizedType handlerInterface = null;
        for (Type temp : genericInterfaces) {
            ParameterizedType ttemp;
            if (!(temp instanceof ParameterizedType) || (ttemp = (ParameterizedType)temp).getRawType() != HttpHandler.class) continue;
            handlerInterface = ttemp;
            break;
        }
        if (handlerInterface == null) {
            return this;
        }
        Class msgClass = (Class)handlerInterface.getActualTypeArguments()[0];
        UrlMessage newInstance = (UrlMessage)msgClass.newInstance();
        String url = newInstance.getUrl();
        if (this.messages.containsKey(url)) {
            Class<?> class1 = this.messages.get(url).newInstance().getClass();
            if (!class1.getName().equals(msgClass.getName())) {
                throw new MessageIDDuplicatedException("message id duplicated:" + url + ",class old:" + class1.getName() + ",class new:" + msgClass.getName());
            }
            return this;
        }
        if (this.handlers.containsKey(url)) {
            throw new IllegalArgumentException("handler url duplicated:" + url);
        }
        ConstructorAccess constructorAccess = ConstructorAccess.get(msgClass);
        this.messages.put(url, constructorAccess);
        this.handlers.put(url, handler);
        log.info("regist msg: {}\uff0chandler:{}", (Object)msgClass.getSimpleName(), (Object)handler.getClass().getSimpleName());
        return this;
    }

    public UrlMessageFactory registerMsg(Class<? extends HttpHandler<? extends UrlMessage>> handlerClass) throws ReflectiveOperationException, MessageIDDuplicatedException {
        return this.registerMsg(handlerClass.newInstance());
    }

    public UrlMessage getMessage(String url) throws ReflectiveOperationException {
        if (!this.messages.containsKey(url)) {
            return null;
        }
        return this.messages.get(url).newInstance();
    }

    public HttpHandler<? extends UrlMessage> getHandler(String url) throws InstantiationException, IllegalAccessException {
        return this.handlers.get(url);
    }
}

