/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.protobuf;

import com.google.protobuf.Message;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AbstractNettyClient;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.binary.message.exception.MessageCodecException;
import org.slingerxv.limitart.net.protobuf.handler.ProtoBufHandler;
import org.slingerxv.limitart.net.protobuf.message.ProtoBufFactory;

public class ProtoBufClient
extends AbstractNettyClient {
    private static Logger log = LoggerFactory.getLogger(ProtoBufClient.class);
    private AddressPair remoteAddress;
    private ProtoBufFactory factory;
    private Proc2<ProtoBufClient, Boolean> onChannelStateChanged;
    private Proc2<ProtoBufClient, Throwable> onExceptionCaught;
    private Proc3<Message, ProtoBufHandler<Message>, Channel> dispatchMessage;

    protected ProtoBufClient(ProtoBufClientBuilder builder) {
        super(builder.clientName, builder.autoReconnect);
        this.remoteAddress = Objects.requireNonNull(builder.remoteAddress, "remoteAddress");
        this.factory = Objects.requireNonNull(builder.factory, "factory");
        this.onChannelStateChanged = builder.onChannelStateChanged;
        this.onExceptionCaught = builder.onExceptionCaught;
        this.dispatchMessage = builder.dispatchMessage;
    }

    public void sendMessage(Message msg) {
        this.sendMessage(msg, null);
    }

    public void sendMessage(Message msg, Proc3<Boolean, Throwable, Channel> listener) {
        if (this.channel() == null) {
            Procs.invoke(listener, false, new NullPointerException("channel"), null);
            return;
        }
        if (!this.channel().isWritable()) {
            Procs.invoke(listener, false, new IOException(" channel " + this.channel().remoteAddress() + " is unwritable"), this.channel());
            return;
        }
        this.channel().writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)arg0 -> Procs.invoke(listener, arg0.isSuccess(), arg0.cause(), arg0.channel())));
    }

    @Override
    protected void initPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
        this.factory.copyToChannelPipeline(pipeline);
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
        pipeline.addLast(new ChannelHandler[]{new ProtobufEncoder()});
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Message message = (Message)msg;
        try {
            ProtoBufHandler<? extends Message> handler = this.factory.getHandler(message.getClass());
            if (handler == null) {
                throw new MessageCodecException(this.getClientName() + " handler empty:" + msg.getClass());
            }
            if (this.dispatchMessage != null) {
                try {
                    this.dispatchMessage.run(message, handler, ctx.channel());
                }
                catch (Exception e) {
                    log.error(ctx.channel() + " cause:", (Throwable)e);
                    Procs.invoke(this.onExceptionCaught, this, e);
                }
            } else {
                log.warn(this.getClientName() + " no dispatch message listener!");
            }
        }
        catch (Exception e) {
            log.error(ctx.channel().remoteAddress().toString(), (Throwable)e);
        }
    }

    @Override
    protected void channelInactive0(ChannelHandlerContext ctx) throws Exception {
        Procs.invoke(this.onChannelStateChanged, this, false);
        if (this.getAutoReconnect() > 0) {
            this.tryReconnect(this.remoteAddress.getIp(), this.remoteAddress.getPort(), this.getAutoReconnect());
        }
    }

    @Override
    protected void channelActive0(ChannelHandlerContext ctx) throws Exception {
        Procs.invoke(this.onChannelStateChanged, this, true);
    }

    @Override
    protected void exceptionCaught0(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Procs.invoke(this.onExceptionCaught, this, cause);
    }

    public SocketAddress remoteAddress() {
        return this.channel().remoteAddress();
    }

    public AddressPair getRemoteAddress() {
        return this.remoteAddress;
    }

    public ProtoBufFactory getFactory() {
        return this.factory;
    }

    @Override
    public void connect() {
        this.tryReconnect(this.remoteAddress.getIp(), this.remoteAddress.getPort(), 0);
    }

    @Override
    public void disConnect() {
        this.tryDisConnect();
    }

    public static class ProtoBufClientBuilder {
        private String clientName = "ProtoBuf-Client";
        private AddressPair remoteAddress = new AddressPair("127.0.0.1", 8888);
        private int autoReconnect = 0;
        private ProtoBufFactory factory = new ProtoBufFactory();
        private Proc2<ProtoBufClient, Boolean> onChannelStateChanged;
        private Proc2<ProtoBufClient, Throwable> onExceptionCaught;
        private Proc3<Message, ProtoBufHandler<Message>, Channel> dispatchMessage = (t1, t2, t3) -> t2.handle((Channel)t3, t1);

        public ProtoBufClient build() throws Exception {
            return new ProtoBufClient(this);
        }

        public ProtoBufClientBuilder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public ProtoBufClientBuilder remoteAddress(AddressPair remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public ProtoBufClientBuilder autoReconnect(int autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public ProtoBufClientBuilder factory(ProtoBufFactory factory) {
            this.factory = factory;
            return this;
        }

        public ProtoBufClientBuilder onChannelStateChanged(Proc2<ProtoBufClient, Boolean> onChannelStateChanged) {
            this.onChannelStateChanged = onChannelStateChanged;
            return this;
        }

        public ProtoBufClientBuilder onExceptionCaught(Proc2<ProtoBufClient, Throwable> onExceptionCaught) {
            this.onExceptionCaught = onExceptionCaught;
            return this;
        }

        public ProtoBufClientBuilder dispatchMessage(Proc3<Message, ProtoBufHandler<Message>, Channel> dispatchMessage) {
            this.dispatchMessage = dispatchMessage;
            return this;
        }
    }
}

