/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.protobuf;

import com.google.protobuf.Message;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AbstractNettyServer;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.binary.message.exception.MessageCodecException;
import org.slingerxv.limitart.net.protobuf.handler.ProtoBufHandler;
import org.slingerxv.limitart.net.protobuf.message.ProtoBufFactory;
import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.StringUtil;

@Beta
public class ProtoBufServer
extends AbstractNettyServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(ProtoBufServer.class);
    private AtomicInteger connectionCount = new AtomicInteger(0);
    private long startTime;
    private AddressPair addressPair;
    private Set<String> whiteList;
    private ProtoBufFactory factory;
    private int maxConnection;
    private int receiveIntervalMills;
    private Proc2<Channel, Boolean> onChannelStateChanged;
    private Proc2<Channel, Throwable> onExceptionCaught;
    private Proc1<Channel> onServerBind;
    private Proc3<Message, ProtoBufHandler<Message>, Channel> dispatchMessage;

    protected ProtoBufServer(ProtoBufServerBuilder builder) {
        super(builder.serverName);
        this.addressPair = Objects.requireNonNull(builder.addressPair, "addressPair");
        this.whiteList = Objects.requireNonNull(builder.whiteList, "whiteList");
        this.factory = Objects.requireNonNull(builder.factory, "factory");
        this.onChannelStateChanged = builder.onChannelStateChanged;
        this.onExceptionCaught = builder.onExceptionCaught;
        this.onServerBind = builder.onServerBind;
        this.dispatchMessage = builder.dispatchMessage;
        this.maxConnection = builder.maxConnection;
        this.receiveIntervalMills = builder.receiveIntervalMills;
    }

    @Override
    public void startServer() throws Exception {
        this.startTime = System.currentTimeMillis();
        this.bind(this.addressPair.getPort(), this.onServerBind);
    }

    @Override
    public void stopServer() {
        this.unbind();
    }

    @Override
    protected void initPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
        this.factory.copyToChannelPipeline(pipeline);
        pipeline.addLast(new ChannelHandler[]{new ProtobufVarint32LengthFieldPrepender()});
        pipeline.addLast(new ChannelHandler[]{new ProtobufEncoder()});
    }

    @Override
    protected void exceptionCaught0(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Procs.invoke(this.onExceptionCaught, ctx.channel(), cause);
    }

    @Override
    protected void channelActive0(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress insocket;
        String remoteAddress;
        if (this.maxConnection > 0 && this.connectionCount.get() >= this.maxConnection) {
            log.error("connection count is greater than " + this.maxConnection + " close channel:" + ctx.channel());
            ctx.channel().close();
            return;
        }
        if (this.whiteList != null && !this.whiteList.isEmpty() && !this.whiteList.contains(remoteAddress = (insocket = (InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress())) {
            ctx.channel().close();
            log.info("ip: " + remoteAddress + " rejected link!");
            return;
        }
        this.connectionCount.incrementAndGet();
        Procs.invoke(this.onChannelStateChanged, ctx.channel(), true);
    }

    @Override
    protected void channelInactive0(ChannelHandlerContext ctx) throws Exception {
        this.connectionCount.decrementAndGet();
        Procs.invoke(this.onChannelStateChanged, ctx.channel(), false);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Message message = (Message)msg;
        try {
            ProtoBufHandler<? extends Message> handler = this.factory.getHandler(message.getClass());
            if (handler == null) {
                throw new MessageCodecException(this.getServerName() + " handler empty:" + msg.getClass());
            }
            if (this.dispatchMessage != null) {
                try {
                    this.dispatchMessage.run(message, handler, ctx.channel());
                }
                catch (Exception e) {
                    log.error(ctx.channel() + " cause:", (Throwable)e);
                    Procs.invoke(this.onExceptionCaught, ctx.channel(), e);
                }
            } else {
                log.warn(this.getServerName() + " no dispatch message listener!");
            }
        }
        catch (Exception e) {
            ctx.channel().close();
            log.error("close session:" + ctx.channel(), (Throwable)e);
        }
    }

    public AddressPair getAddressPair() {
        return this.addressPair;
    }

    public Set<String> getWhiteList() {
        return this.whiteList;
    }

    public ProtoBufFactory getFactory() {
        return this.factory;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getConnectionCount() {
        return this.connectionCount.get();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getReceiveIntervalMills() {
        return this.receiveIntervalMills;
    }

    public static class ProtoBufServerBuilder {
        private String serverName = "ProtoBuf-Server";
        private AddressPair addressPair;
        private Set<String> whiteList = new HashSet<String>();
        private ProtoBufFactory factory;
        private int maxConnection = 20000;
        private int receiveIntervalMills = 0;
        private Proc2<Channel, Boolean> onChannelStateChanged;
        private Proc2<Channel, Throwable> onExceptionCaught;
        private Proc1<Channel> onServerBind;
        private Proc3<Message, ProtoBufHandler<Message>, Channel> dispatchMessage;

        public ProtoBufServerBuilder() {
            this.addressPair = new AddressPair(8888);
            this.dispatchMessage = (t1, t2, t3) -> t2.handle((Channel)t3, t1);
        }

        public ProtoBufServer build() throws Exception {
            return new ProtoBufServer(this);
        }

        public ProtoBufServerBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public ProtoBufServerBuilder addressPair(AddressPair addressPair) {
            this.addressPair = addressPair;
            return this;
        }

        public ProtoBufServerBuilder factory(ProtoBufFactory factory) {
            this.factory = factory;
            return this;
        }

        public ProtoBufServerBuilder whiteList(String ... remoteAddress) {
            for (String ip : remoteAddress) {
                if (!StringUtil.isIp4(ip)) continue;
                this.whiteList.add(ip);
            }
            return this;
        }

        public ProtoBufServerBuilder onChannelStateChanged(Proc2<Channel, Boolean> onChannelStateChanged) {
            this.onChannelStateChanged = onChannelStateChanged;
            return this;
        }

        public ProtoBufServerBuilder onExceptionCaught(Proc2<Channel, Throwable> onExceptionCaught) {
            this.onExceptionCaught = onExceptionCaught;
            return this;
        }

        public ProtoBufServerBuilder onServerBind(Proc1<Channel> onServerBind) {
            this.onServerBind = onServerBind;
            return this;
        }

        public ProtoBufServerBuilder dispatchMessage(Proc3<Message, ProtoBufHandler<Message>, Channel> dispatchMessage) {
            this.dispatchMessage = dispatchMessage;
            return this;
        }

        public ProtoBufServerBuilder maxConnection(int maxConnection) {
            this.maxConnection = maxConnection;
            return this;
        }

        public ProtoBufServerBuilder receiveIntervalMills(int receiveIntervalMills) {
            this.receiveIntervalMills = receiveIntervalMills;
            return this;
        }
    }
}

