/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.protobuf.message;

import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.net.binary.message.exception.MessageIDDuplicatedException;
import org.slingerxv.limitart.net.protobuf.handler.ProtoBufHandler;
import org.slingerxv.limitart.util.ReflectionUtil;

public class ProtoBufFactory {
    private static Logger log = LoggerFactory.getLogger(ProtoBufFactory.class);
    private final Map<Class<? extends Message>, ProtoBufHandler<? extends Message>> handlers = new HashMap<Class<? extends Message>, ProtoBufHandler<? extends Message>>();

    public static ProtoBufFactory createByPackage(String packageName) throws IOException, ReflectiveOperationException, MessageIDDuplicatedException {
        List<Class<?>> classesByPackage = ReflectionUtil.getClassesByPackage(packageName, ProtoBufHandler.class);
        ProtoBufFactory messageFactory = new ProtoBufFactory();
        for (Class<?> clzz : classesByPackage) {
            if (Modifier.isAbstract(clzz.getModifiers()) || clzz.isAnonymousClass() || clzz.isMemberClass() || clzz.isLocalClass()) {
                log.warn("inner class or anonymous class or abstract class will not be registerd:" + clzz.getName());
                continue;
            }
            messageFactory.registerHandler((ProtoBufHandler)clzz.newInstance());
        }
        return messageFactory;
    }

    public synchronized <T extends Message> ProtoBufFactory registerHandler(ProtoBufHandler<? extends Message> handler) throws InstantiationException, IllegalAccessException, MessageIDDuplicatedException {
        Type[] genericInterfaces = handler.getClass().getGenericInterfaces();
        ParameterizedType handlerInterface = null;
        for (Type temp : genericInterfaces) {
            ParameterizedType ttemp;
            if (!(temp instanceof ParameterizedType) || (ttemp = (ParameterizedType)temp).getRawType() != ProtoBufHandler.class) continue;
            handlerInterface = ttemp;
            break;
        }
        if (handlerInterface == null) {
            return this;
        }
        Class msgClass = (Class)handlerInterface.getActualTypeArguments()[0];
        if (this.handlers.containsKey(msgClass)) {
            throw new MessageIDDuplicatedException("class :" + msgClass.getName());
        }
        this.handlers.put(msgClass, handler);
        log.info("regist msg: {}\uff0chandler:{}", (Object)msgClass.getSimpleName(), (Object)handler.getClass().getSimpleName());
        return this;
    }

    public ProtoBufHandler<? extends Message> getHandler(Class<? extends Message> clazz) throws ReflectiveOperationException {
        return this.handlers.get(clazz);
    }

    public void copyToChannelPipeline(ChannelPipeline pipeline) {
        for (ProtoBufHandler<? extends Message> temp : this.handlers.values()) {
            pipeline.addLast(new ChannelHandler[]{new ProtobufDecoder((MessageLite)temp.getDefaultInstance())});
        }
    }
}

