/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.net.telnet;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Proc3;
import org.slingerxv.limitart.funcs.Proc4;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.net.AbstractNettyServer;
import org.slingerxv.limitart.net.IServer;
import org.slingerxv.limitart.net.telnet.CommandDuplicatedException;
import org.slingerxv.limitart.net.telnet.TelnetUser;
import org.slingerxv.limitart.net.telnet.TelnetUserDuplicatedException;
import org.slingerxv.limitart.util.Beta;
import org.slingerxv.limitart.util.SecurityUtil;
import org.slingerxv.limitart.util.StringUtil;

@Beta
public class TelnetServer
extends AbstractNettyServer
implements IServer {
    private static Logger log = LoggerFactory.getLogger(TelnetServer.class);
    private static AttributeKey<String> USERNAME_KEY = AttributeKey.newInstance((String)"USERNAME_KEY");
    private static AttributeKey<String> USERNAME_TEMP_KEY = AttributeKey.newInstance((String)"USERNAME_TEMP_KEY");
    private String serverName;
    private int port;
    private Set<String> whiteList;
    private Map<String, TelnetUser> users = new ConcurrentHashMap<String, TelnetUser>();
    private Map<String, Proc3<TelnetUser, String, String[]>> commands = new ConcurrentHashMap<String, Proc3<TelnetUser, String, String[]>>();
    private Proc2<Channel, Throwable> onExceptionCaught;
    private Proc1<Channel> onServerBind;
    private Proc1<TelnetUser> onUserLogin;
    private Proc1<TelnetUser> onUserLogout;
    private Proc4<TelnetUser, String, String[], Proc3<TelnetUser, String, String[]>> dispatchMessage;

    private TelnetServer(TelnetServerBuilder builder) {
        super(builder.serverName);
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.users = builder.users;
        this.commands = builder.commands;
        this.whiteList = builder.whiteList;
        this.onUserLogout = builder.onUserLogout;
        this.onExceptionCaught = builder.onExceptionCaught;
        this.onServerBind = builder.onServerBind;
        this.onUserLogin = builder.onUserLogin;
        this.dispatchMessage = builder.dispatchMessage;
    }

    @Override
    public void startServer() {
        this.bind(this.port, this.onServerBind);
    }

    @Override
    public void stopServer() {
        this.unbind();
    }

    @Override
    protected void initPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new LineBasedFrameDecoder(256)}).addLast(new ChannelHandler[]{new StringDecoder(CharsetUtil.UTF_8)}).addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
    }

    @Override
    protected void exceptionCaught0(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Procs.invoke(this.onExceptionCaught, ctx.channel(), cause);
    }

    @Override
    protected void channelActive0(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress insocket;
        String remoteAddress;
        if (this.whiteList != null && !this.whiteList.isEmpty() && !this.whiteList.contains(remoteAddress = (insocket = (InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress())) {
            ctx.channel().close();
            log.info("ip: " + remoteAddress + " rejected link!");
            return;
        }
        this.sendMessage(ctx.channel(), "====Welcome To " + this.serverName + " !====");
        this.sendMessage(ctx.channel(), "username:");
    }

    @Override
    protected void channelInactive0(ChannelHandlerContext ctx) throws Exception {
        TelnetUser consoleUser = this.getConsoleUser(ctx.channel());
        if (consoleUser != null) {
            consoleUser.setChannel(null);
            Procs.invoke(this.onUserLogout, consoleUser);
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        String command = (String)msg;
        if (StringUtil.isEmptyOrNull(command)) {
            return;
        }
        Channel ch = ctx.channel();
        TelnetUser consoleUser = this.getConsoleUser(ch);
        if (consoleUser == null) {
            String tempUsername = (String)ch.attr(USERNAME_TEMP_KEY).get();
            if (tempUsername == null) {
                TelnetUser temp = this.users.get(command);
                if (temp == null) {
                    this.sendMessage(ch, "username not exist!");
                    return;
                }
                ch.attr(USERNAME_TEMP_KEY).set((Object)command);
                log.info("remote:" + ch.remoteAddress() + " ready to login on:" + command);
                this.sendMessage(ch, "password:");
            } else {
                TelnetUser temp = this.users.get(tempUsername);
                try {
                    if (!SecurityUtil.isPasswordValid(temp.getPass(), command, temp.getUsername())) {
                        this.sendMessage(ch, "password error!");
                        return;
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                Channel oldChannel = temp.getChannel();
                if (oldChannel != null) {
                    this.sendMessage(oldChannel, "another client login from:" + ch.remoteAddress(), (t1, t2, t3) -> oldChannel.close());
                }
                temp.setChannel(ch);
                ch.attr(USERNAME_KEY).set((Object)temp.getUsername());
                log.info("remote:" + ch.remoteAddress() + " login on:" + (String)ch.attr(USERNAME_KEY).get() + " success!");
                this.sendMessage(ctx.channel(), "====Login " + this.serverName + " Success!====");
                Procs.invoke(this.onUserLogin, temp);
            }
        } else {
            Proc3<TelnetUser, String, String[]> handler;
            String[] split = command.split(" ");
            String[] params = new String[]{};
            String cmd = split[0];
            if (split.length > 1) {
                params = new String[split.length - 1];
                System.arraycopy(split, 1, params, 0, params.length);
            }
            if ((handler = this.commands.get(cmd)) == null) {
                this.sendMessage(ch, "'" + cmd + "'is not a command!");
                return;
            }
            log.info("remote:" + ch.remoteAddress() + " login on:" + (String)ch.attr(USERNAME_KEY).get() + " execute cmd:" + cmd);
            Procs.invoke(this.dispatchMessage, consoleUser, cmd, params, handler);
        }
    }

    public void sendMessage(Channel channel, String msg) {
        this.sendMessage(channel, msg, null);
    }

    public void sendMessage(Channel channel, String msg, Proc3<Boolean, Throwable, Channel> listener) {
        String info = "->" + msg + "\r\n";
        channel.writeAndFlush((Object)info).addListener((GenericFutureListener)((ChannelFutureListener)arg0 -> Procs.invoke(listener, arg0.isSuccess(), arg0.cause(), arg0.channel())));
    }

    private TelnetUser getConsoleUser(Channel channel) {
        Attribute attr = channel.attr(USERNAME_KEY);
        if (attr == null) {
            return null;
        }
        String username = (String)attr.get();
        if (username == null) {
            return null;
        }
        return this.users.get(username);
    }

    public static class TelnetServerBuilder {
        private String serverName = "Console-Server";
        private int port = 7023;
        private Set<String> whiteList = new HashSet<String>();
        private Map<String, TelnetUser> users = new ConcurrentHashMap<String, TelnetUser>();
        private Map<String, Proc3<TelnetUser, String, String[]>> commands = new ConcurrentHashMap<String, Proc3<TelnetUser, String, String[]>>();
        private Proc2<Channel, Throwable> onExceptionCaught;
        private Proc1<Channel> onServerBind;
        private Proc1<TelnetUser> onUserLogin;
        private Proc1<TelnetUser> onUserLogout;
        private Proc4<TelnetUser, String, String[], Proc3<TelnetUser, String, String[]>> dispatchMessage = new Proc4<TelnetUser, String, String[], Proc3<TelnetUser, String, String[]>>(){

            @Override
            public void run(TelnetUser t1, String t2, String[] t3, Proc3<TelnetUser, String, String[]> t4) {
                t4.run(t1, t2, t3);
            }
        };

        public TelnetServer build() {
            return new TelnetServer(this);
        }

        public TelnetServerBuilder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public TelnetServerBuilder port(int port) {
            this.port = port;
            return this;
        }

        public TelnetServerBuilder whiteList(String ... remoteAddress) {
            for (String ip : remoteAddress) {
                if (!StringUtil.isIp4(ip)) continue;
                this.whiteList.add(ip);
            }
            return this;
        }

        public TelnetServerBuilder user(TelnetUser ... users) throws NoSuchAlgorithmException, TelnetUserDuplicatedException {
            for (TelnetUser temp : users) {
                TelnetUser newUser = new TelnetUser();
                newUser.setUsername(Objects.requireNonNull(temp.getUsername(), "username"));
                newUser.setPass(SecurityUtil.encodePassword(Objects.requireNonNull(temp.getPass(), "pass"), temp.getUsername()));
                if (this.users.containsKey(newUser.getUsername())) {
                    throw new TelnetUserDuplicatedException(newUser.getUsername());
                }
                this.users.put(newUser.getUsername(), newUser);
            }
            return this;
        }

        public TelnetServerBuilder cmd(String cmd, Proc3<TelnetUser, String, String[]> handler) throws CommandDuplicatedException {
            if (this.commands.containsKey(cmd)) {
                throw new CommandDuplicatedException(cmd);
            }
            this.commands.put(cmd, handler);
            return this;
        }

        public TelnetServerBuilder onExceptionCaught(Proc2<Channel, Throwable> onExceptionCaught) {
            this.onExceptionCaught = onExceptionCaught;
            return this;
        }

        public TelnetServerBuilder onServerBind(Proc1<Channel> onServerBind) {
            this.onServerBind = onServerBind;
            return this;
        }

        public TelnetServerBuilder dispatchMessage(Proc4<TelnetUser, String, String[], Proc3<TelnetUser, String, String[]>> dispatchMessage) {
            this.dispatchMessage = dispatchMessage;
            return this;
        }

        public TelnetServerBuilder onUserLogin(Proc1<TelnetUser> onUserLogin) {
            this.onUserLogin = onUserLogin;
            return this;
        }

        public TelnetServerBuilder onUserLogout(Proc1<TelnetUser> onUserLogout) {
            this.onUserLogout = onUserLogout;
            return this;
        }
    }
}

