/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.rpcx.center.schedule;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.rpcx.center.struct.ServiceXServerSession;
import org.slingerxv.limitart.rpcx.message.schedule.TriggerScheduleServiceCenterToProviderServiceCenterMessage;
import org.slingerxv.limitart.util.RandomUtil;
import org.slingerxv.limitart.util.TimeUtil;

public class ScheduleTask
implements Job {
    private static Logger log = LoggerFactory.getLogger(ScheduleTask.class);
    public static String RPCSERVERS = "RPCSERVERS";
    public static String SCHEDULES = "SCHEDULES";

    public void execute(JobExecutionContext job) throws JobExecutionException {
        ArrayList arrayList;
        int providerId;
        ServiceXServerSession serviceXServerSession;
        TriggerScheduleServiceCenterToProviderServiceCenterMessage msg = new TriggerScheduleServiceCenterToProviderServiceCenterMessage();
        String jobName = job.getJobDetail().getKey().getName();
        JobDataMap jobDataMap = job.getJobDetail().getJobDataMap();
        Map rpcServers = (Map)jobDataMap.get((Object)RPCSERVERS);
        Map schedules = (Map)jobDataMap.get((Object)SCHEDULES);
        Set providerList = (Set)schedules.get(jobName);
        if (providerList == null) {
            log.error("Job:" + jobName + "\u627e\u4e0d\u5230Provider");
            return;
        }
        msg.setJobName(jobName);
        if (!job.getTrigger().mayFireAgain()) {
            msg.setEnd(true);
            schedules.remove(jobName);
            log.info("\u4efb\u52a1\u751f\u547d\u7ec8\u7ed3\uff0c\u6267\u884c\u5220\u9664\uff1a" + jobName);
        }
        if ((serviceXServerSession = (ServiceXServerSession)rpcServers.get(providerId = ((Integer)(arrayList = new ArrayList(providerList)).get(RandomUtil.randomInt(0, arrayList.size() - 1))).intValue())) != null) {
            serviceXServerSession.getSession().writeAndFlush((Object)msg);
            log.info(jobName + "\u89e6\u53d1\uff01\u5206\u914d\u7684ProviderId\u4e3a\uff1a" + providerId + "\uff0c\u4e0b\u6b21\u89e6\u53d1\u65f6\u95f4\uff1a" + TimeUtil.date2Str(job.getTrigger().getNextFireTime().getTime()));
        }
    }
}

