/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.rpcx.consumerx;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.collections.ConcurrentHashSet;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.binary.BinaryClient;
import org.slingerxv.limitart.net.binary.handler.IHandler;
import org.slingerxv.limitart.net.binary.message.MessageFactory;
import org.slingerxv.limitart.rpcx.consumerx.config.ConsumerXConfig;
import org.slingerxv.limitart.rpcx.consumerx.define.IServiceAsyncCallback;
import org.slingerxv.limitart.rpcx.consumerx.listener.IConsumerListener;
import org.slingerxv.limitart.rpcx.consumerx.selector.define.IProviderSelector;
import org.slingerxv.limitart.rpcx.consumerx.struct.ProviderRemote;
import org.slingerxv.limitart.rpcx.consumerx.struct.RemoteFuture;
import org.slingerxv.limitart.rpcx.define.ServiceX;
import org.slingerxv.limitart.rpcx.exception.ServiceXExecuteException;
import org.slingerxv.limitart.rpcx.exception.ServiceXIOException;
import org.slingerxv.limitart.rpcx.exception.ServiceXProxyException;
import org.slingerxv.limitart.rpcx.message.service.DirectFetchProviderServicesMessage;
import org.slingerxv.limitart.rpcx.message.service.DirectFetchProviderServicesResultMessage;
import org.slingerxv.limitart.rpcx.message.service.NoticeProviderDisconnectedServiceCenterMessage;
import org.slingerxv.limitart.rpcx.message.service.RpcExecuteClientMessage;
import org.slingerxv.limitart.rpcx.message.service.RpcResultServerMessage;
import org.slingerxv.limitart.rpcx.message.service.SubscribeServiceFromServiceCenterConsumerMessage;
import org.slingerxv.limitart.rpcx.message.service.SubscribeServiceResultServiceCenterMessage;
import org.slingerxv.limitart.rpcx.message.service.meta.ProviderHostMeta;
import org.slingerxv.limitart.rpcx.message.service.meta.ProviderServiceMeta;
import org.slingerxv.limitart.rpcx.struct.RpcProviderName;
import org.slingerxv.limitart.rpcx.util.RpcUtil;
import org.slingerxv.limitart.util.ReflectionUtil;
import org.slingerxv.limitart.util.StringUtil;

public class ConsumerX {
    private static Logger log = LoggerFactory.getLogger(ConsumerX.class);
    private Map<Integer, BinaryClient> clients = new ConcurrentHashMap<Integer, BinaryClient>();
    private BinaryClient serviceCenterClient;
    private ConsumerXConfig config;
    private Map<Class<?>, Object> clientProxys = new HashMap();
    private Map<String, Class<?>> serviceProxyClasses = new HashMap();
    private Map<String, Set<Integer>> serviceServers = new ConcurrentHashMap<String, Set<Integer>>();
    private AtomicInteger requestIdCreater = new AtomicInteger(0);
    private Map<Integer, RemoteFuture> futures = new ConcurrentHashMap<Integer, RemoteFuture>();
    private LongAdder dropNum = new LongAdder();
    private IConsumerListener listener;
    private boolean isDirectLink = false;

    public ConsumerX(ConsumerXConfig config) {
        this(config, null);
    }

    public ConsumerX(ConsumerXConfig config, IConsumerListener listener) {
        if (config == null) {
            throw new NullPointerException("ConsumerXConfig");
        }
        this.listener = listener;
        this.config = config;
    }

    public void init() throws Exception {
        this.initRpcProxys();
        ProviderRemote[] providerRemotes = this.config.getProviderRemotes();
        if (providerRemotes != null) {
            this.isDirectLink = true;
            for (ProviderRemote remote : providerRemotes) {
                this.createRpcClient(remote.getProviderIp(), remote.getProviderPort()).connect();
            }
        } else {
            String serviceCenterIp = this.config.getServiceCenterIp();
            if (StringUtil.isEmptyOrNull(serviceCenterIp)) {
                throw new ServiceXIOException("need service center's Ip or direct provider remote Ip!");
            }
            MessageFactory centryFactory = new MessageFactory();
            centryFactory.registerMsg(new SubscribeServiceResultServiceCenterHandler());
            centryFactory.registerMsg(new NoticeProviderDisconnectedServiceCenterHandler());
            this.serviceCenterClient = new BinaryClient.BinaryClientBuilder().autoReconnect(this.config.getAutoConnectInterval()).remoteAddress(new AddressPair(this.config.getServiceCenterIp(), this.config.getServiceCenterPort(), null)).clientName("RPC-Consumer").factory(centryFactory).onConnectionEffective(client -> {
                if (this.listener != null) {
                    this.listener.onServiceCenterConnected(this);
                }
                this.subscribeServicesFromServiceCenter();
            }).dispatchMessage((message, handler) -> {
                message.setExtra(this);
                try {
                    handler.handle(message);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }).build();
            this.serviceCenterClient.connect();
        }
    }

    private BinaryClient createRpcClient(String providerIp, int providerPort) throws Exception {
        MessageFactory rpcMessageFacotry = new MessageFactory();
        rpcMessageFacotry.registerMsg(new RpcResultServerHandler());
        rpcMessageFacotry.registerMsg(new DirectFetchProviderServicesResultHandler());
        BinaryClient client = new BinaryClient.BinaryClientBuilder().remoteAddress(new AddressPair(providerIp, providerPort)).autoReconnect(this.config.getAutoConnectInterval()).factory(rpcMessageFacotry).onChannelStateChanged((binaryClient, active) -> {
            if (!active.booleanValue()) {
                this.clearOnDisconnected((BinaryClient)binaryClient);
            }
        }).onConnectionEffective(binaryClient -> {
            if (this.isDirectLink) {
                this.directFetchProverServices((BinaryClient)binaryClient);
            }
            if (this.listener != null) {
                this.listener.onConsumerConnected((BinaryClient)binaryClient);
            }
        }).dispatchMessage((message, handler) -> {
            message.setExtra(this);
            try {
                handler.handle(message);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }).build();
        return client;
    }

    private void directFetchProverServices(BinaryClient client) {
        try {
            client.sendMessage(new DirectFetchProviderServicesMessage(), null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void onDirectFetchProviderServices(BinaryClient bc, int providerId, List<String> services) {
        HashSet<String> notMatchList = new HashSet<String>(this.serviceProxyClasses.keySet());
        for (String remoteService : services) {
            BinaryClient putIfAbsent;
            Set<Integer> putIfAbsent2;
            if (!this.serviceProxyClasses.containsKey(remoteService)) continue;
            notMatchList.remove(remoteService);
            Set<Integer> list = this.serviceServers.get(remoteService);
            if (list == null && (putIfAbsent2 = this.serviceServers.putIfAbsent(remoteService, list = new ConcurrentHashSet<Integer>())) != null) {
                list = putIfAbsent2;
            }
            list.add(providerId);
            BinaryClient tc = this.clients.get(providerId);
            if (tc != null || (putIfAbsent = this.clients.putIfAbsent(providerId, bc)) == null) continue;
            tc = putIfAbsent;
        }
        if (!notMatchList.isEmpty()) {
            log.error("\u672c\u5730\u670d\u52a1\u5c1a\u6709\uff1a" + notMatchList.size() + "\u6761\u6ca1\u6709\u5339\u914d\u8fdc\u7a0b\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5\uff01");
            for (String notMatch : notMatchList) {
                log.info("\u672a\u5339\u914d\u7684\u670d\u52a1\uff1a" + notMatch);
            }
        }
    }

    private void subscribeServicesFromServiceCenter() {
        try {
            this.serviceCenterClient.sendMessage(new SubscribeServiceFromServiceCenterConsumerMessage(), null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void onSubsribeServicesCome(List<ProviderServiceMeta> services) {
        log.info("\u63a5\u6536\u5230\u670d\u52a1\u4e2d\u5fc3\u63a8\u9001\u8fc7\u6765\u7684\u670d\u52a1\uff0c\u5f00\u59cb\u7b5b\u9009\u548c\u5904\u7406...");
        for (ProviderServiceMeta info : services) {
            Set<Integer> putIfAbsent;
            String serviceName = info.serviceName;
            ArrayList<ProviderHostMeta> hostInfos = info.hostInfos;
            if (!this.serviceProxyClasses.containsKey(serviceName)) continue;
            Set<Integer> list = this.serviceServers.get(serviceName);
            if (list == null && (putIfAbsent = this.serviceServers.putIfAbsent(serviceName, list = new ConcurrentHashSet<Integer>())) != null) {
                list = putIfAbsent;
            }
            for (ProviderHostMeta temp : hostInfos) {
                int providerId = temp.getProviderId();
                list.add(providerId);
                log.info("\u5f00\u59cb\u8ba2\u9605RPC" + providerId + "\u670d\u52a1\u5668[" + temp.getIp() + ":" + temp.getPort() + "]\u7684\u670d\u52a1\uff1a" + serviceName);
                BinaryClient binaryClient = this.clients.get(providerId);
                if (binaryClient != null) continue;
                try {
                    binaryClient = this.createRpcClient(temp.getIp(), temp.getPort());
                    BinaryClient putIfAbsent2 = this.clients.putIfAbsent(providerId, binaryClient);
                    if (putIfAbsent2 != null) continue;
                    binaryClient.connect();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        log.info("\u7b5b\u9009\u548c\u5904\u7406\u670d\u52a1\u4e2d\u5fc3\u63a8\u9001\u8fc7\u6765\u7684\u670d\u52a1\u5b8c\u6bd5\u3002");
    }

    private void clearOnDisconnected(BinaryClient client) {
        Iterator<Map.Entry<Integer, BinaryClient>> iterator = this.clients.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BinaryClient> next = iterator.next();
            int providerId = next.getKey();
            BinaryClient otherClient = next.getValue();
            if (!client.channel().id().asLongText().equals(otherClient.channel().id().asLongText())) continue;
            iterator.remove();
            log.info("RPC\u670d\u52a1\u5668\u65ad\u5f00\u94fe\u63a5\uff0cproviderId:" + providerId + "\uff0c\u5730\u5740\uff1a" + client.remoteAddress());
            for (Map.Entry<String, Set<Integer>> entry : this.serviceServers.entrySet()) {
                String serviceName = entry.getKey();
                Set<Integer> provideIds = entry.getValue();
                Iterator<Integer> pit = provideIds.iterator();
                while (pit.hasNext()) {
                    Integer nextProviderId = pit.next();
                    if (nextProviderId != providerId) continue;
                    pit.remove();
                    log.info("\u5220\u9664\u63d0\u4f9b\u8005\uff1a" + nextProviderId + "\u63d0\u4f9b\u7684\u670d\u52a1\uff1a" + serviceName);
                }
            }
        }
    }

    private void onNoticeProviderDisconnected(int providerUID) {
        BinaryClient binaryClient = this.clients.get(providerUID);
        if (binaryClient != null) {
            binaryClient.disConnect();
        }
    }

    public <T> T createProxy(Class<T> interfaceClss) throws ServiceXProxyException {
        Object proxyObject = this.clientProxys.get(interfaceClss);
        if (proxyObject == null) {
            throw new ServiceXProxyException(interfaceClss.getName() + "\u4e0d\u662f\u4e00\u4e2aRPC\u670d\u52a1\uff01");
        }
        return (T)proxyObject;
    }

    public Object remoteCall(RpcProviderName providerName, Class<?> serviceClass, Method method, Object[] args, IProviderSelector providerSelector, IServiceAsyncCallback callback) throws ServiceXExecuteException, ServiceXIOException, InterruptedException, ServiceXProxyException {
        return this.proxyExecute(RpcUtil.getServiceName(providerName, serviceClass), null, method.getName(), ReflectionUtil.getMethodOverloadName(method), args, providerSelector, callback);
    }

    public List<Integer> getProviderIds() {
        return new ArrayList<Integer>(this.clients.keySet());
    }

    public List<Integer> getProviderIds(RpcProviderName providerName, Class<?> clazz) throws ServiceXProxyException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Integer> set = this.serviceServers.get(RpcUtil.getServiceName(providerName, clazz));
        if (set != null) {
            list.addAll(set);
        }
        return list;
    }

    private void initRpcProxys() throws ServiceXProxyException, IOException, ReflectiveOperationException {
        this.clientProxys.clear();
        ArrayList classesByPackage = new ArrayList();
        for (String temp : this.config.getServicePackages()) {
            classesByPackage.addAll(ReflectionUtil.getClassesByPackage(temp, Object.class));
        }
        for (Class clazz : classesByPackage) {
            Method[] methods;
            ServiceX annotation = clazz.getAnnotation(ServiceX.class);
            if (annotation == null) continue;
            if (!clazz.isInterface()) {
                throw new ServiceXProxyException(clazz.getName() + "RPC\u670d\u52a1\u5668\u5fc5\u987b\u662f\u4e00\u4e2a\u63a5\u53e3\uff01");
            }
            String provider = annotation.provider();
            if (StringUtil.isEmptyOrNull(provider)) {
                throw new ServiceXProxyException("\u670d\u52a1\uff1a" + clazz.getName() + "\u7684\u63d0\u4f9b\u5546\u4e3a\u7a7a\uff01");
            }
            String serviceName = RpcUtil.getServiceName(new RpcProviderName(provider), clazz);
            for (Method method2 : methods = clazz.getMethods()) {
                Class<?>[] parameterTypes;
                String methodOverloadName = ReflectionUtil.getMethodOverloadName(method2);
                for (Class<?> paramsType : parameterTypes = method2.getParameterTypes()) {
                    RpcUtil.checkParamType(paramsType);
                }
                RpcUtil.checkParamType(method2.getReturnType());
                Class<?>[] exceptionTypes = method2.getExceptionTypes();
                if (exceptionTypes == null || exceptionTypes.length < 1) {
                    throw new ServiceXProxyException("\u7c7b" + clazz.getName() + "\u7684\u65b9\u6cd5" + methodOverloadName + "\u5fc5\u987b\u8981\u629b\u51fa\u5f02\u5e38\uff1a" + Exception.class.getName());
                }
                boolean exOk = false;
                for (Class<?> ex : exceptionTypes) {
                    if (ex != Exception.class) continue;
                    exOk = true;
                }
                if (exOk) continue;
                throw new ServiceXProxyException("\u7c7b" + clazz.getName() + "\u7684\u65b9\u6cd5" + methodOverloadName + "\u7684\u5f02\u5e38\u629b\u51fa\u5fc5\u987b\u6709\uff1a" + Exception.class.getName());
            }
            Object newProxyInstance = ReflectionUtil.newProxy(clazz, (proxy, method, args) -> this.proxyExecute(serviceName, proxy, method.getName(), ReflectionUtil.getMethodOverloadName(method), args, this.config.getSelector(), null));
            if (this.serviceProxyClasses.containsKey(serviceName)) {
                throw new ServiceXProxyException("\u670d\u52a1\u540d\u91cd\u590d:" + serviceName);
            }
            this.serviceProxyClasses.put(serviceName, clazz);
            this.clientProxys.put(clazz, newProxyInstance);
            log.info("\u521b\u5efa\u670d\u52a1\u52a8\u6001\u4ee3\u7406\uff1a" + serviceName + "\uff0c\u670d\u52a1\u63d0\u4f9b\u5546\uff1a" + provider + "\uff0c\u4ee3\u7406\u5b9e\u4f8b\uff1a" + newProxyInstance);
        }
    }

    private Object proxyExecute(String serviceName, Object proxy, String methodName, String methodOverloadName, Object[] args, IProviderSelector providerSelector, IServiceAsyncCallback callback) throws ServiceXExecuteException, InterruptedException, ServiceXIOException {
        RpcResultServerMessage response;
        int errorCode;
        if (proxy != null) {
            if ("equals".equals(methodName)) {
                return proxy == args[0];
            }
            if ("hashCode".equals(methodName)) {
                return System.identityHashCode(proxy);
            }
            if ("toString".equals(methodName)) {
                return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
            }
        }
        if (this.futures.size() > this.config.getRpcCallBackMaxLength()) {
            this.dropNum.increment();
            throw new ServiceXExecuteException("\u56de\u8c03\u5217\u8868\u8d85\u8fc7\u9650\u5236\uff1a" + this.config.getRpcCallBackMaxLength() + ",\u4e0d\u8fdb\u884c\u4efb\u4f55\u5904\u7406\uff01,\u5df2\u629b\u5f03\u6570\u91cf\uff1a" + this.dropNum.longValue());
        }
        RemoteFuture future = this.rpcSend(serviceName, methodOverloadName, args, providerSelector);
        future.setCallback(callback);
        int providerId = future.getProviderId();
        if (future.getResponseResult() == null) {
            boolean await = future.getCountDownLatch().await(this.config.getRpcExecuteTimeoutInMills(), TimeUnit.MILLISECONDS);
            this.futures.remove(future.getRequestId());
            if (!await) {
                throw new ServiceXExecuteException("\u52a8\u6001\u4ee3\u7406\u65b9\u6cd5\uff1a" + methodOverloadName + "\uff0c\u670d\u52a1\u5668\uff1a" + providerId + "\u8d85\u65f6\uff0c\u56de\u8c03ID\uff1a" + future.getRequestId());
            }
        }
        if ((errorCode = (response = future.getResponseResult()).getErrorCode()) == 0) {
            return response.getReturnVal();
        }
        if (errorCode == 1) {
            throw new ServiceXExecuteException("\u670d\u52a1\u5668\uff1a" + providerId + "\u6ca1\u6709\u670d\u52a1\u540d\u4e3a\uff1a" + serviceName);
        }
        if (errorCode == 2) {
            throw new ServiceXExecuteException("\u670d\u52a1\u5668\uff1a" + providerId + "\u6ca1\u6709\u670d\u52a1\u540d\u4e3a\uff1a" + serviceName + "\u7684" + methodOverloadName + "\u65b9\u6cd5\uff01");
        }
        throw new ServiceXExecuteException("\u670d\u52a1\u5668\uff1a" + providerId + "\u670d\u52a1\u540d\uff1a" + serviceName + "\u8fd4\u56de\u672a\u77e5\u9519\u8bef\u7801\uff01");
    }

    private RemoteFuture rpcSend(String serviceName, String methodOverloadName, Object[] args, IProviderSelector providerSelector) throws ServiceXIOException {
        Set<Integer> list = this.serviceServers.get(serviceName);
        if (list == null) {
            throw new ServiceXIOException("\u670d\u52a1\uff1a" + serviceName + "\u627e\u4e0d\u5230\u53ef\u7528\u670d\u52a1\u5668\u5217\u8868");
        }
        Integer selectServer = providerSelector.selectServer(serviceName, methodOverloadName, args, new ArrayList<Integer>(list));
        if (selectServer == null) {
            throw new ServiceXIOException(serviceName + "\u627e\u4e0d\u5230\u53ef\u7528\u670d\u52a1\u5668\uff0c\u53ef\u80fd\u662f\u670d\u52a1\u5668\u9009\u62e9\u5668\u51fa\u9519\uff0c\u65b9\u6cd5\uff1a" + methodOverloadName);
        }
        BinaryClient binaryClient = this.clients.get(selectServer);
        if (binaryClient == null) {
            throw new ServiceXIOException("\u4e25\u91cd\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u670d\u52a1\u63d0\u4f9b\u8005\uff1a" + selectServer + "\u7684\u94fe\u63a5\u5b9e\u4f8b\uff01");
        }
        RpcExecuteClientMessage msg = new RpcExecuteClientMessage();
        msg.requestId = this.requestIdCreater.incrementAndGet();
        msg.moduleName = serviceName;
        msg.methodName = methodOverloadName;
        if (args != null && args.length > 0) {
            for (Object obj : args) {
                if (obj == null) {
                    msg.paramTypes.add(null);
                    msg.params.add(null);
                    continue;
                }
                msg.paramTypes.add(obj.getClass().getName());
                msg.params.add(obj);
            }
        }
        RemoteFuture future = new RemoteFuture();
        future.setProviderId(selectServer);
        future.setRequestId(msg.requestId);
        this.futures.put(msg.requestId, future);
        if (this.futures.size() > 100) {
            log.error("\u8b66\u544a\uff01\u5f00\u59cb\u52a8\u6001\u4ee3\u7406\u65b9\u6cd5\uff1a" + methodOverloadName + "\uff0c\u670d\u52a1\u5668\uff1a" + selectServer + "\uff0c\u56de\u8c03\u5217\u8868\u957f\u5ea6\uff1a" + this.futures.size() + "(\u5e76\u53d1\u91cf)\uff0cid\uff1a" + msg.requestId);
        }
        try {
            binaryClient.sendMessage(msg, (isSuccess, cause, channel) -> {
                if (!isSuccess.booleanValue()) {
                    this.futures.remove(rpcExecuteClientMessage.requestId);
                    log.error("\u52a8\u6001\u4ee3\u7406\u65b9\u6cd5\uff1a" + methodOverloadName + "\uff0c\u670d\u52a1\u5668\uff1a" + selectServer + "\u5931\u8d25\uff01\u7f51\u7edc\u672a\u8fde\u63a5\uff01" + "\uff0cid\uff1a" + rpcExecuteClientMessage.requestId);
                }
            });
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return future;
    }

    private void onRPCResonse(RpcResultServerMessage msg) {
        int requestId = msg.getRequestId();
        RemoteFuture rpcFuture = this.futures.get(requestId);
        if (rpcFuture == null) {
            log.error("requestId:" + requestId + "\u627e\u4e0d\u5230\u56de\u8c03\uff01");
            return;
        }
        rpcFuture.setResponseResult(msg);
        if (rpcFuture.getCallback() == null) {
            rpcFuture.getCountDownLatch().countDown();
        } else {
            this.futures.remove(requestId);
            int errorCode = msg.getErrorCode();
            if (errorCode == 0) {
                rpcFuture.getCallback().action(msg.getReturnVal());
            }
        }
    }

    public class NoticeProviderDisconnectedServiceCenterHandler
    implements IHandler<NoticeProviderDisconnectedServiceCenterMessage> {
        @Override
        public void handle(NoticeProviderDisconnectedServiceCenterMessage msg) {
            ((ConsumerX)msg.getExtra()).onNoticeProviderDisconnected(msg.getProviderUID());
        }
    }

    public class SubscribeServiceResultServiceCenterHandler
    implements IHandler<SubscribeServiceResultServiceCenterMessage> {
        @Override
        public void handle(SubscribeServiceResultServiceCenterMessage msg) {
            ArrayList<ProviderServiceMeta> services = msg.services;
            ((ConsumerX)msg.getExtra()).onSubsribeServicesCome(services);
        }
    }

    public class DirectFetchProviderServicesResultHandler
    implements IHandler<DirectFetchProviderServicesResultMessage> {
        @Override
        public void handle(DirectFetchProviderServicesResultMessage msg) {
            int providerId = msg.providerId;
            ArrayList<String> services = msg.services;
            ((ConsumerX)msg.getExtra()).onDirectFetchProviderServices(msg.getClient(), providerId, services);
        }
    }

    public class RpcResultServerHandler
    implements IHandler<RpcResultServerMessage> {
        @Override
        public void handle(RpcResultServerMessage msg) {
            ((ConsumerX)msg.getExtra()).onRPCResonse(msg);
        }
    }
}

