/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.rpcx.message.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.MessageMeta;

public abstract class RPCMeta
extends Message {
    protected final Object decodeObj(Class<?> type) throws Exception {
        return this.decodeObj(type.getName());
    }

    protected final Object decodeObj(String type) throws Exception {
        if (type == null || type.equals("null")) {
            return null;
        }
        if (type.equals(Integer.class.getName()) || type.equals(Integer.TYPE.getName())) {
            return this.getInt();
        }
        if (type.equals(int[].class.getName())) {
            return this.getIntArray();
        }
        if (type.equals(Byte.class.getName()) || type.equals(Byte.TYPE.getName())) {
            return this.getByte();
        }
        if (type.equals(byte[].class.getName())) {
            return this.getByteArray();
        }
        if (type.equals(Short.class.getName()) || type.equals(Short.TYPE.getName())) {
            return this.getShort();
        }
        if (type.equals(short[].class.getName())) {
            return this.getShortArray();
        }
        if (type.equals(Long.class.getName()) || type.equals(Long.TYPE.getName())) {
            return this.getLong();
        }
        if (type.equals(long[].class.getName())) {
            return this.getLongArray();
        }
        if (type.equals(Boolean.class.getName()) || type.equals(Boolean.TYPE.getName())) {
            return this.getBoolean();
        }
        if (type.equals(boolean[].class.getName())) {
            return this.getBooleanArray();
        }
        if (type.equals(String.class.getName())) {
            return this.getString();
        }
        if (type.equals(String[].class.getName())) {
            return this.getStringArray();
        }
        if (type.equals(Float.class.getName()) || type.equals(Float.TYPE.getName())) {
            return Float.valueOf(this.getFloat());
        }
        if (type.equals(float[].class.getName())) {
            return this.getFloatArray();
        }
        if (type.equals(Double.class.getName()) || type.equals(Double.TYPE.getName())) {
            return this.getDouble();
        }
        if (type.equals(double[].class.getName())) {
            return this.getDoubleArray();
        }
        if (type.equals(Character.class.getName()) || type.equals(Character.TYPE.getName())) {
            return Character.valueOf(this.getChar());
        }
        if (type.equals(char[].class.getName())) {
            return this.getCharArray();
        }
        if (type.equals(ArrayList.class.getName()) || type.equals(List.class.getName())) {
            ArrayList<Object> objList = new ArrayList<Object>();
            int length = this.getShort();
            if (length > 0) {
                String listType = this.getString();
                for (int i = 0; i < length; ++i) {
                    objList.add(this.decodeObj(listType));
                }
            }
            return objList;
        }
        if (type.equals(HashMap.class.getName()) || type.equals(Map.class.getName())) {
            int length = this.getShort();
            if (length == 0) {
                return null;
            }
            String keyType = this.getString();
            String valueType = this.getString();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < length; ++i) {
                map.put(this.decodeObj(keyType), this.decodeObj(valueType));
            }
            return map;
        }
        if (type.equals(HashSet.class.getName()) || type.equals(Set.class.getName())) {
            int length = this.getShort();
            if (length == 0) {
                return null;
            }
            String setType = this.getString();
            HashSet<Object> set = new HashSet<Object>();
            for (int i = 0; i < length; ++i) {
                set.add(this.decodeObj(setType));
            }
            return set;
        }
        if (type.startsWith("[L")) {
            Class<?> forName = Class.forName(type);
            return this.getMessageMetaArray(forName.getComponentType());
        }
        Class<?> forName = Class.forName(type);
        return this.getMessageMeta(forName);
    }

    protected final void encodeObj(Object object) throws Exception {
        if (object == null) {
            return;
        }
        Class<?> type = object.getClass();
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            this.putInt((Integer)object);
        } else if (type.equals(int[].class)) {
            this.putIntArray((int[])object);
        } else if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            this.putByte((Integer)object);
        } else if (type.equals(byte[].class)) {
            this.putByteArray((byte[])object);
        } else if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            this.putShort(((Short)object).shortValue());
        } else if (type.equals(short[].class)) {
            this.putShortArray((short[])object);
        } else if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            this.putLong((Long)object);
        } else if (type.equals(long[].class)) {
            this.putLongArray((long[])object);
        } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            this.putBoolean((Boolean)object);
        } else if (type.equals(boolean[].class)) {
            this.putBooleanArray((boolean[])object);
        } else if (type.equals(String.class)) {
            this.putString((String)object);
        } else if (type.equals(String[].class)) {
            this.putStringArray((String[])object);
        } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            this.putFloat(((Float)object).floatValue());
        } else if (type.equals(float[].class)) {
            this.putFloatArray((float[])object);
        } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            this.putDouble((Double)object);
        } else if (type.equals(double[].class)) {
            this.putDoubleArray((double[])object);
        } else if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            this.putChar(((Character)object).charValue());
        } else if (type.equals(char[].class)) {
            this.putCharArray((char[])object);
        } else if (type.equals(ArrayList.class) || type.equals(List.class)) {
            List objs = (List)object;
            if (objs.isEmpty()) {
                this.putShort(0);
            } else {
                this.putShort((short)objs.size());
                String name = objs.get(0).getClass().getName();
                this.putString(name);
                for (Object obj : objs) {
                    this.encodeObj(obj);
                }
            }
        } else if (type.equals(HashMap.class) || type.equals(Map.class)) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                this.putShort(0);
            } else {
                this.putShort((short)map.size());
                boolean f = false;
                for (Map.Entry next : map.entrySet()) {
                    if (!f) {
                        f = true;
                        this.putString(next.getKey().getClass().getName());
                        this.putString(next.getValue().getClass().getName());
                    }
                    this.encodeObj(next.getKey());
                    this.encodeObj(next.getValue());
                }
            }
        } else if (type.equals(HashSet.class) || type.equals(Set.class)) {
            Set set = (Set)object;
            if (set.isEmpty()) {
                this.putShort(0);
            } else {
                this.putShort((short)set.size());
                boolean f = false;
                for (Object value : set) {
                    if (!f) {
                        f = true;
                        this.putString(value.getClass().getName());
                    }
                    this.encodeObj(value);
                }
            }
        } else if (object instanceof MessageMeta) {
            this.putMessageMeta((MessageMeta)object);
        } else if (object.getClass().isArray() && object.getClass().getComponentType().getSuperclass() == MessageMeta.class) {
            this.putMessageMetaArray((MessageMeta[])object);
        } else {
            throw new IOException(object.getClass().getName() + " does not supported yet!");
        }
    }
}

