/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.rpcx.providerx;

import io.netty.channel.Channel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.net.AddressPair;
import org.slingerxv.limitart.net.binary.BinaryClient;
import org.slingerxv.limitart.net.binary.BinaryServer;
import org.slingerxv.limitart.net.binary.handler.IHandler;
import org.slingerxv.limitart.net.binary.message.Message;
import org.slingerxv.limitart.net.binary.message.MessageFactory;
import org.slingerxv.limitart.rpcx.define.ServiceX;
import org.slingerxv.limitart.rpcx.exception.ServiceXProxyException;
import org.slingerxv.limitart.rpcx.message.schedule.AddScheduleToServiceCenterProviderMessage;
import org.slingerxv.limitart.rpcx.message.schedule.TriggerScheduleServiceCenterToProviderServiceCenterMessage;
import org.slingerxv.limitart.rpcx.message.service.DirectFetchProviderServicesMessage;
import org.slingerxv.limitart.rpcx.message.service.DirectFetchProviderServicesResultMessage;
import org.slingerxv.limitart.rpcx.message.service.PushServiceToServiceCenterProviderMessage;
import org.slingerxv.limitart.rpcx.message.service.RpcExecuteClientMessage;
import org.slingerxv.limitart.rpcx.message.service.RpcResultServerMessage;
import org.slingerxv.limitart.rpcx.providerx.config.ProviderXConfig;
import org.slingerxv.limitart.rpcx.providerx.listener.IProviderListener;
import org.slingerxv.limitart.rpcx.providerx.schedule.ProviderJob;
import org.slingerxv.limitart.rpcx.providerx.struct.RpcServiceInstance;
import org.slingerxv.limitart.rpcx.struct.RpcProviderName;
import org.slingerxv.limitart.rpcx.util.RpcUtil;
import org.slingerxv.limitart.util.ReflectionUtil;
import org.slingerxv.limitart.util.StringUtil;

public class ProviderX {
    private static Logger log = LoggerFactory.getLogger(ProviderX.class);
    private BinaryServer server;
    private BinaryClient serviceCenterClient;
    private IProviderListener providerListener;
    private ProviderXConfig config;
    private Map<String, RpcServiceInstance> services = new HashMap<String, RpcServiceInstance>();
    private Map<String, ProviderJob> scheduleJobs = new HashMap<String, ProviderJob>();

    public ProviderX(ProviderXConfig config) throws Exception {
        this(config, null);
    }

    public ProviderX(ProviderXConfig config, IProviderListener providerListener) throws Exception {
        this.providerListener = providerListener;
        this.config = Objects.requireNonNull(config, "config");
        MessageFactory factory = new MessageFactory();
        factory.registerMsg(new RpcExecuteClientHandler());
        factory.registerMsg(new DirectFetchProverServicesHandler());
        this.server = new BinaryServer.BinaryServerBuilder().addressPair(new AddressPair(config.getMyPort())).serverName("RPC-Provider").factory(factory).dispatchMessage((message, handler) -> {
            message.setExtra(this);
            try {
                handler.handle(message);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }).onServerBind(channel -> {
            if (this.providerListener != null) {
                this.providerListener.onProviderBind(this);
            }
        }).build();
        if (this.config.getServiceCenterIp() != null) {
            MessageFactory centerFacotry = new MessageFactory();
            centerFacotry.registerMsg(new TriggerScheduleServiceCenterToProviderServiceCenterHandler());
            this.serviceCenterClient = new BinaryClient.BinaryClientBuilder().autoReconnect(5).remoteAddress(new AddressPair(this.config.getServiceCenterIp(), this.config.getServiceCenterPort())).factory(centerFacotry).onConnectionEffective(client -> {
                this.pushServicesToCenter();
                if (this.providerListener != null) {
                    this.providerListener.onServiceCenterConnected(this);
                }
            }).dispatchMessage((message, handler) -> {
                message.setExtra(this);
                try {
                    handler.handle(message);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }).build();
        }
    }

    public void bind() throws Exception {
        this.initAllServices();
        if (this.serviceCenterClient != null) {
            this.serviceCenterClient.connect();
        }
        this.server.startServer();
    }

    public void stop() {
        if (this.serviceCenterClient != null) {
            this.serviceCenterClient.disConnect();
        }
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initAllServices() throws ServiceXProxyException, IOException, ReflectiveOperationException {
        void var4_6;
        this.services.clear();
        ArrayList classesByPackage = new ArrayList();
        String[] stringArray = this.config.getServicePackages();
        int n = stringArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            String temp = stringArray[var4_6];
            log.info("\u5f00\u59cb\u5728\u5305\uff1a" + temp + "\u4e0b\u67e5\u627e\u63a5\u53e3...");
            classesByPackage.addAll(ReflectionUtil.getClassesByPackage(temp, Object.class));
            ++var4_6;
        }
        HashMap rpcInterfaces = new HashMap();
        for (Class clazz : classesByPackage) {
            ServiceX annotation = clazz.getAnnotation(ServiceX.class);
            if (annotation == null) continue;
            if (!clazz.isInterface()) {
                throw new ServiceXProxyException(clazz.getName() + "RPC\u670d\u52a1\u5668\u5fc5\u987b\u662f\u4e00\u4e2a\u63a5\u53e3\uff01");
            }
            String provider = annotation.provider();
            if (StringUtil.isEmptyOrNull(provider)) {
                throw new ServiceXProxyException("RPC\u63a5\u53e3\u63d0\u4f9b\u5546\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String serviceName = RpcUtil.getServiceName(new RpcProviderName(provider), clazz);
            if (this.services.containsKey(serviceName)) {
                throw new ServiceXProxyException("\u670d\u52a1\u540d\uff1a" + serviceName + "\u91cd\u590d\uff01");
            }
            Method[] methods = clazz.getMethods();
            HashMap<String, Method> methodSet = new HashMap<String, Method>();
            for (Method method : methods) {
                Class<?>[] parameterTypes;
                String methodOverloadName = ReflectionUtil.getMethodOverloadName(method);
                for (Class<?> paramsType : parameterTypes = method.getParameterTypes()) {
                    RpcUtil.checkParamType(paramsType);
                }
                RpcUtil.checkParamType(method.getReturnType());
                Class<?>[] exceptionTypes = method.getExceptionTypes();
                if (exceptionTypes == null || exceptionTypes.length < 1) {
                    throw new ServiceXProxyException("\u7c7b" + clazz.getName() + "\u7684\u65b9\u6cd5" + methodOverloadName + "\u5fc5\u987b\u8981\u629b\u51fa\u5f02\u5e38\uff1a" + Exception.class.getName());
                }
                boolean exOk = false;
                for (Class<?> ex : exceptionTypes) {
                    if (ex != Exception.class) continue;
                    exOk = true;
                }
                if (!exOk) {
                    throw new ServiceXProxyException("\u7c7b" + clazz.getName() + "\u7684\u65b9\u6cd5" + methodOverloadName + "\u7684\u5f02\u5e38\u629b\u51fa\u5fc5\u987b\u6709\uff1a" + Exception.class.getName());
                }
                methodSet.put(ReflectionUtil.getMethodOverloadName(method), method);
            }
            rpcInterfaces.put(clazz, methodSet);
        }
        List<Class<?>> classesByPackage2 = ReflectionUtil.getClassesByPackage(this.config.getServiceImplPackages(), Object.class);
        log.info("\u5f00\u59cb\u5728\u5305\uff1a" + this.config.getServiceImplPackages() + "\u4e0b\u67e5\u627e\u63a5\u53e3\u5b9e\u73b0...");
        for (Class<?> clazz : classesByPackage2) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces == null || interfaces.length < 1) continue;
            HashMap serviceNames = new HashMap();
            Object instance = null;
            for (Class<?> temp : interfaces) {
                Map hashMap = (Map)rpcInterfaces.get(temp);
                if (hashMap == null) continue;
                ServiceX annotation = temp.getAnnotation(ServiceX.class);
                serviceNames.put(RpcUtil.getServiceName(new RpcProviderName(annotation.provider()), temp), temp);
                if (instance != null) continue;
                instance = clazz.newInstance();
            }
            if (instance == null || serviceNames.isEmpty()) continue;
            for (Map.Entry entry : serviceNames.entrySet()) {
                String serviceName = (String)entry.getKey();
                if (this.services.containsKey(serviceName)) {
                    throw new ServiceXProxyException("\u670d\u52a1\uff1a" + serviceName + "\u53d1\u73b0\u4e86\u591a\u4e2a\u5b9e\u73b0\u7c7b\uff1a" + instance);
                }
                RpcServiceInstance data = new RpcServiceInstance();
                data.setInstance(instance);
                Class value = (Class)entry.getValue();
                data.getMethods().putAll((Map)rpcInterfaces.get(value));
                this.services.put(serviceName, data);
                log.info("\u53d1\u73b0\u670d\u52a1\uff1a" + serviceName + "\uff0c\u5b9e\u4f8b\u540d\u79f0\uff1a" + clazz.getName() + "@" + Integer.toHexString(instance.hashCode()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRPC(Channel channel, int requestId, String moduleName, String methodName, List<Object> params) throws Exception {
        block18: {
            RpcResultServerMessage msg = new RpcResultServerMessage();
            msg.setRequestId(requestId);
            msg.setErrorCode(0);
            try {
                RpcServiceInstance serviceInstanceData = this.services.get(moduleName);
                if (serviceInstanceData == null) {
                    log.error("RPC\u6d88\u8d39\u8005\uff1a" + channel.remoteAddress() + "\u53d1\u9001\u4e86\u672a\u77e5\u7684\u670d\u52a1\u540d\uff1a" + moduleName);
                    msg.setErrorCode(1);
                    return;
                }
                Method method = serviceInstanceData.getMethods().get(methodName);
                if (method == null) {
                    log.error("RPC\u6d88\u8d39\u8005\uff1a" + channel.remoteAddress() + "\u53d1\u9001\u4e86\u672a\u77e5\u7684\u65b9\u6cd5\u540d\uff1a" + methodName + "\uff0c\u670d\u52a1\u540d\u4e3a\uff1a" + moduleName);
                    msg.setErrorCode(2);
                    return;
                }
                if (msg.getErrorCode() != 0) break block18;
                try {
                    Object result = method.invoke(serviceInstanceData.self(), params.toArray());
                    if (result != null) {
                        msg.setReturnType(result.getClass().getName());
                        msg.setReturnVal(result);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                try {
                    this.server.sendMessage(channel, (Message)msg, null);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void directPushServices(Channel channel) {
        DirectFetchProviderServicesResultMessage msg = new DirectFetchProviderServicesResultMessage();
        msg.providerId = this.config.getProviderUID();
        msg.services.addAll(this.services.keySet());
        try {
            this.server.sendMessage(channel, (Message)msg, null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void pushServicesToCenter() {
        log.info("\u5f00\u59cb\u53d1\u5e03\u81ea\u5df1\u7684\u670d\u52a1\u5230\u670d\u52a1\u4e2d\u5fc3...");
        PushServiceToServiceCenterProviderMessage msg = new PushServiceToServiceCenterProviderMessage();
        msg.myIp = this.config.getMyIp();
        msg.myPort = this.config.getMyPort();
        msg.providerUID = this.config.getProviderUID();
        for (String serviceName : this.services.keySet()) {
            msg.services.add(serviceName);
            log.info("\u53d1\u5e03\u670d\u52a1\u5230\u670d\u52a1\u4e2d\u5fc3\uff1a" + serviceName);
        }
        try {
            this.serviceCenterClient.sendMessage(msg, null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public <T> T getServiceInstance(RpcProviderName provider, Class<T> clazz) throws ServiceXProxyException {
        ServiceX annotation = clazz.getAnnotation(ServiceX.class);
        if (annotation == null) {
            throw new ServiceXProxyException(clazz.getName() + "is not ServiceX!");
        }
        RpcServiceInstance serviceInstanceData = this.services.get(RpcUtil.getServiceName(provider, clazz));
        if (serviceInstanceData == null) {
            return null;
        }
        return (T)serviceInstanceData.self();
    }

    public void schedule(ProviderJob job) throws Exception {
        if (this.serviceCenterClient == null) {
            throw new Exception("\u6b64Provider\u4e0d\u662f\u670d\u52a1\u4e2d\u5fc3\u6a21\u5f0f");
        }
        String jobName = job.getJobName();
        if (this.scheduleJobs.containsKey(jobName)) {
            throw new Exception("\u91cd\u590d\u7684JobName:" + jobName);
        }
        AddScheduleToServiceCenterProviderMessage msg = new AddScheduleToServiceCenterProviderMessage();
        msg.jobName = job.getJobName();
        msg.providerId = this.config.getProviderUID();
        msg.cronExpression = job.getCronExpression();
        msg.intervalInHours = job.getIntervalInHours();
        msg.intervalInMinutes = job.getIntervalInMinutes();
        msg.intervalInSeconds = job.getIntervalInSeconds();
        msg.intervalInMillis = job.getIntervalInMillis();
        msg.repeatCount = job.getRepeatCount();
        this.serviceCenterClient.sendMessage(msg, (isSuccess, cause, channel) -> {
            if (isSuccess.booleanValue()) {
                this.scheduleJobs.put(jobName, job);
                log.info("\u6ce8\u518c\u4e00\u4e2a\u5b9a\u65f6\u4efb\u52a1\u5230\u670d\u52a1\u4e2d\u5fc3\uff1a" + job.toString());
            } else {
                log.error("\u6ce8\u518c\u5b9a\u65f6\u4efb\u52a1\u5230\u670d\u52a1\u4e2d\u5fc3\u5931\u8d25\uff1a" + job.toString());
            }
        });
    }

    private void onScheduleTrigger(String jobName, boolean end) {
        ProviderJob providerJob = this.scheduleJobs.get(jobName);
        if (providerJob == null) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u89e6\u53d1\uff1a" + jobName + "\uff0c\u627e\u4e0d\u5230\u56de\u8c03\uff01");
            return;
        }
        if (end) {
            this.scheduleJobs.remove(jobName);
            log.info("\u670d\u52a1\u4e2d\u5fc3\u901a\u77e5\u4efb\u52a1\u751f\u547d\u7ec8\u7ed3\uff0c\u6267\u884c\u5220\u9664\uff1a" + jobName);
        }
        providerJob.getListener().action();
    }

    public class TriggerScheduleServiceCenterToProviderServiceCenterHandler
    implements IHandler<TriggerScheduleServiceCenterToProviderServiceCenterMessage> {
        @Override
        public void handle(TriggerScheduleServiceCenterToProviderServiceCenterMessage msg) {
            String jobName = msg.getJobName();
            ((ProviderX)msg.getExtra()).onScheduleTrigger(jobName, msg.isEnd());
        }
    }

    public class DirectFetchProverServicesHandler
    implements IHandler<DirectFetchProviderServicesMessage> {
        @Override
        public void handle(DirectFetchProviderServicesMessage msg) {
            ((ProviderX)msg.getExtra()).directPushServices(msg.getChannel());
        }
    }

    public class RpcExecuteClientHandler
    implements IHandler<RpcExecuteClientMessage> {
        @Override
        public void handle(RpcExecuteClientMessage msg) {
            try {
                ((ProviderX)msg.getExtra()).executeRPC(msg.getChannel(), msg.requestId, msg.moduleName, msg.methodName, msg.params);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

