/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.rpcx.providerx.schedule;

import java.util.Objects;
import org.slingerxv.limitart.rpcx.providerx.schedule.IProviderScheduleListener;
import org.slingerxv.limitart.util.StringUtil;

public final class ProviderJob {
    private String jobName;
    private String cronExpression;
    private int intervalInHours;
    private int intervalInMinutes;
    private int intervalInSeconds;
    private int intervalInMillis;
    private int repeatCount;
    private IProviderScheduleListener listener;

    private ProviderJob(ProviderJobBuilder builder) {
        Objects.requireNonNull(builder.jobName, "jobName");
        if (StringUtil.isEmptyOrNull(builder.cronExpression) && builder.intervalInHours <= 0 && builder.intervalInMinutes <= 0 && builder.intervalInSeconds <= 0 && builder.intervalInMillis <= 0) {
            throw new IllegalArgumentException("schedule time");
        }
        Objects.requireNonNull(builder.listener, "listener");
        this.jobName = builder.jobName;
        this.cronExpression = builder.cronExpression;
        this.intervalInHours = builder.intervalInHours;
        this.intervalInMinutes = builder.intervalInMinutes;
        this.intervalInSeconds = builder.intervalInSeconds;
        this.intervalInMillis = builder.intervalInMillis;
        this.repeatCount = builder.repeatCount;
        this.listener = builder.listener;
    }

    public String toString() {
        return "ProviderJob [jobName=" + this.jobName + ", cronExpression=" + this.cronExpression + ", intervalInHours=" + this.intervalInHours + ", intervalInMinutes=" + this.intervalInMinutes + ", intervalInSeconds=" + this.intervalInSeconds + ", intervalInMillis=" + this.intervalInMillis + ", repeatCount=" + this.repeatCount + ", listener=" + this.listener + "]";
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public int getIntervalInHours() {
        return this.intervalInHours;
    }

    public int getIntervalInMinutes() {
        return this.intervalInMinutes;
    }

    public int getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    public int getIntervalInMillis() {
        return this.intervalInMillis;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public IProviderScheduleListener getListener() {
        return this.listener;
    }

    public static class ProviderJobBuilder {
        private String jobName;
        private String cronExpression;
        private int intervalInHours;
        private int intervalInMinutes;
        private int intervalInSeconds;
        private int intervalInMillis;
        private int repeatCount;
        private IProviderScheduleListener listener;

        public ProviderJob build() {
            return new ProviderJob(this);
        }

        public ProviderJobBuilder jobName(String jobName) {
            this.jobName = Objects.requireNonNull(jobName, "jobName");
            return this;
        }

        public ProviderJobBuilder cronExpression(String cronExpression) {
            this.cronExpression = Objects.requireNonNull(this.jobName, "cronExpression");
            return this;
        }

        public ProviderJobBuilder intervalInHours(int intervalInHours) {
            this.intervalInHours = intervalInHours < 0 ? 0 : intervalInHours;
            return this;
        }

        public ProviderJobBuilder intervalInMinutes(int intervalInMinutes) {
            this.intervalInMinutes = intervalInMinutes < 0 ? 0 : intervalInMinutes;
            return this;
        }

        public ProviderJobBuilder intervalInSeconds(int intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds < 0 ? 0 : intervalInSeconds;
            return this;
        }

        public ProviderJobBuilder intervalInMillis(int intervalInMillis) {
            this.intervalInMillis = intervalInMillis < 0 ? 0 : intervalInMillis;
            return this;
        }

        public ProviderJobBuilder repeatCount(int repeatCount) {
            this.repeatCount = repeatCount < 0 ? 0 : repeatCount;
            return this;
        }

        public ProviderJobBuilder repeatForever() {
            this.repeatCount = -1;
            return this;
        }

        public ProviderJobBuilder listener(IProviderScheduleListener listener) {
            this.listener = Objects.requireNonNull(listener, "listener");
            if (StringUtil.isEmptyOrNull(this.jobName)) {
                return this.jobName(listener.getClass().getName());
            }
            return this;
        }
    }
}

