/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.rpcx.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slingerxv.limitart.net.binary.message.MessageMeta;
import org.slingerxv.limitart.rpcx.define.ServiceX;
import org.slingerxv.limitart.rpcx.exception.ServiceXProxyException;
import org.slingerxv.limitart.rpcx.struct.RpcProviderName;
import org.slingerxv.limitart.util.StringUtil;

public final class RpcUtil {
    private RpcUtil() {
    }

    public static String getServiceName(RpcProviderName providerName, Class<?> serviceClass) throws ServiceXProxyException {
        ServiceX annotation = serviceClass.getAnnotation(ServiceX.class);
        if (annotation == null) {
            throw new ServiceXProxyException("not a ServiceX class(annotation)");
        }
        String modole = annotation.module();
        if (StringUtil.isEmptyOrNull(modole)) {
            modole = serviceClass.getSimpleName();
        }
        return providerName.getName() + "@" + modole;
    }

    public static void checkParamType(Class<?> type) throws ServiceXProxyException {
        if (!type.isPrimitive()) {
            if (type.isArray()) {
                RpcUtil.checkParamType(type.getComponentType());
            } else if (!MessageMeta.class.isAssignableFrom(type) && type != String.class && type != List.class && type != ArrayList.class && type != HashMap.class && type != Map.class && type != HashSet.class && type != Set.class) {
                throw new ServiceXProxyException(type.getName() + "\u5fc5\u987b\u662f\u57fa\u7840\u7c7b\u578b\uff08\u5305\u62ec\u5176\u6570\u7ec4\uff09\u6216" + MessageMeta.class.getName() + "\u7684\u5b50\u7c7b\uff0c\u6216\u8005\u4e3a\u4e0a\u8ff0\u7c7b\u578b\u7684java.util.List\u6216java.util.ArrayList");
            }
        }
    }
}

