/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.script;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.script.IDynamicCode;
import org.slingerxv.limitart.script.IScript;
import org.slingerxv.limitart.script.ScriptException;
import org.slingerxv.limitart.script.ScriptFileType;

public abstract class AbstractScriptLoader<KEY> {
    protected static final Logger log = LoggerFactory.getLogger(AbstractScriptLoader.class);
    protected Map<KEY, IScript<KEY>> scriptMap = new ConcurrentHashMap<KEY, IScript<KEY>>();
    protected Map<KEY, File> scriptPath = new ConcurrentHashMap<KEY, File>();
    private AtomicLong dynamicCodeCount = new AtomicLong(100000L);

    public void foreach(BiConsumer<? super KEY, ? super IScript<KEY>> action) {
        this.scriptMap.forEach(action);
    }

    public <T extends IScript<KEY>> T getScript(KEY scriptId) {
        return (T)this.scriptMap.get(scriptId);
    }

    public AbstractScriptLoader<KEY> executeCommand(String path) throws ScriptException, IOException, InstantiationException, IllegalAccessException {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("file not exist!");
        }
        if (file.isDirectory()) {
            throw new ScriptException("script file is directory!");
        }
        String[] split = file.getName().split("[.]");
        if (split.length < 2) {
            throw new ScriptException("file name must has extension,like .java .groovy,yours:" + file.getName());
        }
        String type = split[1];
        ScriptFileType typeByValue = ScriptFileType.getTypeByValue(type);
        if (typeByValue == null) {
            throw new ScriptException("script type not supported:" + type);
        }
        try (GroovyClassLoader loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());){
            Class parseClass = loader.parseClass(file);
            Object newInstance = parseClass.newInstance();
            if (!(newInstance instanceof IDynamicCode)) {
                throw new ScriptException("class must extends IDynamicCode");
            }
            IDynamicCode temp = (IDynamicCode)newInstance;
            log.info("compile code success,start executing...");
            temp.execute();
            log.info("done!");
        }
        return this;
    }

    public AbstractScriptLoader<KEY> executeCommand(List<String> importList, String commandLines) throws InstantiationException, IllegalAccessException, IOException, ScriptException, IllegalArgumentException, InvocationTargetException {
        StringBuilder importBuffer = new StringBuilder();
        if (importList != null) {
            for (String temp : importList) {
                importBuffer.append("import " + temp + ";");
            }
        }
        String result = importBuffer.toString() + "import com.limitart.script.IDynamicCode; public class DynamicCodeProxy" + this.dynamicCodeCount.getAndIncrement() + " extends IDynamicCode {" + " public void execute() {" + commandLines + "}" + "}";
        try (GroovyClassLoader loader = new GroovyClassLoader(Thread.currentThread().getContextClassLoader());){
            Class parseClass = loader.parseClass(result);
            IDynamicCode newInstance = (IDynamicCode)parseClass.newInstance();
            log.info("compile code success,start executing...");
            newInstance.execute();
            log.info("done!");
        }
        return this;
    }
}

