/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.script;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slingerxv.limitart.script.AbstractScriptLoader;
import org.slingerxv.limitart.script.IDynamicCode;
import org.slingerxv.limitart.script.IScript;
import org.slingerxv.limitart.script.ScriptException;
import org.slingerxv.limitart.script.ScriptFileType;
import org.slingerxv.limitart.util.FileUtil;

public class FileScriptLoader<KEY>
extends AbstractScriptLoader<KEY> {
    public AbstractScriptLoader<KEY> reloadScript(KEY scriptId) throws CompilationFailedException, IOException, InstantiationException, IllegalAccessException, ScriptException {
        File file = (File)this.scriptPath.get(scriptId);
        Objects.requireNonNull(file, "script id:" + scriptId + " does not exist!");
        try (GroovyClassLoader loader = new GroovyClassLoader(ClassLoader.getSystemClassLoader());){
            Class parseClass = loader.parseClass(file);
            Object newInstance = parseClass.newInstance();
            if (!(newInstance instanceof IScript)) {
                throw new ScriptException("script file must implement IScript:" + file.getName());
            }
            IScript newScript = (IScript)newInstance;
            this.scriptMap.put(scriptId, newScript);
            log.info("reload script success:" + file.getName());
        }
        return this;
    }

    public AbstractScriptLoader<KEY> loadScript(String filePath) throws IOException, ScriptException, InstantiationException, IllegalAccessException {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("file not exist!");
        }
        if (file.isDirectory()) {
            throw new ScriptException("script file is directory!");
        }
        String[] split = file.getName().split("[.]");
        if (split.length < 2) {
            throw new ScriptException("file name must has extension,like .java .groovy,yours:" + file.getName());
        }
        String type = split[1];
        ScriptFileType typeByValue = ScriptFileType.getTypeByValue(type);
        if (typeByValue == null) {
            throw new ScriptException("script type not supported" + type);
        }
        try (GroovyClassLoader loader = new GroovyClassLoader(ClassLoader.getSystemClassLoader());){
            Class parseClass = loader.parseClass(file);
            Object newInstance = parseClass.newInstance();
            if (!(newInstance instanceof IScript)) {
                throw new ScriptException("script file must implement IScript:" + file.getName());
            }
            if (newInstance instanceof IDynamicCode) {
                throw new ScriptException("script file must not extend IDynamicCode:" + file.getName());
            }
            IScript script = (IScript)newInstance;
            Object scriptId = script.getScriptId();
            if (this.scriptMap.containsKey(scriptId)) {
                throw new ScriptException("script id(" + scriptId + ") duplicated,source:" + ((File)this.scriptPath.get(scriptId)).getName() + ",yours:" + file.getName());
            }
            this.scriptMap.put(scriptId, script);
            this.scriptPath.put(scriptId, file);
            log.info("compile script success:" + file.getName());
        }
        return this;
    }

    public AbstractScriptLoader<KEY> loadScriptsBySourceDir(String dir, ScriptFileType ... scriptTypes) throws IOException, InstantiationException, IllegalAccessException, ScriptException {
        ConcurrentHashMap scriptMap_new = new ConcurrentHashMap();
        ConcurrentHashMap scriptPath_new = new ConcurrentHashMap();
        try (GroovyClassLoader loader = new GroovyClassLoader(ClassLoader.getSystemClassLoader());){
            File dir_root = new File(dir);
            if (!dir_root.exists()) {
                throw new IOException("scripts root dir does not exist:" + dir);
            }
            if (!dir_root.isDirectory()) {
                throw new IOException("file is not dir:" + dir);
            }
            String[] types = null;
            if (scriptTypes != null && scriptTypes.length > 0) {
                types = new String[scriptTypes.length];
                for (int i = 0; i < scriptTypes.length; ++i) {
                    types[i] = scriptTypes[i].getValue();
                }
            }
            List<File> result = FileUtil.getFiles(dir_root, types);
            for (File file : result) {
                Class parseClass = loader.parseClass(file);
                Object newInstance = parseClass.newInstance();
                if (newInstance instanceof IScript) {
                    if (newInstance instanceof IDynamicCode) continue;
                    IScript script = (IScript)newInstance;
                    Object scriptId = script.getScriptId();
                    if (scriptMap_new.containsKey(scriptId)) {
                        log.error("script id duplicated,source:" + ((File)this.scriptPath.get(scriptId)).getName() + ",yours:" + file.getName());
                        continue;
                    }
                    scriptMap_new.put(scriptId, script);
                    scriptPath_new.put(scriptId, file);
                    log.info("compile script success:" + file.getName());
                    continue;
                }
                throw new ScriptException("script file must implement IScript:" + file.getName());
            }
            this.scriptMap = scriptMap_new;
            this.scriptPath = scriptPath_new;
        }
        return this;
    }
}

