/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.script;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slingerxv.limitart.script.AbstractScriptLoader;
import org.slingerxv.limitart.script.IDynamicCode;
import org.slingerxv.limitart.script.IScript;
import org.slingerxv.limitart.script.ScriptException;
import org.slingerxv.limitart.util.FTPUtil;
import org.slingerxv.limitart.util.FileUtil;

public class JarScriptLoader<KEY>
extends AbstractScriptLoader<KEY> {
    private AbstractScriptLoader<KEY> loadScriptsByJar(String jarName) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, ScriptException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        File file = new File(jarName);
        if (!file.exists()) {
            throw new IOException("file not exist:" + jarName);
        }
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        add.setAccessible(true);
        add.invoke((Object)classLoader, file.toURI().toURL());
        ConcurrentHashMap scriptMap_new = new ConcurrentHashMap();
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.replace("/", ".").substring(0, entryName.indexOf(".class"));
                Class<?> clazz = classLoader.loadClass(className);
                log.info("load class\uff1a" + className);
                if (clazz == null) {
                    throw new ScriptException("class not found:" + className);
                }
                if (className.contains("$")) continue;
                Object newInstance = clazz.newInstance();
                if (newInstance instanceof IScript) {
                    if (newInstance instanceof IDynamicCode) continue;
                    IScript script = (IScript)newInstance;
                    Object scriptId = script.getScriptId();
                    if (scriptMap_new.containsKey(scriptId)) {
                        log.error("script id duplicated,source:" + ((File)this.scriptPath.get(scriptId)).getName() + ",yours:" + clazz.getName());
                        continue;
                    }
                    scriptMap_new.put(scriptId, script);
                    log.info("compile script success:" + clazz.getName());
                    continue;
                }
                throw new ScriptException("script file must implement IScript:" + clazz.getName());
            }
            this.scriptMap = scriptMap_new;
        }
        return this;
    }

    public void reloadScriptJarLocal(String jarPath) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, ScriptException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        log.info("start load local jar:" + jarPath);
        this.loadScriptsByJar(jarPath);
    }

    public void reloadScriptJarFTP(String ftpIp, int ftpPort, String username, String password, String resourceDir, String jarName) throws ScriptException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, IllegalArgumentException, InvocationTargetException {
        log.info("strat load remote jar:" + jarName);
        byte[] download = FTPUtil.download(ftpIp, ftpPort, username, password, resourceDir, jarName);
        if (download == null) {
            throw new ScriptException("download script file failed\uff01");
        }
        log.info("download jar file success\uff0cfile length\uff1a" + download.length);
        String tempDir = "temp";
        String tempJar = "script.limitart";
        String tempPath = tempDir + "/" + tempJar;
        File jarFile = new File(tempPath);
        FileUtil.writeNewFile(tempDir, tempJar, download);
        this.loadScriptsByJar(tempPath);
        jarFile.delete();
    }
}

