/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.taskqueue;

import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Proc1;
import org.slingerxv.limitart.funcs.Proc2;
import org.slingerxv.limitart.funcs.Procs;
import org.slingerxv.limitart.funcs.Test1;
import org.slingerxv.limitart.funcs.Tests;
import org.slingerxv.limitart.taskqueue.ITaskQueue;

public class LinkedBlockingTaskQueue<T>
extends Thread
implements ITaskQueue<T> {
    private static Logger log = LoggerFactory.getLogger(LinkedBlockingTaskQueue.class);
    private LinkedBlockingQueue<T> queue = new LinkedBlockingQueue();
    private boolean start = false;
    private Test1<T> intercept;
    private Proc1<T> handle;
    private Proc2<T, Throwable> exception;

    public LinkedBlockingTaskQueue(String threadName) {
        this.setName(threadName);
    }

    public ITaskQueue<T> intercept(Test1<T> intercept) {
        this.intercept = intercept;
        return this;
    }

    public ITaskQueue<T> handle(Proc1<T> handle) {
        this.handle = handle;
        return this;
    }

    public ITaskQueue<T> exception(Proc2<T, Throwable> exception) {
        this.exception = exception;
        return this;
    }

    @Override
    public void run() {
        this.start = true;
        while (this.start || !this.queue.isEmpty()) {
            Object take = null;
            try {
                take = this.queue.take();
                if (Tests.invoke(this.intercept, take)) continue;
                Procs.invoke(this.handle, take);
            }
            catch (Exception e) {
                log.error("invoke error", (Throwable)e);
                Procs.invoke(this.exception, take, e);
            }
        }
    }

    @Override
    public void addCommand(T command) {
        Objects.requireNonNull(command, "command");
        this.queue.offer(command);
    }

    @Override
    public void stopServer() {
        this.start = false;
    }

    @Override
    public void startServer() {
        this.start();
    }

    @Override
    public String getThreadName() {
        return this.getName();
    }
}

