/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.taskqueuegroup;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.limitart.funcs.Func1;
import org.slingerxv.limitart.taskqueue.ITaskQueue;
import org.slingerxv.limitart.taskqueue.TaskQueueException;
import org.slingerxv.limitart.taskqueuegroup.AutoGrowthEntity;
import org.slingerxv.limitart.taskqueuegroup.AutoGrowthSegment;

public class AutoGrowthTaskQueueGroup<T> {
    private static Logger log = LoggerFactory.getLogger(AutoGrowthTaskQueueGroup.class);
    private AtomicInteger threadId = new AtomicInteger(0);
    private Map<Integer, AutoGrowthSegment<T>> threads = new ConcurrentHashMap<Integer, AutoGrowthSegment<T>>();
    private int entityCountPerThread;
    private int coreThreadCount;
    private int maxThreadCount;
    private Func1<Integer, ITaskQueue<T>> newTaskQueue;

    public AutoGrowthTaskQueueGroup(int entityCountPerThread, int coreThreadCount, int initThreadCount, int maxThreadCount, Func1<Integer, ITaskQueue<T>> newTaskQueue) throws Exception {
        Objects.requireNonNull(newTaskQueue, "taskQueueFactory");
        this.newTaskQueue = newTaskQueue;
        this.maxThreadCount = maxThreadCount;
        this.entityCountPerThread = entityCountPerThread;
        this.coreThreadCount = Math.min(coreThreadCount, this.maxThreadCount);
        if (initThreadCount > 10) {
            log.warn("initThreadCount is too large, less than 10 better!");
        }
        if (maxThreadCount > 50) {
            log.warn("maxThreadCount is too large,less than 50 better!");
        }
        int initCount = Math.min(initThreadCount, this.maxThreadCount);
        log.info("init,entityCountPerThread:" + this.entityCountPerThread + ",initThreadCount:" + initCount + ",coreThreadCount:" + this.coreThreadCount + ",maxThreadCount:" + this.maxThreadCount);
        if (initCount > 0) {
            for (int i = 0; i < initCount; ++i) {
                this.newGrowthThread();
            }
        }
    }

    public synchronized void registerEntity(AutoGrowthEntity entity) throws Exception {
        if (entity.getThreadIndex() > 0) {
            throw new TaskQueueException("entity has already registered!");
        }
        AutoGrowthSegment<T> thread = null;
        if (this.threads.size() >= this.maxThreadCount && this.maxThreadCount > 0) {
            int min = Integer.MAX_VALUE;
            for (AutoGrowthSegment<T> temp : this.threads.values()) {
                int size = temp.getEntities().size();
                if (size >= min) continue;
                min = size;
                thread = temp;
            }
        } else {
            for (AutoGrowthSegment<T> temp : this.threads.values()) {
                if (temp.getEntities().size() >= this.entityCountPerThread) continue;
                thread = temp;
                break;
            }
        }
        if (thread == null) {
            thread = this.newGrowthThread();
        }
        thread.getEntities().add(entity);
        entity.setThreadIndex(thread.getThreadIndex());
    }

    public void addCommand(AutoGrowthEntity entity, T t) throws TaskQueueException {
        if (entity.getThreadIndex() == 0) {
            throw new TaskQueueException("entity does not register!");
        }
        this.threads.get(entity.getThreadIndex()).getThread().addCommand(t);
    }

    public synchronized void unregisterEntity(AutoGrowthEntity entity) throws Exception {
        AutoGrowthSegment<T> remove;
        int threadIndex = entity.getThreadIndex();
        if (threadIndex == 0) {
            return;
        }
        if (!this.threads.containsKey(threadIndex)) {
            throw new TaskQueueException("thread " + threadIndex + " already destroyed\uff01");
        }
        AutoGrowthSegment<T> thread = this.threads.get(threadIndex);
        if (!thread.getEntities().contains(entity)) {
            throw new TaskQueueException("entity in thread " + threadIndex + " already destroyed\uff01");
        }
        if (!thread.getEntities().remove(entity)) {
            throw new TaskQueueException("entity in thread " + threadIndex + " destroy failed\uff01");
        }
        entity.setThreadIndex(0);
        log.info(thread.getThread().getThreadName() + " unregistered entity:" + entity);
        if (thread.getEntities().size() <= 0 && this.threads.size() > this.coreThreadCount && (remove = this.threads.remove(threadIndex)) != null) {
            remove.getThread().stopServer();
        }
    }

    private AutoGrowthSegment<T> newGrowthThread() throws Exception {
        int id = this.threadId.incrementAndGet();
        AutoGrowthSegment<T> data = new AutoGrowthSegment<T>();
        data.setThread(this.newTaskQueue.run(id));
        data.setThreadIndex(id);
        data.getThread().startServer();
        this.threads.put(data.getThreadIndex(), data);
        return data;
    }
}

