/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BadWordUtil {
    private static Logger log = LoggerFactory.getLogger(BadWordUtil.class);
    private static Node rootNode = new Node(82);

    public static synchronized void init(List<String> words) {
        rootNode = new Node(82);
        log.info("start load sensative words...");
        for (String str : words) {
            char[] chars = str.toCharArray();
            if (chars.length <= 0) continue;
            BadWordUtil.insertNode(rootNode, chars, 0);
        }
        log.info("load sensative words\uff1a" + words.size());
    }

    public static boolean hasBadWords(String content) {
        char[] chars = content.toCharArray();
        Node node = rootNode;
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> word = new ArrayList<String>();
        for (int a = 0; a < chars.length; ++a) {
            if ((node = BadWordUtil.findNode(node, chars[a])) == null) {
                node = rootNode;
                buffer.append(chars[a -= word.size()]);
                word.clear();
                continue;
            }
            if (node.flag == 1) {
                node = null;
                return true;
            }
            word.add(String.valueOf(chars[a]));
        }
        return false;
    }

    public static String filter(String content, String replace) {
        char[] chars = content.toCharArray();
        Node node = rootNode;
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> badList = new ArrayList<String>();
        for (int a = 0; a < chars.length; ++a) {
            int i;
            if ((node = BadWordUtil.findNode(node, chars[a])) == null) {
                node = rootNode;
                a -= badList.size();
                if (badList.size() > 0) {
                    badList.clear();
                }
                buffer.append(chars[a]);
                continue;
            }
            if (node.flag == 1) {
                badList.add(String.valueOf(chars[a]));
                for (i = 0; i < badList.size(); ++i) {
                    buffer.append(replace);
                }
                node = rootNode;
                badList.clear();
                continue;
            }
            badList.add(String.valueOf(chars[a]));
            if (a != chars.length - 1) continue;
            for (i = 0; i < badList.size(); ++i) {
                buffer.append((String)badList.get(i));
            }
        }
        return buffer.toString();
    }

    private static void insertNode(Node node, char[] cs, int index) {
        int start = index;
        Node n = BadWordUtil.findNode(node, cs[start]);
        if (n == null) {
            n = new Node(cs[start]);
            node.nodes.put(String.valueOf(cs[start]), n);
        }
        if (index == cs.length - 1) {
            n.flag = 1;
        }
        if (++start < cs.length) {
            BadWordUtil.insertNode(n, cs, start);
        }
    }

    private static Node findNode(Node node, char c) {
        return node.nodes.get(String.valueOf(c));
    }

    private static class Node {
        public int flag;
        public Map<String, Node> nodes = new HashMap<String, Node>();

        public Node(int flag) {
            this.flag = flag;
        }
    }
}

