/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import io.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public final class FTPUtil {
    private FTPUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] download(String url, int port, String username, String password, String remotePath, String fileName) throws IOException {
        block19: {
            FTPFile[] fs;
            FTPClient ftp = new FTPClient();
            ftp.setConnectTimeout(5000);
            ftp.setAutodetectUTF8(true);
            ftp.setCharset(CharsetUtil.UTF_8);
            ftp.setControlEncoding(CharsetUtil.UTF_8.name());
            ftp.connect(url, port);
            ftp.login(username, password);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                ftp.disconnect();
                throw new IOException("login fail!");
            }
            ftp.changeWorkingDirectory(remotePath);
            ftp.setFileType(2);
            for (FTPFile ff : fs = ftp.listFiles()) {
                if (!ff.getName().equals(fileName)) continue;
                try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                    byte[] result;
                    ftp.retrieveFile(ff.getName(), (OutputStream)is);
                    byte[] byArray = result = is.toByteArray();
                    return byArray;
                }
            }
            ftp.logout();
            break block19;
            finally {
                if (ftp.isConnected()) {
                    ftp.disconnect();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> download(String url, int port, String username, String password, String remotePath, String dirName, String filePattern) throws IOException {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(5000);
        ftp.setAutodetectUTF8(true);
        ftp.setCharset(CharsetUtil.UTF_8);
        ftp.setControlEncoding(CharsetUtil.UTF_8.name());
        try {
            FTPFile[] fs;
            ftp.connect(url, port);
            ftp.login(username, password);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                ftp.disconnect();
                throw new IOException("login fail!");
            }
            ftp.changeWorkingDirectory(remotePath);
            ftp.changeWorkingDirectory(dirName);
            ftp.setFileType(2);
            for (FTPFile ff : fs = ftp.listFiles()) {
                if (!ff.getName().endsWith("." + filePattern)) continue;
                try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                    ftp.retrieveFile(ff.getName(), (OutputStream)is);
                    result.put(ff.getName(), is.toByteArray());
                }
            }
            ftp.logout();
        }
        finally {
            if (ftp.isConnected()) {
                ftp.disconnect();
            }
        }
        return result;
    }
}

