/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public final class FileUtil {
    private FileUtil() {
    }

    public static List<File> getFiles(File root, String ... types) {
        ArrayList<File> result = new ArrayList<File>();
        if (root.isDirectory()) {
            File[] listFiles = root.listFiles();
            if (listFiles == null) {
                return result;
            }
            for (File temp : listFiles) {
                if (temp == null) continue;
                result.addAll(FileUtil.getFiles(temp, types));
            }
        } else {
            boolean filter = false;
            if (types != null && types.length > 0) {
                for (String type : types) {
                    if (!FileUtil.getFileNameExtention(root.getName()).equals(type)) continue;
                    filter = true;
                    break;
                }
            } else {
                filter = true;
            }
            if (filter) {
                result.add(root);
            }
        }
        return result;
    }

    public static ByteBuf readFile(File file) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        try (FileInputStream input = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = input.read(buffer)) != -1) {
                buf.writeBytes(buffer, 0, len);
            }
        }
        return buf;
    }

    public static void writeNewFile(String path, String fileName, byte[] content) throws IOException {
        File temp;
        File file = new File(path);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new IOException("make dir failed!");
            }
        } else if (!file.isDirectory()) {
            return;
        }
        if (!(temp = new File(path + "//" + fileName)).exists() && !temp.createNewFile()) {
            throw new IOException("create new file failed!");
        }
        Files.write(temp.toPath(), content, new OpenOption[0]);
    }

    public static String getFileNameExtention(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

