/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public final class RandomUtil {
    public static Random DEFAULT = new Random();
    public static Random SECURITY;

    private RandomUtil() {
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.randomInt(DEFAULT, min, max);
    }

    public static int randomIntSecure(int min, int max) {
        return RandomUtil.randomInt(SECURITY, min, max);
    }

    public static int randomInt(Random random, int start, int end) {
        if (start >= end) {
            return start;
        }
        return random.nextInt(end - start + 1) + start;
    }

    public static long randomLong(long start, long end) {
        return RandomUtil.randomLong(DEFAULT, start, end);
    }

    public static long randomLongSecure(long start, long end) {
        return RandomUtil.randomLong(SECURITY, start, end);
    }

    public static long randomLong(Random random, long start, long end) {
        if (start >= end) {
            return start;
        }
        return start + (long)(random.nextDouble() * (double)(end - start));
    }

    public static float randomFloat(float start, float end) {
        return RandomUtil.randomFloat(DEFAULT, start, end);
    }

    public static float randomFloatSecure(float start, float end) {
        return RandomUtil.randomFloat(SECURITY, start, end);
    }

    public static float randomFloat(Random random, float start, float end) {
        if (start >= end) {
            return start;
        }
        return start + random.nextFloat() * (end - start);
    }

    public static int randomOne() {
        return RandomUtil.randomOne(DEFAULT);
    }

    public static int randomOneSecure() {
        return RandomUtil.randomOne(SECURITY);
    }

    public static int randomOne(Random random) {
        return 1 | random.nextInt() >> 31;
    }

    public static int randomWeight(int[] weight) {
        int sumProb = 0;
        for (int prob : weight) {
            sumProb += prob;
        }
        int randomInt = RandomUtil.randomInt(0, sumProb);
        int step = 0;
        for (int i = 0; i < weight.length; ++i) {
            if (randomInt > (step += weight[i])) continue;
            return i;
        }
        return 0;
    }

    static {
        try {
            SECURITY = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

