/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import java.util.Collection;
import java.util.Properties;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchedulerUtil {
    private static final Logger log = LoggerFactory.getLogger(SchedulerUtil.class);
    private static SchedulerUtil INSTANCE = new SchedulerUtil();
    private SchedulerFactory SF;

    public static SchedulerUtil self() {
        return INSTANCE;
    }

    private SchedulerUtil() {
        Properties prop = new Properties();
        prop.setProperty("org.quartz.scheduler.instanceName", "LimitartScheduler");
        prop.setProperty("org.quartz.scheduler.threadName", "LimitartQuartz");
        prop.setProperty("org.quartz.threadPool.threadCount", "1");
        try {
            this.SF = new StdSchedulerFactory(prop);
        }
        catch (SchedulerException e) {
            log.error("init StdSchedulerFactory error", (Throwable)e);
        }
    }

    public Trigger addSchedule(String name, Class<? extends Job> task, String cronExpression, JobDataMap param) throws SchedulerException {
        Scheduler sched = this.SF.getScheduler();
        JobBuilder builder = JobBuilder.newJob(task);
        builder.withIdentity(name, "DEFAULT");
        if (param != null) {
            builder.usingJobData(param);
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, "DEFAULT").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        sched.scheduleJob(builder.build(), trigger);
        if (!sched.isShutdown()) {
            sched.start();
        }
        return trigger;
    }

    public Trigger addSchedule(String name, Class<? extends Job> task, int intervalInHours, int intervalInMinutes, int intervalInSeconds, int intervalInMillis, int repeatCount, JobDataMap param) throws SchedulerException {
        Scheduler sched = this.SF.getScheduler();
        JobBuilder builder = JobBuilder.newJob(task);
        builder.withIdentity(name, "DEFAULT");
        if (param != null) {
            builder.usingJobData(param);
        }
        SimpleScheduleBuilder simpleSchedule = SimpleScheduleBuilder.simpleSchedule();
        if (intervalInHours > 0) {
            simpleSchedule.withIntervalInHours(intervalInHours);
        }
        if (intervalInMinutes > 0) {
            simpleSchedule.withIntervalInMinutes(intervalInMinutes);
        }
        if (intervalInSeconds > 0) {
            simpleSchedule.withIntervalInSeconds(intervalInSeconds);
        }
        if (intervalInMillis > 0) {
            simpleSchedule.withIntervalInMilliseconds((long)intervalInMillis);
        }
        if (repeatCount >= 0) {
            simpleSchedule.withRepeatCount(repeatCount);
        } else {
            simpleSchedule.repeatForever();
        }
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name, "DEFAULT").withSchedule((ScheduleBuilder)simpleSchedule).build();
        sched.scheduleJob(builder.build(), trigger);
        if (!sched.isShutdown()) {
            sched.start();
        }
        return trigger;
    }

    public Trigger addSchedule(String name, Class<? extends Job> task, int intervalInSeconds, JobDataMap param) throws SchedulerException {
        return this.addSchedule(name, task, 0, 0, intervalInSeconds, 0, -1, param);
    }

    public boolean hasSchedule(String name) throws SchedulerException {
        Scheduler scheduler = this.SF.getScheduler();
        if (scheduler == null) {
            return false;
        }
        return scheduler.checkExists(new JobKey(name, "DEFAULT"));
    }

    public boolean removeSchedule(String name) throws SchedulerException {
        Scheduler scheduler = this.SF.getScheduler();
        JobKey key = new JobKey(name, "DEFAULT");
        return scheduler.deleteJob(key);
    }

    public void shutdown() {
        try {
            Collection allSchedulers = this.SF.getAllSchedulers();
            for (Scheduler s : allSchedulers) {
                s.shutdown();
            }
        }
        catch (SchedulerException e) {
            log.error("shut down error!", (Throwable)e);
        }
    }
}

