/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String BUDDHA = "\n                   _ooOoo_\n                  o8888888o\n                  88\" . \"88\n                  (| -_- |)\n                  O\\  =  /O\n               ____/`---'\\____\n             .'  \\\\|     |//  `.\n            /  \\\\|||  :  |||//  \\\n           /  _||||| -:- |||||-  \\\n           |   | \\\\\\  -  /// |   |\n           | \\_|  ''\\---/''  |   |\n           \\  .-\\__  `-`  ___/-. /\n         ___`. .'  /--.--\\  `. . __\n      .\"\" '<  `.___\\_<|>_/___.'  >'\"\".\n     | | :  `- \\`.;`\\ _ /`;.`/ - ` : | |\n     \\  \\ `-.   \\_ __\\ /__ _/   .-` /  /\n======`-.____`-.___\\_____/___.-`____.-'======\n                   `=---='\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n";
    private static final Pattern PHONE_REG = Pattern.compile("^((1[0-9][0-9]))\\d{8}$");
    private static final Pattern EMAIL_REG = Pattern.compile("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");
    private static final Pattern IP_REG = Pattern.compile("^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$");
    private static final Pattern IP_INNER_REG = Pattern.compile("^((192\\.168|172\\.([1][6-9]|[2]\\d|3[01]))(\\.([2][0-4]\\d|[2][5][0-5]|[01]?\\d?\\d)){2}|10(\\.([2][0-4]\\d|[2][5][0-5]|[01]?\\d?\\d)){3})$");

    private StringUtil() {
    }

    public static boolean isEmptyOrNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isPhoneNumber(String value) {
        return StringUtil.matchReg(PHONE_REG, value);
    }

    public static boolean isMail(String value) {
        return StringUtil.matchReg(EMAIL_REG, value);
    }

    public static boolean isIp4(String value) {
        return StringUtil.matchReg(IP_REG, value);
    }

    public static boolean isInnerIp4(String value) {
        return StringUtil.matchReg(IP_INNER_REG, value);
    }

    public static boolean matchReg(String value, String reg) {
        Pattern p = Pattern.compile(reg);
        return StringUtil.matchReg(p, value);
    }

    public static boolean matchReg(Pattern p, String target) {
        Matcher m = p.matcher(target);
        return m.matches();
    }

    public static String toJSONWithClassInfo(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullNumberAsZero});
    }

    public static String toJSON(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONString((Object)obj);
    }

    public static <T> T toObject(String text, Class<T> clazz) {
        if (text == null) {
            return null;
        }
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static <T> List<T> toArray(String text, Class<T> clazz) {
        if (text == null) {
            return new ArrayList();
        }
        return JSON.parseArray((String)text, clazz);
    }

    public static <T> String toCommaList(List<T> list) {
        if (list == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (T obj : list) {
            buffer.append(obj.toString()).append(',');
        }
        if (buffer.length() > 0) {
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static List<String> fromCommaString(String value) {
        String[] split;
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return result;
        }
        for (String temp : split = value.split(",")) {
            result.add(temp);
        }
        return result;
    }

    public static String toShortStr(double num) {
        if (num < 100000.0) {
            return String.format("%.2f", num) + "";
        }
        if (num < 1000000.0) {
            return String.format("%.2f", num / 1000.0) + "K";
        }
        if (num < 1.0E9) {
            return String.format("%.2f", num / 1000000.0) + "M";
        }
        if (num < 1.0E12) {
            return String.format("%.2f", num / 1.0E9) + "B";
        }
        if (num < 1.0E15) {
            return String.format("%.2f", num / 1.0E12) + "T";
        }
        return String.format("%.2f", num / 1.0E15) + "P";
    }
}

