/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.limitart.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeUtil {
    private static final Logger log = LoggerFactory.getLogger(TimeUtil.class);
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final String ONE_SECOND_AGO = "\u79d2\u524d";
    private static final String ONE_MINUTE_AGO = "\u5206\u949f\u524d";
    private static final String ONE_HOUR_AGO = "\u5c0f\u65f6\u524d";
    private static final String ONE_DAY_AGO = "\u5929\u524d";
    private static final String ONE_MONTH_AGO = "\u6708\u524d";
    private static final String ONE_YEAR_AGO = "\u5e74\u524d";

    private TimeUtil() {
    }

    public static String date2ShortStr(long time) {
        long delta = Math.max(System.currentTimeMillis() - time, 0L);
        if (delta < 60000L) {
            long seconds = TimeUtil.toSeconds(delta);
            return (seconds <= 0L ? 1L : seconds) + ONE_SECOND_AGO;
        }
        if (delta < 2700000L) {
            long minutes = TimeUtil.toMinutes(delta);
            return (minutes <= 0L ? 1L : minutes) + ONE_MINUTE_AGO;
        }
        if (delta < 86400000L) {
            long hours = TimeUtil.toHours(delta);
            return (hours <= 0L ? 1L : hours) + ONE_HOUR_AGO;
        }
        if (delta < 172800000L) {
            return "\u6628\u5929";
        }
        if (delta < 2592000000L) {
            long days = TimeUtil.toDays(delta);
            return (days <= 0L ? 1L : days) + ONE_DAY_AGO;
        }
        if (delta < 29030400000L) {
            long months = TimeUtil.toMonths(delta);
            return (months <= 0L ? 1L : months) + ONE_MONTH_AGO;
        }
        long years = TimeUtil.toYears(delta);
        return (years <= 0L ? 1L : years) + ONE_YEAR_AGO;
    }

    public static long toSeconds(long date) {
        return date / 1000L;
    }

    public static long toMinutes(long date) {
        return TimeUtil.toSeconds(date) / 60L;
    }

    public static long toHours(long date) {
        return TimeUtil.toMinutes(date) / 60L;
    }

    public static long toDays(long date) {
        return TimeUtil.toHours(date) / 24L;
    }

    public static long toMonths(long date) {
        return TimeUtil.toDays(date) / 30L;
    }

    public static long toYears(long date) {
        return TimeUtil.toMonths(date) / 365L;
    }

    public static boolean isSameDay(long time) {
        Calendar nowCal = Calendar.getInstance();
        Calendar herCal = Calendar.getInstance();
        herCal.setTimeInMillis(time);
        int nowYear = nowCal.get(1);
        int nowMonth = nowCal.get(2);
        int nowDay = nowCal.get(5);
        int herYear = herCal.get(1);
        int herMonth = herCal.get(2);
        int herDay = herCal.get(5);
        return nowYear == herYear && nowMonth == herMonth && nowDay == herDay;
    }

    public static boolean isSameMonth(long time) {
        Calendar nowCal = Calendar.getInstance();
        Calendar herCal = Calendar.getInstance();
        herCal.setTimeInMillis(time);
        int nowYear = nowCal.get(1);
        int nowMonth = nowCal.get(2);
        int herYear = herCal.get(1);
        int herMonth = herCal.get(2);
        return nowYear == herYear && nowMonth == herMonth;
    }

    public static boolean isSameYear(long time) {
        Calendar nowCal = Calendar.getInstance();
        Calendar herCal = Calendar.getInstance();
        herCal.setTimeInMillis(time);
        int nowYear = nowCal.get(1);
        int herYear = herCal.get(1);
        return nowYear == herYear;
    }

    public static long str2Date(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.SIMPLIFIED_CHINESE);
        Date parse = null;
        try {
            parse = format.parse(str);
        }
        catch (ParseException e) {
            log.error("parse error", (Throwable)e);
            return 0L;
        }
        return parse.getTime();
    }

    public static String date2Str(long date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.SIMPLIFIED_CHINESE);
        Date temp = new Date(date);
        String format2 = format.format(temp);
        return format2;
    }

    public long getZeroStamp(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long getUTCTime() {
        Calendar cal = Calendar.getInstance();
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        return cal.getTimeInMillis();
    }
}

