/*
 * Copyright (c) 2016-present The Recorder Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.slingerxv.recorder;

/**
 * 日志滚动类型
 * 
 * @author hank
 *
 */
public enum RollType {
	/**
	 * 日表
	 */
	DAY_ROLL(1),
	/**
	 * 月表
	 */
	MONTH_ROLL(2),
	/**
	 * 年表
	 */
	YEAR_ROLL(3),
	/**
	 * 固定
	 */
	NEVER_ROLL(4);
	private int value;

	RollType(int value) {
		this.value = value;
	}

	public int getValue() {
		return this.value;
	}
}
