/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.recorder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.recorder.Col;
import org.slingerxv.recorder.ColumnInfo;
import org.slingerxv.recorder.IRecorder;
import org.slingerxv.recorder.RecorderCheckException;
import org.slingerxv.recorder.RecorderUtil;
import org.slingerxv.recorder.ReflectionUtil;
import org.slingerxv.recorder.TableInfo;

public class RecorderChecker {
    private static final Logger log = LoggerFactory.getLogger(RecorderChecker.class);
    private HashMap<String, Class<? extends IRecorder>> tables = new HashMap();

    public void clearTables() {
        this.tables.clear();
    }

    public void registTable(Class<? extends IRecorder> bean) throws RecorderCheckException {
        String lowerCase = bean.getSimpleName().toLowerCase();
        if (this.tables.containsKey(lowerCase)) {
            throw new RecorderCheckException("table name: " + lowerCase + " duplicated!");
        }
        this.tables.put(lowerCase, bean);
    }

    public void registTable(String packageName) throws RecorderCheckException, ClassNotFoundException, IOException {
        List<Object> classes = new ArrayList();
        classes = ReflectionUtil.getClassesByPackage(packageName, IRecorder.class);
        log.debug("package\uff1a{}\uff0cscan classes\uff1a{}\u3002", (Object)packageName, (Object)classes.size());
        for (Class clazz : classes) {
            this.registTable(clazz);
        }
    }

    public void executeCheck(Connection con) throws SQLException, RecorderCheckException {
        log.info("start check all recorders...");
        for (Class<? extends IRecorder> clss : this.tables.values()) {
            this.executeCheck(con, clss);
        }
        log.info("check all recorders done\u3002");
    }

    private void executeCheck(Connection con, Class<? extends IRecorder> clss) throws SQLException, RecorderCheckException {
        if (Modifier.isAbstract(clss.getModifiers())) {
            return;
        }
        List<String> tableNames = RecorderUtil.getTableNames(con);
        for (String logTableName : tableNames) {
            Object object;
            if (!logTableName.startsWith(clss.getSimpleName().toLowerCase())) continue;
            log.info("start check\uff1a" + logTableName);
            TableInfo columnDefine = RecorderUtil.getColumnDefine(con, logTableName);
            ArrayList<ColumnInfo> increaseList = new ArrayList<ColumnInfo>();
            ArrayList<String> decreaseList = new ArrayList<String>();
            ArrayList<ColumnInfo> modifyList = new ArrayList<ColumnInfo>();
            List<Field> logFields = RecorderUtil.getLogFields(clss);
            for (Field field : logFields) {
                Col annotation = field.getAnnotation(Col.class);
                if (annotation == null) continue;
                if (!Modifier.isPublic(field.getModifiers())) {
                    throw new RecorderCheckException("recorder's field\uff1a" + field.getName() + " must be public!");
                }
                String tableFieldName = field.getName();
                ColumnInfo info = new ColumnInfo();
                info.setTableFieldName(tableFieldName);
                info.setType(annotation.type());
                info.setSize(annotation.size());
                info.setComment(annotation.comment());
                if (!columnDefine.getColumnInfos().containsKey(tableFieldName)) {
                    increaseList.add(info);
                    continue;
                }
                ColumnInfo source = columnDefine.getColumnInfos().get(tableFieldName);
                if (RecorderUtil.isSame(info, source)) continue;
                if (RecorderUtil.ableChange(info, source)) {
                    modifyList.add(info);
                    continue;
                }
                throw new RecorderCheckException("unable to change column,table\uff1a" + logTableName + ",new:" + info + ",old:" + source);
            }
            for (ColumnInfo info : columnDefine.getColumnInfos().values()) {
                if (columnDefine.getPrimaryKeys().contains(info.getTableFieldName())) continue;
                boolean contains = false;
                for (Field field : logFields) {
                    if (field.getAnnotation(Col.class) == null || !field.getName().equals(info.getTableFieldName())) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                decreaseList.add(info.getTableFieldName());
            }
            for (ColumnInfo col : increaseList) {
                try {
                    PreparedStatement prepareStatement = con.prepareStatement(RecorderUtil.buildColumnIncreaseSqlMYSQL(logTableName, col.getTableFieldName(), col.getType(), col.getSize(), col.getComment()));
                    object = null;
                    try {
                        if (prepareStatement.executeUpdate() == 0) {
                            log.error("add column failed\uff0clogger:" + logTableName + "-----column:" + col.getTableFieldName() + " " + (Object)((Object)col.getType()) + " " + col.getSize());
                            continue;
                        }
                        log.info("add column success\uff0clogger:" + logTableName + "-----column:" + col.getTableFieldName() + " " + (Object)((Object)col.getType()) + " " + col.getSize());
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (prepareStatement == null) continue;
                        if (object != null) {
                            try {
                                prepareStatement.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        prepareStatement.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            for (String colName : decreaseList) {
                try {
                    PreparedStatement prepareStatement = con.prepareStatement(RecorderUtil.buildColumnDecreaseSqlMYSQL(logTableName, colName));
                    object = null;
                    try {
                        if (prepareStatement.executeUpdate() == 0) {
                            log.error("delete column failed\uff0clogger:" + logTableName + "-----column:" + colName);
                            continue;
                        }
                        log.info("delete column success\uff0clogger:" + logTableName + "-----column:" + colName);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (prepareStatement == null) continue;
                        if (object != null) {
                            try {
                                prepareStatement.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        prepareStatement.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            for (ColumnInfo col : modifyList) {
                try {
                    PreparedStatement prepareStatement = con.prepareStatement(RecorderUtil.buildColumnModifySqlMYSQL(logTableName, col.getTableFieldName(), col.getType(), col.getSize(), col.getComment()));
                    object = null;
                    try {
                        if (prepareStatement.executeUpdate() == 0) {
                            log.error("change column failed,logger:" + logTableName + "-----column:" + col.getTableFieldName() + " " + (Object)((Object)col.getType()) + " " + col.getSize());
                            continue;
                        }
                        log.info("change column success,logger:" + logTableName + "-----column:" + col.getTableFieldName() + " " + (Object)((Object)col.getType()) + " " + col.getSize());
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (prepareStatement == null) continue;
                        if (object != null) {
                            try {
                                prepareStatement.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        prepareStatement.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            log.info("check recorder logger:" + logTableName + "done\uff01");
        }
    }

    public Class<? extends IRecorder> getTableClass(String tableName) {
        return this.tables.get(tableName);
    }
}

