/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.recorder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.recorder.Col;
import org.slingerxv.recorder.IRecorder;
import org.slingerxv.recorder.RecorderCheckException;
import org.slingerxv.recorder.RecorderChecker;
import org.slingerxv.recorder.RecorderProxyStateException;
import org.slingerxv.recorder.RecorderQueryBuilder;
import org.slingerxv.recorder.RecorderQueryBuilderException;
import org.slingerxv.recorder.RecorderTaskOverloadException;
import org.slingerxv.recorder.RecorderUtil;

public class RecorderProxy {
    private static Logger log = LoggerFactory.getLogger(RecorderProxy.class);
    private ThreadPoolExecutor threadPool;
    private BlockingQueue<Runnable> logTaskQueue;
    private final RecorderChecker checker = new RecorderChecker();
    private boolean isStop = true;
    private final LongAdder doneLogNum = new LongAdder();
    private final LongAdder lostLogNum = new LongAdder();
    private String[] scanPackages;
    private final int threadCorePoolSize;
    private final int threadMaximumPoolSize;
    private final int taskMaxSize;
    private final String dbEngine;
    private final String charset;
    private final ThreadPoolExecutor customInsertThreadPool;
    private final Supplier<DataSource> dataSourceFactory;

    private RecorderProxy(RecorderProxyBuilder builder) {
        this.scanPackages = builder.scanPackages.toArray(new String[0]);
        this.taskMaxSize = builder.taskMaxSize;
        this.threadCorePoolSize = builder.threadCorePoolSize;
        this.threadMaximumPoolSize = builder.threadMaximumPoolSize;
        this.dbEngine = builder.dbEngine;
        this.charset = builder.charset;
        this.customInsertThreadPool = builder.customInsertThreadPool;
        this.dataSourceFactory = Objects.requireNonNull(builder.dataSourceFactory, "dataSourceFactory");
    }

    public RecorderProxy execute(IRecorder alog) throws RecorderProxyStateException, RecorderTaskOverloadException {
        if (this.isStop) {
            throw new RecorderProxyStateException("stop");
        }
        if (alog != null) {
            if (this.getTaksCount() > (long)this.taskMaxSize) {
                this.lostLogNum.increment();
                throw new RecorderTaskOverloadException("task count is overload,drop task:" + alog);
            }
            this.threadPool.execute(() -> {
                try (Connection con = this.dataSourceFactory.get().getConnection();){
                    block64: {
                        long now = System.currentTimeMillis();
                        String buildExistTableSql_MYSQL = RecorderUtil.buildExistTableSqlMYSQL(RecorderUtil.getLogTableName(alog, now));
                        try (PreparedStatement existStatement = con.prepareStatement(buildExistTableSql_MYSQL);
                             ResultSet executeQuery = existStatement.executeQuery();){
                            if (executeQuery.next()) break block64;
                            String buildCreateTableSql = RecorderUtil.buildCreateTableSqlMYSQL(alog, this.dbEngine, this.charset);
                            try (PreparedStatement createStatement = con.prepareStatement(buildCreateTableSql);){
                                createStatement.executeUpdate();
                            }
                        }
                    }
                    String buildInsertTableSql = RecorderUtil.buildInsertTableSqlMYSQL(alog);
                    try (PreparedStatement insertStatement = con.prepareStatement(buildInsertTableSql);){
                        if (insertStatement.executeUpdate() > 0) {
                            this.doneLogNum.increment();
                        } else {
                            log.error("log failed:" + alog);
                            this.lostLogNum.increment();
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("log failed:" + alog);
                    this.lostLogNum.increment();
                }
            });
        }
        return this;
    }

    public Class<? extends IRecorder> getTableClassByName(String tableName) {
        return this.checker.getTableClass(tableName);
    }

    public int queryCount(String tableName, RecorderQueryBuilder builder) throws RecorderProxyStateException, RecorderQueryBuilderException, SQLException {
        Class<? extends IRecorder> tableClass = this.getTableClassByName(tableName);
        if (tableClass == null) {
            return 0;
        }
        return this.queryCount(tableClass, builder);
    }

    /*
     * Exception decompiling
     */
    public int queryCount(Class<? extends IRecorder> clss, RecorderQueryBuilder builder) throws RecorderProxyStateException, RecorderQueryBuilderException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection<String> queryRelativeTables(Class<? extends IRecorder> clss, long startTime, long endTime) throws InstantiationException, IllegalAccessException, SQLException {
        Set<String> relativeTableNames = RecorderUtil.getRelativeTableNames(clss, startTime, endTime);
        Iterator<String> iterator2 = relativeTableNames.iterator();
        try (Connection connection = this.dataSourceFactory.get().getConnection();){
            List<String> tableNames = RecorderUtil.getTableNames(connection);
            while (iterator2.hasNext()) {
                if (tableNames.contains(iterator2.next())) continue;
                iterator2.remove();
            }
        }
        return relativeTableNames;
    }

    public <T extends IRecorder> List<T> query(String tableName, RecorderQueryBuilder builder) throws InstantiationException, IllegalAccessException, RecorderProxyStateException, RecorderQueryBuilderException, SQLException {
        Class<? extends IRecorder> tableClass = this.getTableClassByName(tableName);
        if (tableClass == null) {
            return null;
        }
        return this.query(tableClass, builder);
    }

    public <T extends IRecorder> List<T> query(Class<T> clss, RecorderQueryBuilder builder) throws RecorderProxyStateException, RecorderQueryBuilderException, SQLException, InstantiationException, IllegalAccessException {
        if (this.isStop) {
            throw new RecorderProxyStateException("stop");
        }
        ArrayList<IRecorder> result = new ArrayList<IRecorder>();
        String buildSelectTableSql = RecorderUtil.buildSelectTableSqlMYSQL(builder);
        try (Connection connection = this.dataSourceFactory.get().getConnection();
             PreparedStatement prepareStatement = connection.prepareStatement(buildSelectTableSql);
             ResultSet executeQuery = prepareStatement.executeQuery();){
            while (executeQuery.next()) {
                IRecorder newInstance = (IRecorder)clss.newInstance();
                List<Field> logFields = RecorderUtil.getLogFields(clss);
                for (Field field : logFields) {
                    Object object;
                    Col annotation = field.getAnnotation(Col.class);
                    if (annotation == null || (object = executeQuery.getObject(field.getName())) == null) continue;
                    field.set(newInstance, object);
                }
                result.add(newInstance);
            }
        }
        return result;
    }

    public long getTaksCount() {
        return this.logTaskQueue.size();
    }

    public long getDoneLogNum() {
        return this.doneLogNum.longValue();
    }

    public long getLostLogNum() {
        return this.lostLogNum.longValue();
    }

    public RecorderProxy startServer() throws RecorderProxyStateException, RecorderCheckException, SQLException, ClassNotFoundException, IOException {
        if (!this.isStop) {
            throw new RecorderProxyStateException("stop");
        }
        if (this.customInsertThreadPool == null) {
            this.logTaskQueue = new LinkedBlockingQueue<Runnable>();
            this.threadPool = new ThreadPoolExecutor(this.threadCorePoolSize, this.threadMaximumPoolSize, 0L, TimeUnit.MILLISECONDS, this.logTaskQueue, runnable -> {
                Thread t = new Thread(runnable, "RecorderProxy-Insert-" + this.threadPool.getPoolSize());
                return t;
            });
        } else {
            this.logTaskQueue = this.customInsertThreadPool.getQueue();
            this.threadPool = this.customInsertThreadPool;
        }
        if (this.checker != null) {
            if (this.scanPackages != null && this.scanPackages.length > 0) {
                for (String packageName : this.scanPackages) {
                    this.checker.registTable(packageName);
                }
            }
            try (Connection connection = this.dataSourceFactory.get().getConnection();){
                this.checker.executeCheck(connection);
            }
        }
        this.isStop = false;
        return this;
    }

    public RecorderProxy stopServer() throws RecorderProxyStateException {
        if (this.isStop) {
            throw new RecorderProxyStateException("stop");
        }
        this.isStop = true;
        List<Runnable> shutdownNow = this.threadPool.shutdownNow();
        for (Runnable task : shutdownNow) {
            try {
                task.run();
                log.info("save log tasks,remain:" + shutdownNow.size());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        shutdownNow.clear();
        log.info("db log system shutdone!");
        return this;
    }

    public static class RecorderProxyBuilder {
        private Set<String> scanPackages = new HashSet<String>();
        private int taskMaxSize = 8000;
        private int threadCorePoolSize = 3;
        private int threadMaximumPoolSize = 5;
        private String dbEngine = "myisam";
        private String charset = "utf8";
        private ThreadPoolExecutor customInsertThreadPool;
        private Supplier<DataSource> dataSourceFactory;

        public RecorderProxy build() {
            return new RecorderProxy(this);
        }

        public RecorderProxyBuilder addScanPackage(String ... packageNames) {
            for (String temp : Objects.requireNonNull(packageNames, "packageNames")) {
                this.scanPackages.add(Objects.requireNonNull(temp, "packageName"));
            }
            return this;
        }

        public RecorderProxyBuilder taskMaxSize(int size) {
            if (size > 0) {
                this.taskMaxSize = size;
            }
            return this;
        }

        public RecorderProxyBuilder threadCorePoolSize(int size) {
            if (size > 0) {
                this.threadCorePoolSize = size;
            }
            return this;
        }

        public RecorderProxyBuilder threadMaximumPoolSize(int size) {
            if (size > 0) {
                this.threadMaximumPoolSize = size;
            }
            return this;
        }

        public RecorderProxyBuilder dbEngine(String dbEngine) {
            this.dbEngine = Objects.requireNonNull(dbEngine, "dbEngine");
            return this;
        }

        public RecorderProxyBuilder charset(String charset) {
            this.charset = Objects.requireNonNull(charset, "charset");
            return this;
        }

        public RecorderProxyBuilder customInsertThreadPool(ThreadPoolExecutor threadPool) {
            this.customInsertThreadPool = Objects.requireNonNull(threadPool, "threadPool");
            return this;
        }

        public RecorderProxyBuilder dataSource(Supplier<DataSource> dataSourceFactory) {
            this.dataSourceFactory = Objects.requireNonNull(dataSourceFactory, "dataSourceFactory");
            return this;
        }
    }
}

