/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.recorder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slingerxv.recorder.RecorderQueryBuilderException;

public class RecorderQueryBuilder {
    private StringBuilder selections = new StringBuilder();
    private StringBuilder tableNames = new StringBuilder();
    private String where;
    private StringBuilder orderBySb = new StringBuilder();
    private StringBuilder groupBySb = new StringBuilder();
    private String limit;
    private List<RecorderQueryBuilder> unions = new ArrayList<RecorderQueryBuilder>();

    public RecorderQueryBuilder unionAll(RecorderQueryBuilder builder) throws Exception {
        if (builder.hashCode() == this.hashCode()) {
            throw new RecorderQueryBuilderException("can not add self!");
        }
        this.unions.add(builder);
        return this;
    }

    public RecorderQueryBuilder select(String value) {
        this.selections.append(Objects.requireNonNull(value)).append(",");
        return this;
    }

    public RecorderQueryBuilder tables(Collection<String> tables) {
        for (String tb : Objects.requireNonNull(tables)) {
            this.tableNames.append(tb).append(",");
        }
        return this;
    }

    public RecorderQueryBuilder tables(RecorderQueryBuilder table) throws Exception {
        if (table.hashCode() == this.hashCode()) {
            throw new RecorderQueryBuilderException("can not add self!");
        }
        this.tableNames.append("(" + table.build() + ") as atlas_" + Integer.toHexString(table.hashCode())).append(",");
        return this;
    }

    public RecorderQueryBuilder tables(String ... tables) {
        for (String table : Objects.requireNonNull(tables)) {
            this.tableNames.append(Objects.requireNonNull(table)).append(",");
        }
        return this;
    }

    public RecorderQueryBuilder where(WhereConditionBuilder condition) throws Exception {
        this.where = condition.build();
        return this;
    }

    public RecorderQueryBuilder limit(int start, int size) {
        this.limit = "limit " + start + "," + size;
        return this;
    }

    public RecorderQueryBuilder orderBy(String fieldName, boolean desc) {
        this.orderBySb.append(Objects.requireNonNull(fieldName)).append(desc ? " desc" : " asc").append(",");
        return this;
    }

    public RecorderQueryBuilder groupBy(String fieldName) {
        this.groupBySb.append(Objects.requireNonNull(fieldName)).append(",");
        return this;
    }

    public String build() throws RecorderQueryBuilderException {
        String source = "select {0} from {1} {2} {3} {4} {5}";
        if (this.selections.length() == 0) {
            throw new RecorderQueryBuilderException("no selection item!");
        }
        StringBuilder selectionsCopy = new StringBuilder(this.selections.toString());
        selectionsCopy.deleteCharAt(selectionsCopy.length() - 1);
        if (this.tableNames.length() == 0) {
            throw new RecorderQueryBuilderException("no table item!");
        }
        StringBuilder tableNamesCopy = new StringBuilder(this.tableNames.toString());
        tableNamesCopy.deleteCharAt(tableNamesCopy.length() - 1);
        StringBuilder groupBySbCopy = new StringBuilder(this.groupBySb.toString());
        if (this.groupBySb.length() != 0) {
            groupBySbCopy.deleteCharAt(groupBySbCopy.length() - 1);
        }
        StringBuilder orderBySbCopy = new StringBuilder(this.orderBySb.toString());
        if (this.orderBySb.length() != 0) {
            orderBySbCopy.deleteCharAt(orderBySbCopy.length() - 1);
        }
        String format = MessageFormat.format(source, selectionsCopy.toString(), tableNamesCopy.toString(), this.where == null ? "" : "where " + this.where, groupBySbCopy.length() == 0 ? "" : "group by" + groupBySbCopy.toString(), orderBySbCopy.length() == 0 ? "" : "order by " + orderBySbCopy.toString(), this.limit == null ? "" : this.limit);
        if (!this.unions.isEmpty()) {
            for (RecorderQueryBuilder temp : this.unions) {
                format = format + " union all " + temp.build();
            }
        }
        return format;
    }

    public static final class WhereConditionBuilder {
        private StringBuilder sb = new StringBuilder();
        private int qouteSignal = 0;
        private int contactSignal = 0;

        public WhereConditionBuilder qouteStart() {
            this.sb.append("(");
            ++this.qouteSignal;
            return this;
        }

        public WhereConditionBuilder qouteEnd() {
            this.sb.append(")");
            --this.qouteSignal;
            return this;
        }

        public WhereConditionBuilder and() throws Exception {
            if (this.contactSignal != 0) {
                throw new RecorderQueryBuilderException("there is more contact exists!");
            }
            this.sb.append(" and ");
            ++this.contactSignal;
            return this;
        }

        public WhereConditionBuilder or() throws Exception {
            if (this.contactSignal != 0) {
                throw new RecorderQueryBuilderException("there is more contact exists!");
            }
            this.sb.append(" or ");
            ++this.contactSignal;
            return this;
        }

        public WhereConditionBuilder lt(String fieldName, Object value, boolean isClosure) {
            this.sb.append(Objects.requireNonNull(fieldName)).append(" <").append(isClosure ? "= " : " ").append(Objects.requireNonNull(value).toString());
            if (this.contactSignal > 0) {
                --this.contactSignal;
            }
            return this;
        }

        public WhereConditionBuilder gt(String fieldName, Object value, boolean isClosure) {
            this.sb.append(Objects.requireNonNull(fieldName)).append(" >").append(isClosure ? "= " : " ").append(Objects.requireNonNull(value).toString());
            if (this.contactSignal > 0) {
                --this.contactSignal;
            }
            return this;
        }

        public WhereConditionBuilder eq(String fieldName, Object value) {
            this.sb.append(Objects.requireNonNull(fieldName)).append(" = ").append(Objects.requireNonNull(value).toString());
            if (this.contactSignal > 0) {
                --this.contactSignal;
            }
            return this;
        }

        public WhereConditionBuilder notEq(String fieldName, Object value) {
            this.sb.append(Objects.requireNonNull(fieldName)).append(" != ").append(Objects.requireNonNull(value).toString());
            if (this.contactSignal > 0) {
                --this.contactSignal;
            }
            return this;
        }

        public WhereConditionBuilder like(String fieldName, Object value, boolean left, boolean right) {
            this.sb.append(Objects.requireNonNull(fieldName)).append(" like '").append(left ? "%" : "").append(value == null ? "" : value.toString()).append(right ? "%" : "").append("'");
            if (this.contactSignal > 0) {
                --this.contactSignal;
            }
            return this;
        }

        private String build() throws Exception {
            if (this.qouteSignal != 0) {
                throw new RecorderQueryBuilderException("qoute count error," + this.qouteSignal);
            }
            if (this.contactSignal != 0) {
                throw new RecorderQueryBuilderException("contant count error," + this.qouteSignal);
            }
            if (this.sb.length() == 0) {
                return "";
            }
            return this.sb.toString();
        }
    }
}

