/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.recorder;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.recorder.Col;
import org.slingerxv.recorder.ColumnInfo;
import org.slingerxv.recorder.IRecorder;
import org.slingerxv.recorder.RecorderQueryBuilder;
import org.slingerxv.recorder.RecorderQueryBuilderException;
import org.slingerxv.recorder.ReflectionUtil;
import org.slingerxv.recorder.RollType;
import org.slingerxv.recorder.SQLType;
import org.slingerxv.recorder.TableInfo;

public class RecorderUtil {
    private static Logger log = LoggerFactory.getLogger(RecorderUtil.class);
    private static final String PRIMARY_KEY = "`pk_id`";
    private static ConcurrentHashMap<Class<? extends IRecorder>, List<Field>> logFieldCache = new ConcurrentHashMap();
    private static Map<SQLType, Set<SQLType>> CHANGE_ALLOW_MAP = new HashMap<SQLType, Set<SQLType>>();

    private RecorderUtil() {
    }

    public static String buildExistTableSqlMYSQL(String tableName) {
        String sql = "SHOW TABLES  LIKE '" + tableName + "'";
        log.debug(sql);
        return sql;
    }

    public static String buildSelectCountTableSqlMYSQL(RecorderQueryBuilder builder) throws RecorderQueryBuilderException {
        String build = builder.build();
        log.debug(build);
        return build;
    }

    public static String buildSelectTableSqlMYSQL(RecorderQueryBuilder builder) throws RecorderQueryBuilderException {
        String build = builder.build();
        log.debug(build);
        return build;
    }

    public static String buildCreateTableSqlMYSQL(IRecorder alog, String dbEngine, String charset) throws UnsupportedEncodingException {
        StringBuilder createTableBuffer = new StringBuilder();
        String tableName = RecorderUtil.getLogTableName(alog, System.currentTimeMillis());
        List<Field> fieldAccessV2 = RecorderUtil.getLogFields(alog.getClass());
        createTableBuffer.append("create table if not exists ").append(tableName).append(" (").append(RecorderUtil.line());
        createTableBuffer.append("`pk_id` int primary key not null auto_increment");
        for (Field field : fieldAccessV2) {
            Col annotation = field.getAnnotation(Col.class);
            if (annotation == null) continue;
            SQLType type = annotation.type();
            int size = annotation.size();
            if (type == SQLType.VARCHAR && size <= 0) {
                size = 255;
            }
            String sizeStr = size > 0 ? "(" + size + ")" : "";
            String comment = annotation.comment();
            String tableFieldName = "`" + field.getName() + "`";
            createTableBuffer.append(",").append(RecorderUtil.line()).append(tableFieldName).append(" ").append(type.name()).append(sizeStr).append(" null comment ").append("'").append(comment).append("'");
        }
        createTableBuffer.append(")");
        createTableBuffer.append("engine=" + dbEngine + " auto_increment=1 default charset=" + charset + " comment '").append(alog.getClass().getSimpleName()).append("'");
        String sql = createTableBuffer.toString();
        log.debug(sql);
        return sql;
    }

    public static TableInfo getColumnDefine(Connection conn, String tableName) throws SQLException {
        TableInfo tableInfo = new TableInfo();
        DatabaseMetaData metaData = conn.getMetaData();
        ResultSet columns = metaData.getColumns(null, "%", tableName, "%");
        ResultSet primaryKey = metaData.getPrimaryKeys(null, "%", tableName);
        while (primaryKey.next()) {
            tableInfo.getPrimaryKeys().add(primaryKey.getString(4));
        }
        while (columns.next()) {
            ColumnInfo info = new ColumnInfo();
            info.setTableFieldName(columns.getString("COLUMN_NAME"));
            info.setType(SQLType.valueOf(columns.getString("TYPE_NAME")));
            info.setSize(columns.getInt("COLUMN_SIZE"));
            info.setNullable(columns.getBoolean("IS_NULLABLE"));
            tableInfo.getColumnInfos().put(info.getTableFieldName(), info);
        }
        return tableInfo;
    }

    public static String buildInsertTableSqlMYSQL(IRecorder alog) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder fieldBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        String tableName = RecorderUtil.getLogTableName(alog, System.currentTimeMillis());
        List<Field> fieldAccessV2 = RecorderUtil.getLogFields(alog.getClass());
        for (Field field : fieldAccessV2) {
            fieldBuffer.append("`" + field.getName() + "`").append(",");
            valueBuffer.append("'" + field.get(alog) + "'").append(",");
        }
        fieldBuffer.deleteCharAt(fieldBuffer.length() - 1);
        valueBuffer.deleteCharAt(valueBuffer.length() - 1);
        StringBuilder insertTableBuffer = new StringBuilder();
        insertTableBuffer.append("insert into `").append(tableName).append("`(").append((CharSequence)fieldBuffer).append(") values (").append((CharSequence)valueBuffer).append(")");
        String sql = insertTableBuffer.toString();
        log.debug(sql);
        return sql;
    }

    public static String buildColumnIncreaseSqlMYSQL(String tableName, String fieldName, SQLType type, int size, String comment) {
        String sql = "alter table `" + tableName + "` add column `" + fieldName + "` " + type.name() + (size > 0 ? "(" + size + ")" : ("varchar".equalsIgnoreCase(type.name()) ? "(255)" : "")) + " comment '" + comment + "';";
        log.debug(sql);
        return sql;
    }

    public static String buildColumnDecreaseSqlMYSQL(String tableName, String fieldName) {
        String sql = "alter table `" + tableName + "` drop column `" + fieldName + "`;";
        log.debug(sql);
        return sql;
    }

    public static String buildColumnModifySqlMYSQL(String tableName, String fieldName, SQLType type, int size, String comment) {
        String sql = "alter table `" + tableName + "` modify column `" + fieldName + "` " + type.name() + (size > 0 ? "(" + size + ")" : ("varchar".equalsIgnoreCase(type.name()) ? "(255)" : "")) + " comment '" + comment + "';";
        log.debug(sql);
        return sql;
    }

    public static boolean isSame(ColumnInfo now, ColumnInfo old) {
        if ((now.getType().equals((Object)SQLType.INT) || now.getType().equals((Object)SQLType.INTEGER) || now.getType().name().startsWith(SQLType.INT.name())) && (old.getType().equals((Object)SQLType.INTEGER) || old.getType().equals((Object)SQLType.INT) || old.getType().name().startsWith(SQLType.INT.name()))) {
            return true;
        }
        if (now.getType().equals((Object)SQLType.BIGINT) && old.getType().equals((Object)now.getType())) {
            return true;
        }
        if (now.getType().equals((Object)SQLType.TEXT) && old.getType().equals((Object)now.getType())) {
            return true;
        }
        if (now.getType().equals((Object)SQLType.LONGTEXT) && old.getType().equals((Object)now.getType())) {
            return true;
        }
        if (now.getType().equals((Object)SQLType.BIT) && old.getType().equals((Object)now.getType())) {
            return true;
        }
        if (now.getType().equals((Object)SQLType.TINYINT) && old.getType().equals((Object)now.getType())) {
            return true;
        }
        return now.getType().equals((Object)old.getType()) && now.getSize() <= old.getSize();
    }

    public static boolean ableChange(ColumnInfo info, ColumnInfo info2) {
        Set<SQLType> set = CHANGE_ALLOW_MAP.get((Object)info.getType());
        if (set == null) {
            return false;
        }
        return set.contains((Object)info2.getType());
    }

    private static String line() {
        return System.getProperty("line.separator");
    }

    public static List<String[]> getLogHeader(Class<? extends IRecorder> clss) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        List<Field> fieldAccessV2 = RecorderUtil.getLogFields(clss);
        for (Field field : fieldAccessV2) {
            Col annotation = field.getAnnotation(Col.class);
            if (annotation == null) continue;
            String[] temp = new String[]{field.getName(), annotation.comment()};
            result.add(temp);
        }
        return result;
    }

    public static List<String> getTableNames(Connection conn) throws SQLException {
        ResultSet tableRet = conn.getMetaData().getTables(null, "%", "%", null);
        ArrayList<String> tablenames = new ArrayList<String>();
        while (tableRet.next()) {
            tablenames.add(tableRet.getString("TABLE_NAME"));
        }
        return tablenames;
    }

    public static String getLogTableName(IRecorder alog, long millTime) {
        RollType logRollType = alog.rollType();
        String tableName = alog.getClass().getSimpleName().toLowerCase();
        switch (logRollType) {
            case DAY_ROLL: {
                tableName = tableName + new SimpleDateFormat("yyyyMMdd").format(new Date(millTime));
                break;
            }
            case MONTH_ROLL: {
                tableName = tableName + new SimpleDateFormat("yyyyMM").format(new Date(millTime));
                break;
            }
            case YEAR_ROLL: {
                tableName = tableName + new SimpleDateFormat("yyyy").format(new Date(millTime));
                break;
            }
        }
        return tableName;
    }

    public static Set<String> getRelativeTableNames(Class<? extends IRecorder> alog, long start, long end) throws InstantiationException, IllegalAccessException {
        Calendar startCal = Calendar.getInstance(Locale.SIMPLIFIED_CHINESE);
        startCal.setTimeInMillis(start);
        startCal.set(5, 1);
        startCal.clear(11);
        startCal.clear(12);
        startCal.clear(13);
        startCal.clear(14);
        HashSet<String> result = new HashSet<String>();
        IRecorder newInstance = alog.newInstance();
        do {
            String logTableName = RecorderUtil.getLogTableName(newInstance, startCal.getTimeInMillis());
            RollType logRollType = newInstance.rollType();
            if (logRollType == RollType.DAY_ROLL) {
                if (startCal.getTimeInMillis() >= start) {
                    result.add(logTableName);
                }
                startCal.add(6, 1);
                continue;
            }
            if (logRollType == RollType.MONTH_ROLL) {
                result.add(logTableName);
                startCal.add(2, 1);
                continue;
            }
            if (logRollType == RollType.YEAR_ROLL) {
                result.add(logTableName);
                startCal.add(1, 1);
                continue;
            }
            if (logRollType != RollType.NEVER_ROLL) break;
            result.add(logTableName);
            break;
        } while (startCal.getTimeInMillis() <= end);
        return result;
    }

    public static List<Field> getLogFields(Class<? extends IRecorder> logClass) {
        if (logFieldCache.containsKey(logClass)) {
            return logFieldCache.get(logClass);
        }
        List<Field> fields = ReflectionUtil.getFields(logClass, true, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            return field.getAnnotation(Col.class) != null;
        });
        logFieldCache.put(logClass, fields);
        return fields;
    }

    static {
        HashSet<SQLType> bigintlist = new HashSet<SQLType>();
        CHANGE_ALLOW_MAP.put(SQLType.BIGINT, bigintlist);
        bigintlist.add(SQLType.VARCHAR);
        bigintlist.add(SQLType.LONGTEXT);
        bigintlist.add(SQLType.TEXT);
        bigintlist.add(SQLType.BIGINT);
        HashSet<SQLType> bitlist = new HashSet<SQLType>();
        CHANGE_ALLOW_MAP.put(SQLType.BIT, bitlist);
        bitlist.add(SQLType.LONGTEXT);
        bitlist.add(SQLType.VARCHAR);
        bitlist.add(SQLType.TEXT);
        bitlist.add(SQLType.BIGINT);
        bitlist.add(SQLType.INTEGER);
        bitlist.add(SQLType.INT);
        bitlist.add(SQLType.BIT);
        HashSet<SQLType> intlist = new HashSet<SQLType>();
        CHANGE_ALLOW_MAP.put(SQLType.INT, intlist);
        CHANGE_ALLOW_MAP.put(SQLType.INTEGER, intlist);
        intlist.add(SQLType.LONGTEXT);
        intlist.add(SQLType.VARCHAR);
        intlist.add(SQLType.TEXT);
        intlist.add(SQLType.BIGINT);
        intlist.add(SQLType.INTEGER);
        intlist.add(SQLType.INT);
        HashSet<SQLType> shortlist = new HashSet<SQLType>();
        CHANGE_ALLOW_MAP.put(SQLType.TINYINT, shortlist);
        shortlist.add(SQLType.LONGTEXT);
        shortlist.add(SQLType.VARCHAR);
        shortlist.add(SQLType.TEXT);
        shortlist.add(SQLType.BIGINT);
        shortlist.add(SQLType.INT);
        shortlist.add(SQLType.INTEGER);
        shortlist.add(SQLType.TINYINT);
        HashSet<SQLType> varcharlist = new HashSet<SQLType>();
        varcharlist.add(SQLType.LONGTEXT);
        varcharlist.add(SQLType.VARCHAR);
        varcharlist.add(SQLType.TEXT);
        varcharlist.add(SQLType.INT);
        varcharlist.add(SQLType.BIGINT);
        CHANGE_ALLOW_MAP.put(SQLType.VARCHAR, varcharlist);
        HashSet<SQLType> text = new HashSet<SQLType>();
        CHANGE_ALLOW_MAP.put(SQLType.TEXT, text);
        text.add(SQLType.LONGTEXT);
        text.add(SQLType.TEXT);
        text.add(SQLType.VARCHAR);
        HashSet<SQLType> longtextlist = new HashSet<SQLType>();
        CHANGE_ALLOW_MAP.put(SQLType.LONGTEXT, longtextlist);
        longtextlist.add(SQLType.LONGTEXT);
    }
}

