/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.recorder;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static List<Field> getFields(Class<?> clazz, boolean isSuper) {
        return ReflectionUtil.getFields(clazz, isSuper, field -> !Modifier.isStatic(field.getModifiers()));
    }

    public static List<Field> getFields(Class<?> clazz, boolean isSuper, Function<Field, Boolean> filter) {
        ArrayList<Field> list = new ArrayList<Field>();
        Class<?> nextClass = clazz;
        do {
            Field[] declaredFields;
            for (Field field : declaredFields = nextClass.getDeclaredFields()) {
                if (!filter.apply(field).booleanValue()) continue;
                list.add(field);
            }
        } while ((nextClass = nextClass.getSuperclass()) != Object.class && isSuper);
        return list;
    }

    public static List<Class<?>> getClassesByPackage(String packageName, Class<?> superClass) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                ReflectionUtil.findAndAddClassesInPackageByFile(packageName, filePath, true, classes, superClass);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName)) continue;
                int idx = name.lastIndexOf(47);
                if (idx != -1) {
                    packageName = name.substring(0, idx).replace('/', '.');
                }
                if (!name.endsWith(".class") || entry.isDirectory()) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                Class<?> loadClass = Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className);
                if (!superClass.isAssignableFrom(loadClass) || superClass.equals(loadClass)) continue;
                classes.add(loadClass);
            }
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, boolean recursive, List<Class<?>> classes, Class<?> superClass) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"));
        if (dirfiles == null) {
            return;
        }
        for (File file2 : dirfiles) {
            if (file2.isDirectory()) {
                ReflectionUtil.findAndAddClassesInPackageByFile(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, classes, superClass);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            Class<?> loadClass = null;
            try {
                loadClass = Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!superClass.isAssignableFrom(loadClass) || superClass.equals(loadClass)) continue;
            classes.add(loadClass);
        }
    }
}

