/*
 * Decompiled with CFR 0.152.
 */
package org.slingerxv.recorder;

import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slingerxv.recorder.ColumnInfo;
import org.slingerxv.recorder.FieldCheck;
import org.slingerxv.recorder.RecorderUtil;
import org.slingerxv.recorder.ReflectionUtil;
import org.slingerxv.recorder.TableCheck;
import org.slingerxv.recorder.TableCheckException;
import org.slingerxv.recorder.TableInfo;

public class TableChecker {
    private static Logger log = LoggerFactory.getLogger(TableChecker.class);
    private ConcurrentHashMap<String, Class<?>> tables = new ConcurrentHashMap();

    public TableCheckResult checkTables(Connection con, boolean checkBeanSuperClass) throws SQLException {
        TableCheckResult result = new TableCheckResult();
        StringBuilder sb = new StringBuilder();
        String line = System.getProperty("line.separator");
        sb.append(line);
        List<String> sqlTableNames = RecorderUtil.getTableNames(con);
        for (Map.Entry<String, Class<?>> entry : this.tables.entrySet()) {
            String tableName = entry.getKey();
            log.info("\u68c0\u6d4b\u8868\uff1a" + tableName);
            Class<?> bean = entry.getValue();
            if (!sqlTableNames.contains(tableName)) {
                sb.append(tableName + "[" + bean.getSimpleName() + "]" + "\uff1a\u8868\u7f3a\u5931\uff01").append(line);
                result.error = true;
                continue;
            }
            TableInfo columnDefine = RecorderUtil.getColumnDefine(con, tableName);
            List<Field> fields = ReflectionUtil.getFields(bean, checkBeanSuperClass);
            for (Field field : fields) {
                FieldCheck annotation = field.getAnnotation(FieldCheck.class);
                if (annotation == null) {
                    if (!columnDefine.getColumnInfos().containsKey(field.getName())) continue;
                    this.appendError(result, sb, "\u8868\uff1a" + tableName + "[" + bean.getSimpleName() + "]" + "\uff0c\u5b57\u6bb5\uff1a" + field.getName() + ",\u5b57\u6bb5\u672a\u8bbe\u7f6e\u68c0\u67e5\u6807\u8bb0");
                    continue;
                }
                String col = annotation.value();
                if (col == null || col.trim().length() == 0) {
                    col = field.getName();
                }
                ColumnInfo now = new ColumnInfo();
                now.setTableFieldName(col);
                now.setType(annotation.type());
                now.setSize(annotation.size());
                now.setNullable(annotation.isNullable());
                if (!columnDefine.getColumnInfos().containsKey(col)) {
                    this.appendError(result, sb, "\u8868\uff1a" + tableName + "[" + bean.getSimpleName() + "]" + "\uff0c\u5b57\u6bb5\uff1a" + field.getName() + ",\u5b57\u6bb5\u7f3a\u5931");
                    continue;
                }
                ColumnInfo columnInfo = columnDefine.getColumnInfos().get(col);
                if (!RecorderUtil.isSame(now, columnInfo)) {
                    this.appendError(result, sb, "\u8868\uff1a" + tableName + "[" + bean.getSimpleName() + "]" + "\uff0c\u5b57\u6bb5\uff1a" + field.getName() + ",\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef,'" + now + "'\uff01");
                    continue;
                }
                if (annotation.primary() && !columnDefine.getPrimaryKeys().contains(col) || !annotation.primary() && columnDefine.getPrimaryKeys().contains(col)) {
                    this.appendError(result, sb, "\u8868\uff1a" + tableName + "[" + bean.getSimpleName() + "]" + "\uff0c\u5b57\u6bb5\uff1a" + field.getName() + ",\u4e3b\u952e\u9519\u8bef");
                    continue;
                }
                if (columnInfo.isNullable() == now.isNullable()) continue;
                this.appendError(result, sb, "\u8868\uff1a" + tableName + "[" + bean.getSimpleName() + "]" + "\uff0c\u5b57\u6bb5\uff1a" + field.getName() + ",\u4e3a\u7a7a\u4e0d\u4e00\u81f4");
            }
            for (String dbColumnName : columnDefine.getColumnInfos().keySet()) {
                boolean contains = false;
                for (Field field : fields) {
                    if (field.getAnnotation(FieldCheck.class) == null || !field.getName().equals(dbColumnName)) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                sb.append(tableName + "[" + bean.getSimpleName() + "]" + "\uff1a\u6570\u636e\u5e93\u591a\u51fa\u5b57\u6bb5\uff1a'" + dbColumnName + "'\uff01").append(line);
                result.error = true;
            }
        }
        result.report = sb.toString();
        return result;
    }

    public void clearTables() {
        this.tables.clear();
    }

    public void registTable(Class<?> bean) throws TableCheckException {
        TableCheck annotation = bean.getAnnotation(TableCheck.class);
        if (annotation == null) {
            throw new TableCheckException("bean need TableCheck annotation!");
        }
        String table = annotation.value();
        if (table == null || table.trim().length() == 0) {
            this.registTable(bean, bean.getSimpleName());
        } else {
            String[] split;
            for (String temp : split = table.split("[,]")) {
                this.registTable(bean, temp);
            }
        }
    }

    public void registTable(Class<?> bean, String tableName) throws TableCheckException {
        if (this.tables.containsKey(tableName)) {
            throw new TableCheckException("table name '" + tableName + "' duplicated!");
        }
        this.tables.put(tableName, bean);
        log.debug("add into table check list:{}[{}]", (Object)tableName, (Object)bean.getSimpleName());
    }

    public void registTable(String packageName, Class<?> superClass) throws TableCheckException, ClassNotFoundException, IOException {
        List<Object> classes = new ArrayList();
        classes = ReflectionUtil.getClassesByPackage(packageName, superClass);
        log.debug("package\uff1a{}\uff0cscan classes\uff1a{}\u3002", (Object)packageName, (Object)classes.size());
        for (Class clazz : classes) {
            TableCheck annotation = clazz.getAnnotation(TableCheck.class);
            if (annotation == null) {
                log.error("Table `" + clazz.getSimpleName().toLowerCase() + "` need checked!!! Use @TableCheck and @FieldCheck");
                continue;
            }
            this.registTable(clazz);
        }
    }

    private void appendError(TableCheckResult result, StringBuilder sb, String value) {
        sb.append(value).append(System.getProperty("line.separator"));
        result.error = true;
    }

    public class TableCheckResult {
        private boolean error = false;
        private String report;

        public boolean isError() {
            return this.error;
        }

        public String getReport() {
            return this.report;
        }
    }
}

