/*
 * Decompiled with CFR 0.152.
 */
package org.slinkyframework.environment.docker.test;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slinkyframework.environment.docker.DockerDriver;
import org.slinkyframework.environment.docker.PortSelector;
import org.slinkyframework.environment.docker.test.matchers.HasPortAvailableMatcher;

public class DockerDriverIntegrationTest {
    private static final String CONTAINER_NAME = "tomcat";
    private static final String IMAGE_NAME = "tomcat:8.0";
    private static final int TOMCAT_INTERNAL_PORT = 8080;
    private static final String ENVIRONMENT_DOCKER_MACHINE_NAME = "DOCKER_MACHINE_NAME";
    private static final String DEFAULT_DOCKER_MACHINE_NAME = "localhost";
    private String dockerMachineName = "dev";

    @Before
    public void setUp() {
        this.dockerMachineName = System.getenv(ENVIRONMENT_DOCKER_MACHINE_NAME);
        if (this.dockerMachineName == null) {
            this.dockerMachineName = DEFAULT_DOCKER_MACHINE_NAME;
        }
    }

    @Test
    public void shouldStartAContainer() {
        Map<Integer, Integer> ports = this.createPortsMap();
        DockerDriver testee = new DockerDriver(CONTAINER_NAME, IMAGE_NAME, ports);
        testee.setUpDocker();
        Assert.assertThat((String)"Container", (Object)testee.findExistingContainer().isPresent(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.dockerMachineName, (Matcher)HasPortAvailableMatcher.hasPortAvailable(ports.get(8080)));
    }

    private Map<Integer, Integer> createPortsMap() {
        HashMap<Integer, Integer> ports = new HashMap<Integer, Integer>();
        ports.put(8080, PortSelector.selectFreePort());
        return ports;
    }

    @Test
    public void shouldKillAndRemoveAContainer() {
        Map<Integer, Integer> ports = this.createPortsMap();
        DockerDriver testee = new DockerDriver(CONTAINER_NAME, IMAGE_NAME, ports);
        testee.setUpDocker();
        testee.killAndRemoveContainer();
        Assert.assertThat((String)"Container", (Object)testee.findExistingContainer().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Ignore(value="Takes a long time to run. So ignoring for main run.")
    public void shouldPullDownImageIfOneDoesNotExistLocally() throws Exception {
        Map<Integer, Integer> ports = this.createPortsMap();
        DockerDriver testee = new DockerDriver(CONTAINER_NAME, IMAGE_NAME, ports);
        Optional image = testee.findImage();
        this.removeExistingImage(image);
        testee.setUpDocker();
        Assert.assertThat((String)"Container found", (Object)testee.findExistingContainer().isPresent(), (Matcher)Matchers.is((Object)true));
    }

    private void removeExistingImage(Optional<Image> image) throws DockerException, InterruptedException, DockerCertificateException {
        DefaultDockerClient dockerClient = DefaultDockerClient.fromEnv().build();
        if (image.isPresent()) {
            boolean force = true;
            boolean noPrune = false;
            dockerClient.removeImage(image.get().id(), force, noPrune);
        }
    }
}

